/** $Id: common.h,v 1.3 2009/07/23 22:53:39 gian Exp $ **/

#pragma once
#ifndef F_CPU
#define F_CPU 16000000
#endif
#include <avr/io.h>
#include <util/delay.h>
#include <stdio.h>
#include <stdint.h>
#include <avr/pgmspace.h>

// This just makes my life easier
#define BIT16(b) ((unsigned long)0x00000001 << (b))
#define	BIT8(b) (0x01 << (b))


// from AVR035: Efficient C Coding for AVR 
#define BSET(ADDRESS,BIT) (ADDRESS |= (unsigned char)(1<<BIT)) 
#define BCLR(ADDRESS,BIT) (ADDRESS &= (unsigned char)~(1<<BIT)) 
#define BTOG(ADDRESS,BIT) (ADDRESS ^= (unsigned char)(1<<BIT)) 
#define BCHK(ADDRESS,BIT) (ADDRESS &  (unsigned char)(1<<BIT)) 

#define BMSET(x,y) (x |= (y)) 
#define BMCLR(x,y) (x &= (~y)) 
#define BMTOG(x,y) (x ^= (y)) 
#define BMCHK(x,y) (x & (y)) 

#define IO_IN	0
#define IO_OUT	1



// For binary tree node with index i, it's child nodes can be found at
// 2i + 1 (left) and 2i + 2 (right).

typedef struct
{
	uint8_t		* array;
	uint8_t		idx;
	void *		cargo;

} BinaryTreeArray;


