//////////////////////////////////////////////////////////////////////
/// Name: keypad.h
/// Author: Barry Gian James
/// Description: Just a short example of reading a keypad with an AVR
///              This will be used again later when interfacing to 
///              an external encoding IC.

/** $Id: keypad.c,v 1.3 2009/07/23 22:53:39 gian Exp $ **/

#include "uart.h"
#include <avr/io.h>
#include <util/delay.h>

#define ROW4	PIND2	// pin8
#define ROW3	PIND3 	// pin7
#define ROW2	PIND4	// pin6
#define ROW1	PIND5	// pin5
#define COL4	PIND6	// pin4
#define COL3	PIND7	// pin3
#define COL2	PINB0	// pin2
#define COL1	PINB1	// pin1

#define BIT(i) 	(1 << i)

#define ROW_MASK	0b00111100		// mask PD[2..5]
#define PORTD_MASK	0b11000000		// mask PD[6..7]
#define PORTB_MASK	0b00000011		// mask PB[0..1]



int main()
{
	DDRD = ROW_MASK;	// ROWS are outputs
	DDRB = 0x00;		// PORTB input


	USART_init(BAUD_9600);
		
	uint8_t		i, bkey;
	uint8_t		numPressed = 0xFF;
	for (;;)
	{
		for (i=5;i>1;i--) 		// From Row[1..4]
		{
			PORTD |= BIT((i));
			asm volatile("nop\n\t"::);

			if (PINB & BIT(COL1)) {
				numPressed = ((4*(5-i)));
				USART_tx(numPressed);
			}
			else if (PINB & BIT(COL2)) {
				numPressed = ((4*(5-i)) +  1);
				USART_tx(numPressed);
			}  
			else if (PIND & BIT(COL3)) {
				numPressed = ((4*(5-i)) + 2);
				USART_tx(numPressed);
			}
			else if (PIND & BIT(COL4)) {
				numPressed = ((4*(5-i)) + 3 );
				USART_tx(numPressed);
			}

			_delay_ms(45);		// debounce
			PORTD &= ~BIT((i));	
		}
		
	}

}

