//////////////////////////////////////////////////////////////////////
/// Name: keypad.h
/// Author: Barry Gian James
/// Description: Just a short example of reading a keypad with an AVR
///              This will be used again later when interfacing to 
///              an external encoding IC.

/** $Id: keypad.c,v 1.4 2009/07/25 18:23:59 gian Exp $ **/

#include "common.h"
#include "uart.h"
#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>

#define DATA1	PIND2
#define DATA2	PIND3
#define DATA3	PIND4
#define DATA4	PIND5
#define DATA_AVAIL PIND6

void Interrupt_init(void);
volatile uint8_t	bDataReady = 0;

int main()
{
	// Initialize serial subsystem
	USART_init(BAUD_9600);
	// Initialize PCI2
	Interrupt_init();

	uint8_t	encoded = 0x00;		
	for (;;)
	{
		if (bDataReady)
		{
			encoded = GPIOR0;
			USART_tx(encoded);
			bDataReady = 0;	
			GPIOR0 = 0x00;
		}		
	}

}

// This is our pin change interrupt handler
ISR(PCINT2_vect)
{
	if (BCHK(PIND,DATA_AVAIL) == 0)
		return;
	if (BCHK(PIND,DATA1))
		BSET(GPIOR0,GPIOR00);
	if (BCHK(PIND,DATA2))
		BSET(GPIOR0,GPIOR01);
	if (BCHK(PIND,DATA3))
		BSET(GPIOR0,GPIOR02);
	if (BCHK(PIND,DATA4))
		BSET(GPIOR0,GPIOR03);
	
	bDataReady = 1;
}

void
Interrupt_init(void)
{
	BSET(PCICR,PCIE2);		// Enable Pin Change Interrupt 2
	BSET(PCMSK2,PCINT22);	// Enable PCINT22 (that's PD6)
	BSET(SREG,7);			// Set I-bit in Status Register
	GPIOR0 = 0x00;			// Using General Purpose I/O register
}
