/*
  Fade Input Demo
  with vibe board and LED output
*/


int ledPin = 3;
int vibePin = 9;
int buttonPin = 2;

int buttonState = 0;


void setup() {
  Serial.begin(9600);

  pinMode(buttonPin, INPUT_PULLUP);
}

void loop() {

  buttonState = digitalRead(buttonPin);

  Serial.println(buttonState);


  if (buttonState == LOW) {
    // fade in from min to max in increments of 5 points:
    for (int fadeValue = 0 ; fadeValue <= 255; fadeValue += 5) {
      // sets the value (range from 0 to 255):
      analogWrite(ledPin, fadeValue);
      // wait for 30 milliseconds to see the dimming effect
      delay(30);
    }
    for (int fadeValue = 255 ; fadeValue >= 0; fadeValue -= 5) {
      // sets the value (range from 0 to 255):
      analogWrite(ledPin, fadeValue);
      // wait for 30 milliseconds to see the dimming effect
      delay(30);
    }
    // turn vibe on to lowest intesity
    analogWrite(vibePin, 140);
  } else {
    // sets the value (range from 0 to 255):
    analogWrite(ledPin, 100);
    //turn vibe on to highest intensity
    analogWrite(vibePin, 255);
  }
}
