/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import android.util.Log;
import com.android.build.gradle.internal.incremental.PatchesLoader;
import java.lang.reflect.Field;

public abstract class AbstractPatchesLoaderImpl
implements PatchesLoader {
    public abstract String[] getPatchedClasses();

    @Override
    public boolean load() {
        try {
            for (String className : this.getPatchedClasses()) {
                Field isObsolete;
                ClassLoader cl = this.getClass().getClassLoader();
                Class<?> aClass = cl.loadClass(className + "$override");
                Object o = aClass.newInstance();
                Class<?> originalClass = cl.loadClass(className);
                Field changeField = originalClass.getDeclaredField("$change");
                changeField.setAccessible(true);
                Object previous = changeField.get(null);
                if (previous != null && (isObsolete = previous.getClass().getDeclaredField("$obsolete")) != null) {
                    isObsolete.set(null, true);
                }
                changeField.set(null, o);
                Log.i((String)"fd", (String)String.format("patched %s", className));
            }
        }
        catch (Exception e) {
            Log.e((String)"fd", (String)String.format("Exception while patching %s", "foo.bar"), (Throwable)e);
            return false;
        }
        return true;
    }
}

