/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.util.Log;
import com.android.tools.fd.runtime.AppInfo;
import com.android.tools.fd.runtime.FileManager;
import com.android.tools.fd.runtime.IncrementalClassLoader;
import com.android.tools.fd.runtime.MonkeyPatcher;
import com.android.tools.fd.runtime.Server;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class BootstrapApplication
extends Application {
    public static final String LOG_TAG = "fd";
    private String externalResourcePath;
    private Application realApplication;

    public BootstrapApplication() {
        if (Log.isLoggable((String)LOG_TAG, (int)4)) {
            Log.i((String)LOG_TAG, (String)String.format("BootstrapApplication created. Android package is %s, real application class is %s.", AppInfo.applicationId, AppInfo.applicationClass));
        }
    }

    private void createResources(long apkModified) {
        File file = FileManager.getExternalResourceFile();
        String string = this.externalResourcePath = file != null ? file.getPath() : null;
        if (Log.isLoggable((String)LOG_TAG, (int)4)) {
            Log.i((String)LOG_TAG, (String)("Resource override is " + this.externalResourcePath));
        }
        if (file != null) {
            try {
                long resourceModified = file.lastModified();
                if (Log.isLoggable((String)LOG_TAG, (int)4)) {
                    Log.i((String)LOG_TAG, (String)("Resource patch last modified: " + resourceModified));
                    Log.i((String)LOG_TAG, (String)("APK last modified: " + apkModified + " " + (apkModified > resourceModified ? ">" : "<") + " resource patch"));
                }
                if (apkModified == 0L || resourceModified <= apkModified) {
                    if (Log.isLoggable((String)LOG_TAG, (int)4)) {
                        Log.i((String)LOG_TAG, (String)"Ignoring resource file, older than APK");
                    }
                    this.externalResourcePath = null;
                }
            }
            catch (Throwable t) {
                Log.e((String)LOG_TAG, (String)"Failed to check patch timestamps", (Throwable)t);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createRealApplication(String codeCacheDir, long apkModified) {
        void var4_5;
        List<String> list = FileManager.getDexList();
        Class<Server> server = Server.class;
        Class<MonkeyPatcher> patcher = MonkeyPatcher.class;
        if (!list.isEmpty()) {
            try {
                File lastClass = new File(list.get(0));
                long codeModified = lastClass.lastModified();
                if (Log.isLoggable((String)LOG_TAG, (int)4)) {
                    Log.i((String)LOG_TAG, (String)("Last code patch: " + lastClass));
                    Log.i((String)LOG_TAG, (String)("Last patch last modified: " + codeModified));
                    Log.i((String)LOG_TAG, (String)("APK last modified: " + apkModified + " " + (apkModified > codeModified ? ">" : "<") + " code patch"));
                }
                if (apkModified == 0L || codeModified <= apkModified) {
                    if (Log.isLoggable((String)LOG_TAG, (int)4)) {
                        Log.i((String)LOG_TAG, (String)"Ignoring code patches, older than APK");
                    }
                    List list2 = Collections.emptyList();
                }
            }
            catch (Throwable t) {
                Log.e((String)LOG_TAG, (String)"Failed to check patch timestamps", (Throwable)t);
            }
        } else if (Log.isLoggable((String)LOG_TAG, (int)4)) {
            Log.i((String)LOG_TAG, (String)"No override .dex files found");
        }
        if (!var4_5.isEmpty()) {
            if (Log.isLoggable((String)LOG_TAG, (int)4)) {
                Log.i((String)LOG_TAG, (String)("Bootstrapping class loader with dex list " + var4_5));
            }
            String nativeLibraryPath = FileManager.getNativeLibraryFolder().getPath();
            ClassLoader classLoader = BootstrapApplication.class.getClassLoader();
            IncrementalClassLoader.inject(classLoader, nativeLibraryPath, codeCacheDir, (List<String>)var4_5);
        }
        if (AppInfo.applicationClass != null) {
            if (Log.isLoggable((String)LOG_TAG, (int)4)) {
                Log.i((String)LOG_TAG, (String)("About to create real application of class name = " + AppInfo.applicationClass));
            }
            try {
                Class<?> realClass = Class.forName(AppInfo.applicationClass);
                if (Log.isLoggable((String)LOG_TAG, (int)4)) {
                    Log.i((String)LOG_TAG, (String)("Created delegate app class successfully : " + realClass + " with class loader " + realClass.getClassLoader()));
                }
                Constructor<?> constructor = realClass.getConstructor(new Class[0]);
                this.realApplication = (Application)constructor.newInstance(new Object[0]);
                if (!Log.isLoggable((String)LOG_TAG, (int)4)) return;
                Log.i((String)LOG_TAG, (String)("Created real app instance successfully :" + this.realApplication));
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.realApplication = new Application();
        }
    }

    protected void attachBaseContext(Context context) {
        String apkFile = context.getApplicationInfo().sourceDir;
        long apkModified = apkFile != null ? new File(apkFile).lastModified() : 0L;
        this.createResources(apkModified);
        this.createRealApplication(context.getCacheDir().getPath(), apkModified);
        super.attachBaseContext(context);
        if (this.realApplication != null) {
            try {
                Method attachBaseContext = ContextWrapper.class.getDeclaredMethod("attachBaseContext", Context.class);
                attachBaseContext.setAccessible(true);
                attachBaseContext.invoke((Object)this.realApplication, context);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void onCreate() {
        MonkeyPatcher.monkeyPatchApplication((Context)this, this, this.realApplication, this.externalResourcePath);
        MonkeyPatcher.monkeyPatchExistingResources((Context)this, this.externalResourcePath, null);
        super.onCreate();
        if (AppInfo.applicationId != null) {
            Server.create(AppInfo.applicationId, this);
        }
        if (this.realApplication != null) {
            this.realApplication.onCreate();
        }
    }
}

