/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.android.tools.fd.runtime.AppInfo;
import dalvik.system.DexFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileManager {
    private static final boolean USE_EXTRACTED_RESOURCES = false;
    private static final String RESOURCE_FILE_NAME = "resources.ap_";
    private static final String RESOURCE_FOLDER_NAME = "resources";
    private static final String FILE_NAME_ACTIVE = "active";
    private static final String FOLDER_NAME_LEFT = "left";
    private static final String FOLDER_NAME_RIGHT = "right";
    private static final String CLASSES_DEX_PREFIX = "classes";
    public static final String CLASSES_DEX_SUFFIX = ".dex";
    public static final String CLASSES_DEX_3_SUFFIX = ".dex.3";
    private static final String EXT_INDEX_FILE = ".index";

    private static File getDataFolder() {
        return new File("/data/data/" + AppInfo.applicationId + "/files/studio-fd");
    }

    @NonNull
    private static File getResourceFile(File base) {
        return new File(base, RESOURCE_FILE_NAME);
    }

    @NonNull
    private static File getDexFileFolder(File base) {
        return new File(base, "dex");
    }

    @NonNull
    private static File getTempDexFileFolder(File base) {
        return new File(base, "dex-temp");
    }

    public static File getNativeLibraryFolder() {
        return new File(FileManager.getDataFolder(), "lib");
    }

    @NonNull
    public static File getReadFolder() {
        String name = FileManager.leftIsActive() ? FOLDER_NAME_LEFT : FOLDER_NAME_RIGHT;
        return new File(FileManager.getDataFolder(), name);
    }

    public static void swapFolders() {
        FileManager.setLeftActive(!FileManager.leftIsActive());
    }

    @NonNull
    public static File getWriteFolder(boolean wipe) {
        String name = FileManager.leftIsActive() ? FOLDER_NAME_RIGHT : FOLDER_NAME_LEFT;
        File folder = new File(FileManager.getDataFolder(), name);
        if (wipe && folder.exists()) {
            FileManager.delete(folder);
            boolean mkdirs = folder.mkdirs();
            if (!mkdirs) {
                Log.e((String)"fd", (String)("Failed to create folder " + folder));
            }
        }
        return folder;
    }

    private static void delete(@NonNull File file) {
        boolean deleted;
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                FileManager.delete(child);
            }
        }
        if (!(deleted = file.delete())) {
            Log.e((String)"fd", (String)("Failed to delete file " + file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean leftIsActive() {
        boolean bl;
        File folder = FileManager.getDataFolder();
        File pointer = new File(folder, FILE_NAME_ACTIVE);
        if (!pointer.exists()) {
            return true;
        }
        BufferedReader reader = new BufferedReader(new FileReader(pointer));
        try {
            String line = reader.readLine();
            bl = FOLDER_NAME_LEFT.equals(line);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ignore) {
                return true;
            }
        }
        reader.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLeftActive(boolean active) {
        File folder = FileManager.getDataFolder();
        File pointer = new File(folder, FILE_NAME_ACTIVE);
        if (pointer.exists()) {
            boolean deleted = pointer.delete();
            if (!deleted) {
                Log.e((String)"fd", (String)("Failed to delete file " + pointer));
            }
        } else if (!folder.exists()) {
            boolean create = folder.mkdirs();
            if (!create) {
                Log.e((String)"fd", (String)("Failed to create directory " + folder));
            }
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pointer), "UTF-8"));
            try {
                writer.write(active ? FOLDER_NAME_LEFT : FOLDER_NAME_RIGHT);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public static File getExternalResourceFile() {
        File file = FileManager.getResourceFile(FileManager.getReadFolder());
        if (!file.exists()) {
            Log.v((String)"fd", (String)"Cannot find external resources, not patching them in");
            return null;
        }
        return file;
    }

    @NonNull
    public static List<String> getDexList() {
        File dataFolder = FileManager.getDataFolder();
        FileManager.purgeTempDexFiles(dataFolder);
        FileManager.purgeMaskedDexFiles(dataFolder);
        ArrayList<String> list = new ArrayList<String>();
        File[] dexFiles = FileManager.getDexFileFolder(dataFolder).listFiles();
        if (dexFiles == null) {
            Log.v((String)"fd", (String)"Cannot find newer dex classes, not patching them in");
            return list;
        }
        for (File dex : dexFiles) {
            if (!dex.getName().endsWith(CLASSES_DEX_SUFFIX)) continue;
            list.add(dex.getPath());
        }
        Collections.sort(list, Collections.reverseOrder());
        return list;
    }

    @Nullable
    public static File getNextDexFile() {
        boolean created;
        File dexFolder = FileManager.getDexFileFolder(FileManager.getDataFolder());
        if (!dexFolder.exists() && !(created = dexFolder.mkdirs())) {
            Log.e((String)"fd", (String)("Failed to create directory " + dexFolder));
            return null;
        }
        File[] files = dexFolder.listFiles();
        int max = -1;
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith(CLASSES_DEX_PREFIX) || !name.endsWith(CLASSES_DEX_SUFFIX)) continue;
                String middle = name.substring(CLASSES_DEX_PREFIX.length(), name.length() - CLASSES_DEX_SUFFIX.length());
                try {
                    int version = Integer.decode(middle);
                    if (version <= max) continue;
                    max = version;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
        String fileName = String.format("%s0x%04x%s", CLASSES_DEX_PREFIX, max + 1, CLASSES_DEX_SUFFIX);
        File file = new File(dexFolder, fileName);
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)("Writing new dex file: " + file));
        }
        return file;
    }

    @Nullable
    public static File getTempDexFile() {
        boolean created;
        File dexFolder = FileManager.getTempDexFileFolder(FileManager.getDataFolder());
        if (!dexFolder.exists() && !(created = dexFolder.mkdirs())) {
            Log.e((String)"fd", (String)("Failed to create directory " + dexFolder));
            return null;
        }
        File[] files = dexFolder.listFiles();
        int max = -1;
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith(CLASSES_DEX_PREFIX) || !name.endsWith(CLASSES_DEX_SUFFIX)) continue;
                String middle = name.substring(CLASSES_DEX_PREFIX.length(), name.length() - CLASSES_DEX_SUFFIX.length());
                try {
                    int version = Integer.decode(middle);
                    if (version <= max) continue;
                    max = version;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
        String fileName = String.format("%s0x%04x%s", CLASSES_DEX_PREFIX, max + 1, CLASSES_DEX_SUFFIX);
        File file = new File(dexFolder, fileName);
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)("Writing new dex file: " + file));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeRawBytes(@NonNull File destination, @NonNull byte[] bytes) {
        boolean bl;
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destination));
        try {
            output.write(bytes);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                output.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Log.e((String)"fd", (String)("Failed to write resource file " + destination), (Throwable)ioe);
                return false;
            }
        }
        output.close();
        return bl;
    }

    public static boolean extractZip(@NonNull File destination, @NonNull byte[] zipBytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(zipBytes);
        return FileManager.extractZip(destination, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractZip(@NonNull File resourceDir, @NonNull InputStream inputStream) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            ZipEntry entry = zipInputStream.getNextEntry();
            byte[] buffer = new byte[2000];
            while (entry != null) {
                String name = entry.getName();
                if (name.startsWith("META-INF")) continue;
                File dest = new File(resourceDir, name);
                if (!entry.isDirectory()) {
                    boolean created;
                    File parent = dest.getParentFile();
                    if (parent != null && !parent.exists() && !(created = parent.mkdirs())) {
                        Log.e((String)"fd", (String)("Failed to create directory " + dest));
                        return false;
                    }
                    BufferedOutputStream src = new BufferedOutputStream(new FileOutputStream(dest));
                    try {
                        int bytesRead;
                        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                            ((OutputStream)src).write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        ((OutputStream)src).close();
                    }
                }
                entry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
            return true;
        }
        catch (IOException ioe) {
            Log.e((String)"fd", (String)("Failed to extract zip contents into directory " + resourceDir), (Throwable)ioe);
            return false;
        }
    }

    public static void startUpdate() {
        FileManager.getWriteFolder(true);
    }

    public static void finishUpdate(boolean wroteResources) {
        if (wroteResources) {
            FileManager.swapFolders();
        }
    }

    @Nullable
    public static File writeDexFile(@NonNull byte[] bytes, boolean writeIndex) {
        File file = FileManager.getNextDexFile();
        if (file != null) {
            FileManager.writeRawBytes(file, bytes);
            if (writeIndex) {
                File indexFile = FileManager.getIndexFile(file);
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indexFile), FileManager.getUtf8Charset()));
                    DexFile dexFile = new DexFile(file);
                    Enumeration entries = dexFile.entries();
                    while (entries.hasMoreElements()) {
                        String nextPath = (String)entries.nextElement();
                        if (nextPath.indexOf(36) != -1) continue;
                        writer.write(nextPath);
                        writer.write(10);
                    }
                    writer.close();
                    if (Log.isLoggable((String)"fd", (int)4)) {
                        Log.i((String)"fd", (String)("Wrote restart patch index " + indexFile));
                    }
                }
                catch (IOException ioe) {
                    Log.e((String)"fd", (String)("Failed to write dex index file " + indexFile));
                }
            }
        }
        return file;
    }

    public static void writeAaptResources(@NonNull String relativePath, @NonNull byte[] bytes) {
        boolean created;
        File resourceFile = FileManager.getResourceFile(FileManager.getWriteFolder(false));
        File file = resourceFile;
        File folder = file.getParentFile();
        if (!folder.isDirectory() && !(created = folder.mkdirs())) {
            if (Log.isLoggable((String)"fd", (int)4)) {
                Log.i((String)"fd", (String)("Cannot create local resource file directory " + folder));
            }
            return;
        }
        if (relativePath.equals(RESOURCE_FILE_NAME)) {
            FileManager.writeRawBytes(file, bytes);
        } else {
            FileManager.writeRawBytes(file, bytes);
        }
    }

    @Nullable
    public static String writeTempDexFile(byte[] bytes) {
        File file = FileManager.getTempDexFile();
        if (file != null) {
            FileManager.writeRawBytes(file, bytes);
            return file.getPath();
        }
        Log.e((String)"fd", (String)"No file to write temp dex content to");
        return null;
    }

    private static File getIndexFile(@NonNull File file) {
        return new File(file.getPath() + EXT_INDEX_FILE);
    }

    private static File getDexFile(@NonNull File file) {
        String path = file.getPath();
        return new File(path.substring(0, path.length() - EXT_INDEX_FILE.length()));
    }

    public static void purgeTempDexFiles(@NonNull File dataFolder) {
        File dexFolder = FileManager.getTempDexFileFolder(dataFolder);
        if (!dexFolder.isDirectory()) {
            return;
        }
        File[] files = dexFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            boolean deleted;
            if (!file.getPath().endsWith(CLASSES_DEX_SUFFIX) || (deleted = file.delete())) continue;
            Log.e((String)"fd", (String)("Could not delete temp dex file " + file));
        }
    }

    public static void purgeMaskedDexFiles(@NonNull File dataFolder) {
        File dexFolder = FileManager.getDexFileFolder(dataFolder);
        if (!dexFolder.isDirectory()) {
            return;
        }
        Object[] files = dexFolder.listFiles();
        if (files == null || files.length < 2) {
            return;
        }
        Arrays.sort(files);
        HashSet<String> classes = new HashSet<String>(200);
        Charset utf8 = FileManager.getUtf8Charset();
        for (int i = files.length - 1; i >= 0; --i) {
            Object file = files[i];
            String path = ((File)file).getPath();
            if (!path.endsWith(EXT_INDEX_FILE)) continue;
            try {
                boolean deleted;
                String line;
                InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream((File)file), utf8);
                BufferedReader reader = new BufferedReader(is);
                boolean containsUniqueClasses = false;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || classes.contains(line)) continue;
                    classes.add(line);
                    containsUniqueClasses = true;
                }
                reader.close();
                if (containsUniqueClasses) continue;
                File dexFile = FileManager.getDexFile((File)file);
                if (dexFile.exists()) {
                    if (Log.isLoggable((String)"fd", (int)4)) {
                        Log.i((String)"fd", (String)("Removing dex patch " + dexFile + ": All classes in it are hidden by later patches"));
                    }
                    if (!(deleted = dexFile.delete())) {
                        Log.e((String)"fd", (String)("Could not prune " + dexFile));
                    }
                }
                if (deleted = ((File)file).delete()) continue;
                Log.e((String)"fd", (String)("Could not prune " + file));
                continue;
            }
            catch (IOException ioe) {
                Log.e((String)"fd", (String)("Could not read dex index file " + file), (Throwable)ioe);
            }
        }
    }

    @NonNull
    private static Charset getUtf8Charset() {
        Charset utf8 = Build.VERSION.SDK_INT >= 19 ? StandardCharsets.UTF_8 : Charset.forName("UTF-8");
        return utf8;
    }

    public static long getFileSize(@NonNull String path) {
        File file;
        if (path.equals(RESOURCE_FILE_NAME) && (file = FileManager.getExternalResourceFile()) != null) {
            return file.length();
        }
        return -1L;
    }

    @Nullable
    public static byte[] getCheckSum(@NonNull String path) {
        File file;
        if (path.equals(RESOURCE_FILE_NAME) && (file = FileManager.getExternalResourceFile()) != null) {
            return FileManager.getCheckSum(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static byte[] getCheckSum(@NonNull File file) {
        block10: {
            byte[] byArray;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[4096];
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                int read;
                while ((read = input.read(buffer)) != -1) {
                    digest.update(buffer, 0, read);
                }
                byArray = digest.digest();
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    if (Log.isLoggable((String)"fd", (int)6)) {
                        Log.e((String)"fd", (String)"Couldn't look up message digest", (Throwable)e);
                    }
                    break block10;
                }
                catch (IOException ioe) {
                    if (Log.isLoggable((String)"fd", (int)6)) {
                        Log.e((String)"fd", (String)("Failed to read file " + file), (Throwable)ioe);
                    }
                    break block10;
                }
                catch (Throwable t) {
                    if (!Log.isLoggable((String)"fd", (int)6)) break block10;
                    Log.e((String)"fd", (String)"Unexpected checksum exception", (Throwable)t);
                }
            }
            input.close();
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readRawBytes(@NonNull File source) {
        byte[] byArray;
        long length;
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)("Reading the bytes for file " + source));
        }
        if ((length = source.length()) > Integer.MAX_VALUE) {
            if (Log.isLoggable((String)"fd", (int)4)) {
                Log.i((String)"fd", (String)("File too large (" + length + ")"));
            }
            return null;
        }
        byte[] result = new byte[(int)length];
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(source));
        try {
            int numRead;
            int index = 0;
            for (int remaining = result.length - index; remaining > 0 && (numRead = input.read(result, index, remaining)) != -1; remaining -= numRead) {
                index += numRead;
            }
            if (Log.isLoggable((String)"fd", (int)4)) {
                Log.i((String)"fd", (String)("Returning length " + result.length + " for file " + source));
            }
            byArray = result;
        }
        catch (Throwable throwable) {
            try {
                input.close();
                throw throwable;
            }
            catch (IOException ioe) {
                if (Log.isLoggable((String)"fd", (int)6)) {
                    Log.e((String)"fd", (String)("Failed to read file " + source), (Throwable)ioe);
                }
                if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)("I/O error, no bytes returned for " + source));
                }
                return null;
            }
        }
        input.close();
        return byArray;
    }
}

