/*///////////////////////////////////////////////////////////////
Project Automation Weather Station
Nama : Adrie Sentosa
NRP  : 2212100078
//////////////////////////////////////////////////////////////////
 Pin Configuration
Soil Humidity  A0
Rain Drop      A1
SDA            A4
SCL            A5
DHT11 Data     D2
DS18b20 Data   D3
*/
int result [5];
//set BMP180
#include <Wire.h> //Including wire library
#include <SFE_BMP180.h> //Including BMP180 library
#define ALTITUDE 3 //Altitude where I live (change this to your altitude)
SFE_BMP180 pressure; //Creating an object
//set DHT11
#include <DHT.h>
#define DHTPIN 2
#define DHTTYPE DHT11 
DHT dht(DHTPIN, DHTTYPE);
//set Ds18b20
#include <OneWire.h>
#include <DallasTemperature.h>
#define ONE_WIRE_BUS 3
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);
/////////////////////////////////////////////////////////////////
char dataString[50] = {0};

void setup() {
Serial.begin(9600);  //Starting serial communication
//Serial.println("Program started");
//DS18b20 setup
sensors.begin();
//Analog setup
pinMode(A0, INPUT);  //Soil
pinMode(A1, INPUT);  //Rain
//BMP180 Setup
if (pressure.begin()) //If initialization was successful, continue
 /*
 Serial.println("BMP180 init success");
 Serial.print("AWS :");
 Serial.print("\t");
 Serial.print("Rain Drop\t");
 Serial.print("Soil Hum\t");
 Serial.print("Pressure \t");
 Serial.print("Air Hum\t");
 Serial.print("\t");
 Serial.println("Temp \t");}
 */
;
else //Else, stop code forever
  {
    Serial.println("BMP180 init fail");
    while (1);
  }
//DHT11 setup
dht.begin();
}

void loop() {
//analog setup
int A_Rain = analogRead(A0);
int A_Soil = analogRead(A1); 
A_Rain = map(A_Rain, 800, 1023, 100, 0);
A_Soil = map(A_Soil, 400, 1023, 100, 0);
result[0]=A_Soil;
result[1]=A_Rain;
//bmp180 setup
char status;
double T, P, p0; 
status = pressure.startTemperature();
if (status != 0) {
    delay(status);
    status = pressure.getTemperature(T);
    if (status != 0) {
    status = pressure.startPressure(3);
      if (status != 0) {
        delay(status);
        status = pressure.getPressure(P, T);
        if (status != 0) {
          p0 = pressure.sealevel(P, ALTITUDE);
          result[2]=p0;
        }}}}
//DHT11 setup
result[3] = dht.readHumidity();
result[4] = dht.readTemperature();
//DS18b20 setup
//sensors.requestTemperatures();
//result[5] = sensors.getTempCByIndex(0); 
//print the code to serial monitor
/*
Serial.print("AWS : ");
Serial.print(" \t");
Serial.print(result[0]);
Serial.print(" %\t");
Serial.print("\t");
Serial.print(result[1]);
Serial.print(" %\t");
Serial.print("\t");
Serial.print(result[2]);
Serial.print(" hPa \t");
Serial.print(result[3]);
Serial.print(" %\t");
Serial.print("\t");
Serial.print(result[4]);
Serial.println("C \t");
*/
sprintf(dataString,"%02X;%02X;%02X;%02X;%02X;%02X",result[0],result[1],result[2],result[3],result[4],0);
Serial.println(dataString);

//Serial.print(result[5]);
//Serial.println("C \t");
delay(5000);
}
