/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package beesignqueen;

import com.rapplogic.xbee.api.XBeeException;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.Vector;
import org.apache.log4j.Logger;

import org.apache.log4j.PropertyConfigurator;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.zigbee.ZNetRxResponse;
import com.rapplogic.xbee.api.zigbee.ZNetTxRequest;
import com.rapplogic.xbee.api.zigbee.ZNetTxStatusResponse;
import com.rapplogic.xbee.util.ByteUtils;

import com.BeeProject.Libs.BeeFileWriter;
import com.BeeProject.Libs.BeeData;
import gnu.io.CommPortIdentifier;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JMenuItem;

import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

/**
 *
 * @author quasiben
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */ 

public class QueenXBeeSendReceive implements ActionListener{
    public static MainWindow localGUI;
    public int count;
    public final static Logger log = Logger.getLogger(QueenXBeeSendReceive.class);
    private XBee xbee = new XBee();
    private BeeFileWriter writer = new BeeFileWriter();
    private BeeData beeData = new BeeData();
    int CurBeeId = 0;
    long startTime = System.currentTimeMillis();
    int valInFlower = 0;
    int currentTime;
    
    public boolean VectorCreated = false;
    
    
    QueenXBeeSendReceive(MainWindow GUI) {
        localGUI = GUI;
        PropertyConfigurator.configure("log4j.properties");
    }
    
    public void setup() {
        try {
            System.out.println("Setting Table Values");
            xbee.open(localGUI.PortId, 9600);
            System.out.println("Setting Table Values");
            writer.SetFileName("BeeData-"+getDateTime()+".dat");
            printGUI("Getting GUI");
            System.out.println("86:"+beeData.GetFlowerId(86));
            System.out.println("173:"+beeData.GetFlowerId(173));
            System.out.println("257:"+beeData.GetFlowerId(257));
            System.out.println("428:"+beeData.GetFlowerId(428));
            System.out.println("515:"+beeData.GetFlowerId(515));
            System.out.println("507:"+beeData.GetFlowerId(507));
            System.out.println("598:"+beeData.GetFlowerId(598));
            System.out.println("683:"+beeData.GetFlowerId(683));
            
            for(int i = 0; i < beeData.FlowerVector.size(); i++){
                System.out.println("Vector Val: "+beeData.FlowerVector.elementAt(i));
            }
            //localGUI.getFlowerTable().setValueAt(12,0,3); //[0][0] = 12;
            /*for(int i = 0; i < localGUI.getFlowerTable().getColumnCount(); i++) {
                for(int j = 0; j < localGUI.getFlowerTable().getRowCount(); j++) {
                    printGUI("i: "+i+" j:"+j+" value:"+localGUI.getFlowerTable().getValueAt(j,i));
                    localGUI.getFlowerTable().setValueAt(12,j,i); 
                }
            } */
            //writer.WriteToDisk("Start Collecting Data");
            System.out.println("Finished Setting up");
            printGUI("Finished Setting up");
        }
        catch(Exception e){
            System.out.println("Log Coming");
            System.out.println(e);
        }
    }
    
    public void run(){
        try {
            //dprintGUI("\nping pong: "+count);
            SendAndReceive();
            count++;
        } catch (XBeeException ex) {
            java.util.logging.Logger.getLogger(QueenXBeeSendReceive.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    public void list() {
            // get list of ports available on this particular computer,
            // by calling static method in CommPortIdentifier.
            Enumeration pList = CommPortIdentifier.getPortIdentifiers();
            System.out.println("Listing Ports");
            // Process the list.
            while (pList.hasMoreElements()) {
                System.out.println("Listing Ports");
                CommPortIdentifier cpi = (CommPortIdentifier) pList.nextElement();
                System.out.print("Port " + cpi.getName() + " ");
                JMenuItem menuItem;
                menuItem = new JMenuItem(cpi.getName());
                localGUI.getSerialPortMenu().add(menuItem);
                        
                if (cpi.getPortType() == CommPortIdentifier.PORT_SERIAL) {
                    System.out.println("is a Serial Port: " + cpi);
                } else if (cpi.getPortType() == CommPortIdentifier.PORT_PARALLEL) {
                    System.out.println("is a Parallel Port: " + cpi);
                } else {
                    System.out.println("is an Unknown Port: " + cpi);
                }
            }
        }
    
    public void stop() {
        localGUI.getoutputTextArea().append("\nYou have Stopped.");
        xbee.close();
    }

    public void actionPerformed(ActionEvent arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    public void SendAndReceive() throws XBeeException  {
        try {
            beeData.PacketReturn[3] = 1; //set number of minutes
            // we wait here until a packet is received.
            XBeeResponse response = xbee.getResponse();
            //System.out.println("I AM THE RECEIVER!");
            //printGUI("ping pong: " + count);
            //printGUI("\nI AM THE RECEIVER!");
            log.info("received response " + response.toString());
            //printGUI("" + ApiId.ZNET_RX_RESPONSE);
            //printGUI("" + response.getApiId());
            if (response.getApiId() == ApiId.ZNET_RX_RESPONSE) {
                //Thread.sleep(20);
                ZNetRxResponse rx = (ZNetRxResponse) response;
                // we received a packet from ZNetSenderTest.java
                //log.info("Received RX packet, option is " + rx.getOption() + ", sender 64 address is " + ByteUtils.toBase16(rx.getRemoteAddress64().getAddress()) + ", remote 16-bit address is " + ByteUtils.toBase16(rx.getRemoteAddress16().getAddress()) + ", data is " + ByteUtils.toBase16(rx.getData()));
                //System.out.println(" The data is " + ByteUtils.toBase16(rx.getData()));
                int[] rxAddress = rx.getRemoteAddress64().getAddress();
                String address = ByteUtils.toBase16(rx.getRemoteAddress64().getAddress());
                //System.out.println("Address: " + address);
                //printGUI("\nAddress: " + address);
                int NectarContainer = rx.getData()[1];
                if (!beeData.AddressMapper.containsKey(address)) {
                    beeData.AddressMapper.put(address, beeData.NumTeams);
                    beeData.NumTeams += 1;
                }
                CurBeeId = beeData.AddressMapper.get(address);
                /*System.out.println("Map Number: "+CurBeeId+" Size: "+beeData.AddressMapper.size());
                for(String s : beeData.AddressMapper.keySet()) {
                System.out.println("Key from AddressMap: "+s);
                System.out.println("\tValue from AddressMap: "+beeData.AddressMapper.get(s));
                }*/
                   printGUI("Length of rx "+rx.getData().length);

                for(int i = 0; i < rx.getData().length; i++) {
                    printGUI("Value from MicroController "+i+" :" + rx.getData()[i]);
                }
                //printGUI("Value from MicroController 1: " + rx.getData()[1]);
                //printGUI("Value from MicroController 2: " + rx.getData()[2]);
                //printGUI("Value from MicroController 3: " + rx.getData()[3]);
                //printGUI("Value from MicroController 4: " + rx.getData()[4]);
                currentTime = rx.getData()[3];
                int comVal = (rx.getData()[5] << 8) | rx.getData()[4];
                int FlowerId = beeData.GetFlowerId(comVal);
                printGUI("Combine Value: "+comVal);
                printGUI("FlowerId: " + FlowerId);
                printGUI("Can Receive Nectar From Hive: " + rx.getData()[3]);
                
                //beeData.PacketReturn[1] = beeData.FlowerArray[FlowerId];
                
                //System.out.println("MaxContainer: " + rx.getData()[0]);
                //System.out.println("NectarContainer: " + rx.getData()[1]);
                System.out.println("FlowerArray: " + beeData.FlowerVector.elementAt(FlowerId) + " FlowerId: " + FlowerId);
                printGUI("\nFlowerArray: " + beeData.FlowerVector.elementAt(FlowerId) + " FlowerId: " + FlowerId);
                
                //System.out.println("Address of Sender is " + ByteUtils.toBase16(rx.getRemoteAddress64().getAddress()));

                //System.out.println("Variable Addres: "+ rxAddress);
                //System.out.println("Variable Addres: "+ payload);
                XBeeAddress64 addr64 = new XBeeAddress64(rxAddress);

                // first request we just send 64-bit address.  we get 16-bit network address with status response
                if (FlowerId == 0) { //hive value
                    //reset bee date value but increase team totals
                    printGUI("CurrentTime: "+currentTime);
                    if(currentTime >= 1) {
                        beeData.TeamTotals[CurBeeId] += beeData.NectarValArray[CurBeeId];
                        beeData.NectarValArray[CurBeeId] = 0;
                        beeData.PacketReturn[0] = beeData.NectarValArray[CurBeeId];
                        beeData.PacketReturn[2] = 0; //reset timer and restore energry
                        printGUI("Dumping Data to Hive");
                        valInFlower = 0;
                    }
                    else {
                        beeData.NectarValArray[CurBeeId] = 0;
                        beeData.PacketReturn[0] = beeData.NectarValArray[CurBeeId];
                        beeData.PacketReturn[2] = 0; //reset timer and restore energry
                        printGUI("Ran out Of Energy");
                        valInFlower = 0;
                    }
                }
                else if ( ((beeData.NectarValArray[CurBeeId] >= beeData.MaxContainer) || (beeData.FlowerVector.elementAt(FlowerId) <= 0)) && (currentTime >= 1) ){
                    //do Nothing
                    System.out.println("Do Nothing");
                    beeData.PacketReturn[0] = beeData.NectarValArray[CurBeeId];
                    valInFlower = beeData.FlowerVector.elementAt(FlowerId);
                    beeData.PacketReturn[2] = 1; //continue decrementing enegry timer
                } else if ( (beeData.FlowerVector.elementAt(FlowerId) >= beeData.NectarReturn) && (currentTime >= 1) ){
                    beeData.NectarValArray[CurBeeId] += beeData.NectarReturn;
                    beeData.PacketReturn[0] = beeData.NectarValArray[CurBeeId];
                    valInFlower = beeData.FlowerVector.elementAt(FlowerId)-1;
                    beeData.PacketReturn[2] = 1; //continue decrementing enegry timer
                }
                long elapsedTimeMillis = System.currentTimeMillis() - startTime;
                writer.WriteToDisk(elapsedTimeMillis + " BeeNumber: " + CurBeeId + " NectarContainer: " + beeData.NectarValArray[CurBeeId] + " FlowerId: " + FlowerId + " TeamTotal: " + beeData.TeamTotals[CurBeeId] + " <br/>");
                beeData.PacketReturn[1] = valInFlower; //Decrement below
                //printGUI("Bee Number: " + CurBeeId+" Amount in Flower " + FlowerId + " :" + valInFlower);
                printGUI(elapsedTimeMillis + " BeeNumber: " + CurBeeId + " NectarContainer: " + beeData.NectarValArray[CurBeeId] + " FlowerId: " + FlowerId + " TeamTotal: " + beeData.TeamTotals[CurBeeId] );
                ZNetTxRequest request = new ZNetTxRequest(addr64, beeData.PacketReturn);
                log.debug("zb request is " + request.getXBeePacket().getPacket());
                log.info("sending tx " + request);

                ZNetTxStatusResponse SYNCresponse = (ZNetTxStatusResponse) xbee.sendSynchronous(request, 10000);
                // update frame id for next request
                request.setFrameId(xbee.getNextFrameId());

                if (SYNCresponse.getDeliveryStatus() == ZNetTxStatusResponse.DeliveryStatus.SUCCESS) {
                    // the packet was successfully delivered
                    System.out.println("SUCCESSFUL RETURN!!!");
                    
                    System.out.println("FlowerVector: "+beeData.FlowerVector.get(FlowerId));
                    
                    if( currentTime >= 1) {
                        beeData.FlowerVector.set(FlowerId, beeData.FlowerVector.get(FlowerId) - beeData.NectarReturn <= 0 ? 0 : beeData.FlowerVector.get(FlowerId) - beeData.NectarReturn);
                        System.out.println("FlowerVector: " + beeData.FlowerVector.get(FlowerId));
                        //beeData.FlowerArray[FlowerId] = (beeData.FlowerArray[FlowerId] <= 0) ? 0 : beeData.FlowerArray[FlowerId];
                        beeData.FlowerVector.set(FlowerId, beeData.FlowerVector.get(FlowerId) <= 0 ? 0 : beeData.FlowerVector.get(FlowerId));
                    }
                    localGUI.getFlowerTable().setValueAt(beeData.FlowerVector.get(FlowerId),FlowerId,2); 
                    System.out.println("Current amount in FlowerId: " + FlowerId + " is: " + beeData.FlowerVector.get(FlowerId));
                  // packet failed.  log error
                // it's easy to create this error by unplugging/powering off your remote xbee.  when doing so I get: packet failed due to error: ADDRESS_NOT_FOUND  
                //log.error("packet failed due to error: " + SYNCresponse.getDeliveryStatus());
                }

            } else {
            log.debug("received unexpected packet " + response.toString());
            }
        } catch (Exception e) {
            System.out.println("Error Message Coming...\n"+e);
        //log.error(e);
        }finally{
        System.out.println("Shutting Down and Cleaning Up.");
        }
    }
    
    public void printGUI(String s) {
        localGUI.getoutputTextArea().append("\n"+s);
        localGUI.getoutputTextArea().setCaretPosition(
                localGUI.getoutputTextArea().getDocument().getLength()
                );
       
    }
            
    public void setFlowerArray(int i,int _element) {
        if(VectorCreated) {
            beeData.FlowerVector.set(i, _element);
        }
        else{
            beeData.FlowerVector.add(_element);
        }
        
    }
    
    int convert8to16(char highBits, char lowBits) {
        int val16 = 0;
        //val16 = val16 
        return val16;
    }
    
     private String getDateTime() {
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }
}