//**************************************************************//
//  Name    : Big Bar Graph test using: shiftOutCode                               
//  Author  : Matt Little 
//  Date    : 25/4/2012      
//  Modified: 25/4/12                                 
//  Version : 1.0                                         
//  Notes   : Code for using a 74HC595 Shift Register           //
//          : This outputs 'Kinghtrider' type moving light
//****************************************************************

//Pin connected to ST_CP of 74HC595 (Pin 14)
int latchPin = 8;
//Pin connected to SH_CP of 74HC595 (Pin 11)
int clockPin = 12;
////Pin connected to DS of 74HC595 (Pin 12)
int dataPin = 11;


int displayArray[2]; // An array to store the data to display
int i = 0;        // An integer counter
int ramp = 0;   // A flag to say wether ramping up or ramping down. 0 = ramp up 1 = ramp down

void setup() {
  //set pins to output so you can control the shift register
  pinMode(latchPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);
  Serial.begin(9600);  
}

void loop() {
  
  // This section just creates an int, i , which counts up to 10 then down again
  if(i<=10&&ramp==0)
  {
    i = i++;  // Increment the display
    if(i>=10)
    {
      ramp = 1;  // Do a ramp down
    }
  }
  else if (i>=1&&ramp==1)
  {
   i = i--;
   if(i<=1)
   {
     ramp = 0;  // Do a ramp up
   }
  }


  Serial.println(i, DEC);
  
  convertDisplay (i);  // This function takes a long int and places correct values in the displayArray
    
  // The following section writes the data to the displays (both bar graph and watts)
  // take the latchPin low so 
  // the LEDs don't change while you're sending in bits:
  digitalWrite(latchPin, LOW);
  // shift out the bits:
  // Send data via 2 shift registers:
  shiftOut(dataPin, clockPin, MSBFIRST, displayArray[0]);  
  shiftOut(dataPin, clockPin, MSBFIRST, displayArray[1]); 
  //take the latch pin high so the LEDs will light up:
  digitalWrite(latchPin, HIGH);
  // pause before next value:
  delay(100);
  
}


// This function takes in a long int (0-999)

void convertDisplay (long data) {
 
  
  // Here we want to convert the value data into the bar graph display
  // Data can be 0-10. 0 = all lights OFF, 10 = all lights ON

  switch (data)    
  {
    case 0:
      displayArray[0] = B00000000;
      displayArray[1] = B00000000;      
    break;
    case 1:
      displayArray[0] = B00000000;
      displayArray[1] = B00000010;  
    break;
    case 2:
      displayArray[0] = B00000000;
      displayArray[1] = B00000100; 
    break;
    case 3:
      displayArray[0] = B00000000;
      displayArray[1] = B00001000; 
    break;
    case 4:
      displayArray[0] = B00000000;
      displayArray[1] = B00010000;
    break;
    case 5:
      displayArray[0] = B00000000;
      displayArray[1] = B00100000; 
    break;
    case 6:
      displayArray[0] = B00000000;
      displayArray[1] = B01000000;  
    break;
    case 7:
      displayArray[0] = B00000000;
      displayArray[1] = B10000000; 
    break;
    case 8:
      displayArray[0] = B00000010;
      displayArray[1] = B00000000; 
    break;
    case 9:
      displayArray[0] = B00000100;
      displayArray[1] = B00000000;  
    break;
    default:  // Over the max power therefore all LEDs ON
      displayArray[0] = B00001000;
      displayArray[1] = B00000000;
      
  }  
  
    
}

