package com.birdtweeder;


import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.wpan.RxResponse16;
import com.rapplogic.xbee.examples.ApiReceiveTest;
import com.rapplogic.xbee.util.ByteUtils;
import com.birdtweeder.FileWriter;
import com.harrison.lee.twitpic4j.TwitPic;
import com.harrison.lee.twitpic4j.TwitPicResponse;
import com.harrison.lee.twitpic4j.exception.TwitPicException;

import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class BirdTweederMain {
    
    
    private BirdTweederMain() throws Exception {
        XBee xbee = new XBee();
        FileWriter writer = new FileWriter();
        FileWriter writer_binary = new FileWriter();
        try {                   
            // replace with the com port of your receiving XBee (typically your end device)
        xbee.open("/dev/ttyUSB0", 19200);
        boolean newFile = true;

      //forever
		//get data
		//check for beginning of jpeg ff d8
			//if beginning create new file
		//continue getting data
		//check for end of jpeg ff d9
		//if end send off to twitter
            while (true) {


                    try {
                    	  XBeeResponse response = xbee.getResponse();
                    	  if (response.getApiId() == ApiId.RX_16_RESPONSE) {
                              // we received a packet
                              RxResponse16 rx = (RxResponse16) response;
                              
                              System.out.println(" The data is " + ByteUtils.toBase16(rx.getData()));
                              
                              String hex_data = ByteUtils.toBase16(rx.getData());

                              int end = hex_data.indexOf("0xff 0xd9");
                              int begin = hex_data.indexOf("0xff 0xd8");

                              System.out.println("Index of End: "+end);
                              System.out.println("Index of beginning: "+begin);
                              System.out.println("New File Flag: "+newFile);
                              
                              if(begin > -1 ) {
                              	if(newFile) {
                                    writer.SetFileName("test.txt");
                                    writer_binary.SetFileName("test-binary"+getDateTime()+".jpg");
                                    newFile = false;
                                    }
                                }               
                                
                              if(end > 0 ) {
                              	String finalString = hex_data.substring(0, end);
                              	writer.WriteToDisk(finalString);
                                writer_binary.WriteBinary(rx.getData(),end);
                                System.out.println("File Name: "+ writer_binary.fileHandle);
                                //send to twitter
                                writer_binary.CloseWriters();
                                newFile = true;  
                                SendToTwitter(writer_binary.fileHandle);
                              }               
                              else{
                                  writer.WriteToDisk(ByteUtils.toBase16(rx.getData()));
                                  writer_binary.WriteBinary(rx.getData(),rx.getData().length);
                              }
                    	  }
                                             
                   } catch (Exception e) {
                	   System.out.println("Error Message Coming: "+e.getMessage());
                    }
            }
    } finally {
            xbee.close();
    }
}


    private void SendToTwitter(File fileHandle) {
		// TODO Auto-generated method stub
    	// Create file

    	// Create TwitPic object and allocate TwitPicResponse object
    	TwitPic tpRequest = new TwitPic("USERNAME", "PASSWORD");
    	TwitPicResponse tpResponse = null;

    	// Make request and handle exceptions                           
    	try {
    	        tpResponse = tpRequest.uploadAndPost(fileHandle, "I saw a pretty birdy at: "+getDateTime());
    	} catch (IOException e) {
    	        e.printStackTrace();
    	} catch (TwitPicException e) {
    	        e.printStackTrace();
    	}

    	// If we got a response back, print out response variables                              
    	if(tpResponse != null)
    	        tpResponse.dumpVars();
	}


	private String getDateTime() {                                                                                                     
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");                                                            
        Date date = new Date();                                                                                                         
        return dateFormat.format(date);                                                                                                 
    }     

        public static void main(String[] args) throws Exception {
            // init log4j
            new BirdTweederMain();
    }
}
