package com.rapplogic.xbee.examples;

import org.apache.log4j.Logger;

import org.apache.log4j.PropertyConfigurator;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.zigbee.ZNetRxResponse;
import com.rapplogic.xbee.api.zigbee.ZNetTxRequest;
import com.rapplogic.xbee.util.ByteUtils;
import java.lang.Class;

import java.util.Random;

public class BeeProjectXBee {
	
	private final static Logger log = Logger.getLogger(BeeProjectXBee.class);
	
	
	private BeeProjectXBee() throws Exception {
    XBee xbee = new XBee();         

    try {                   
    	int[] NectarArray = new int[3];
    	Random generator = new Random();
    	for (int i = 0; i < NectarArray.length; i++) {
    		NectarArray[i] = generator.nextInt(80);
    		System.out.println(NectarArray[i]);
    	}
    	// replace with the com port of your receiving XBee (typically your end device)
    	xbee.open("/dev/ttyUSB0", 9600);
    	while (true) {
        	try {
        		
        		// we wait here until a packet is received.
                XBeeResponse response = xbee.getResponse();
                //log.info("received response " + response.toString());
                System.out.println("received response " + response.toString());
                    
                if (response.getApiId() == ApiId.ZNET_RX_RESPONSE) {
                	// we received a packet from ZNetSenderTest.java
                    ZNetRxResponse rx = (ZNetRxResponse) response;
                            
                    //log.info("Received RX packet, option is " + rx.getOption() + ", sender 64 address is " + ByteUtils.toBase16(rx.getRemoteAddress64().getAddress()) + ", remote 16-bit address is " + ByteUtils.toBase16(rx.getRemoteAddress16().getAddress()) + ", data is " + ByteUtils.toBase16(rx.getData()));
                    System.out.println(" The data is " + ByteUtils.toBase16(rx.getData()));
                    System.out.println(" The data is " + ByteUtils.toString(rx.getData()));
                    System.out.println("Getting Array Value!");
                    String sindex = ByteUtils.toString(rx.getData());
                    System.out.println(sindex);
//                    Class cls = sindex.getClass();  
//                    System.out.println("Bitch I know the type of the object, it's: " + cls.getName());  
                    int index = Integer.parseInt(sindex.trim());
                    System.out.format("The value of the index is %d",index);
                    System.out.println(index);
                    System.out.println(NectarArray[index]);
                    
            	
        			// replace with end device's 64-bit address (SH + SL)
        			XBeeAddress64 addr64 = new XBeeAddress64(0x00, 0x13, 0xa2, 0x00, 0x40, 0x31, 0xb9, 0x09);
        			
        			
        			// create an array of arbitrary data to send
        			int[] payload = new int[] { 'X', 'B', 'e', 'e' };
        			
        			// first request we just send 64-bit address.  we get 16-bit network address with status response
        			ZNetTxRequest request = new ZNetTxRequest(addr64, payload);
        			
        			log.debug("zb request is " + request.getXBeePacket().getPacket());
        			
        			log.info("sending tx " + request);
        			

                    
                    // optionally we may want to get the signal strength (RSSI) of the last hop.
                    // keep in mind if you have routers in your network, this will be the signal of the last hop.
                    AtCommand at = new AtCommand("DB");
                    xbee.sendAsynchronous(at);
                    XBeeResponse atResponse = xbee.getResponse();                 
                    // remember rssi is a negative db value
                    System.out.println("RSSI of last response is " + -((AtCommandResponse)atResponse).getValue()[0]);
                } else {
                	log.debug("received unexpected packet " + response.toString());
            	}
            } catch (Exception e) {
            	log.error(e);
                        }
                }
        } finally {
                xbee.close();
        }
}

        public static void main(String[] args) throws Exception {
                // init log4j
                PropertyConfigurator.configure("log4j.properties");
                new BeeProjectXBee();
        }
}

