package com.nikdeombartnik.bugbot;

import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;


public class MainActivity extends Activity {

    ImageView left;
    ImageView right;
    ImageView settings;

Context context;
    Thread workerThread;
    byte[] readBuffer;
    int readBufferPosition;
    int counter;
    OutputStream mmOutputStream;
    InputStream mmInputStream;
    volatile boolean stopWorker = false;

    private BluetoothAdapter mBluetoothAdapter = null;
    private BluetoothSocket btSocket = null;
    private OutputStream outStream = null;

    private StringBuilder recDataString = new StringBuilder();
    private static String address;
    private static final UUID MY_UUID = UUID
            .fromString("00001101-0000-1000-8000-00805F9B34FB");

    Intent i=new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
    Handler bluetoothIn;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);



        right = (ImageView)findViewById(R.id.right);
        left = (ImageView)findViewById(R.id.left);
        settings = (ImageView)findViewById(R.id.settings);


        right.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == MotionEvent.ACTION_DOWN) {

                    Send("F");
                    Log.d("Tag", "RIGHT");
                } else if (event.getAction() == MotionEvent.ACTION_UP) {
                    Send("S");
                }
                return true;
            }
        });


        left.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == MotionEvent.ACTION_DOWN) {
                    Send("W");
                    Log.d("Tag", "LEFT");
                } else if (event.getAction() == MotionEvent.ACTION_UP) {
                    Send("w");
                }
                return true;
            }
        });


        settings.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
show();

            }
        });

    }




    public void Connect(String address){

        if(mBluetoothAdapter.isEnabled()){

            BluetoothDevice btdevice = mBluetoothAdapter.getRemoteDevice(address);
            Toast.makeText(MainActivity.this, "Connecting...", Toast.LENGTH_SHORT).show();

            mBluetoothAdapter.cancelDiscovery();

            try{

                btSocket = btdevice.createInsecureRfcommSocketToServiceRecord(MY_UUID);
                btSocket.connect();

                Toast.makeText(MainActivity.this, "Connected", Toast.LENGTH_SHORT).show();

            }catch(IOException e){
                try{
                    btSocket.close();
                }catch(IOException e2){
                    Toast.makeText(MainActivity.this, "Error", Toast.LENGTH_SHORT).show();
                }
            }
        }else{
            Toast.makeText(MainActivity.this, "Bluetooth is disbaled",Toast.LENGTH_SHORT).show();
        }
    }


    private void CheckBt() {
        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();

        if (!mBluetoothAdapter.isEnabled()) {
            startActivity(i);
        }

        if (mBluetoothAdapter == null) {

        }
    }




    public void show(){
        final List<String> mPairedDevicesArrayAdapter = new ArrayList<>();


        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        Set<BluetoothDevice> pairedDevices = mBluetoothAdapter.getBondedDevices();


        if (pairedDevices.size() > 0) {
            for (BluetoothDevice device : pairedDevices) {
                mPairedDevicesArrayAdapter.add(device.getName() + "\n" + device.getAddress());
            }
        } else {
            mPairedDevicesArrayAdapter.add("no devices paired");

        }
        final CharSequence[] Abc = mPairedDevicesArrayAdapter.toArray(new String[mPairedDevicesArrayAdapter.size()]);
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this);
        dialogBuilder.setTitle("Choose device");
        dialogBuilder.setItems(Abc, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int item) {
                String text = Abc[item].toString();
                String address = text.substring(text.length() - 17);
                Connect(address);
            }
        });
        //Create alert dialog object via builder
        AlertDialog alertDialogObject = dialogBuilder.create();
        //Show the dialog
        alertDialogObject.show();
    }




    public void Send(String data){



        if(mBluetoothAdapter.isEnabled()){
            try{
                outStream = btSocket.getOutputStream();
            }catch(IOException e){
                Log.d("Errors", "Problem while data sending");
            }

            try {

                    outStream.write(data.getBytes());

            }catch(IOException e){
                Log.d("Errors", "Problem while data sending");
            }

        }
    }


    }
