// Language: Processing
// Lego RC Car Controller
// Sam Thongrong Dec 22, 2011
// Revision 1: August 19, 2012
// Revision 2: October 1, 2012
// Revision 3: Nov 16, 2012 - adapted to use with  R/C Lego car
// R/C Lego Car Redux, May 1, 2013

// MAC OS
//import java.text.SimpleDateFormat;
//import java.util.Date;

import processing.serial.*;

// Serial Comm.
Serial port = null;

// PC
String portName = "COM6";

int lastInput = 0;

// command[0] = Direction
// command[1] = Speed
int[] command     = new int[2];
int[] lastCommand = new int[2];

// Set up the speed value, in conjunction to 0 - 6 
// so, we can use the numeric keyboard to change the speed
// 0 = Stop, speed variation from 1 - 6
int speedStep = 25;    // speed step is (255 - 130) / 5;
int speed;
int lastSpeed = 0;
int numberOfGear = 6; 

// Motor Control variables
boolean running = true;

// Input Commands
int COMMAND_HEADER = 0x7F;   // DEL = 127(dec)
   
int DIR_FORWARD    = 0x1;    // dec =   1, binary = 0000 0001
int DIR_BACKWARD   = 0x2;    // dec =   2, binary = 0000 0010

int DIR_LEFT       = 0x4;    // dec =   4, binary = 0000 0100
int DIR_RIGHT      = 0x8;    // dec =   8, binary = 0000 1000

// Set up time display format
SimpleDateFormat date = new SimpleDateFormat("hh:mm:ss.SSS");

PImage carImage;
PImage frontWheels;

boolean leftTurn = false;
boolean rightTurn = false;

// Image button. 
// Loading images and using them to create a button. 
//int buttonSize = 34;
int buttonX = 34;
int buttonY = 34;
  
ImageButtons oneButton;
ImageButtons twoButton;
ImageButtons threeButton;
ImageButtons fourButton;
ImageButtons fiveButton;
ImageButtons sixButton;

ImageButtons reverseButton;
ImageButtons neutralButton;

ImageButtons leftButton;
ImageButtons rightButton;

PImage neutralImage;
PImage neutralOver;
PImage reverseImage;
PImage reverseOver;
PImage sixImage;
PImage sixOver;
PImage fiveImage;
PImage fiveOver;
PImage fourImage;
PImage fourOver;
PImage threeImage;
PImage threeOver;
PImage twoImage;
PImage twoOver;
PImage oneImage;
PImage oneOver;
PImage selected;
PImage turnSelected;

String timestamp()
{
 return date.format(new Date()); 
}

void controlGUI()
{ 
  carImage = loadImage("RC_Background.png");
  
  selected = loadImage("gearSelected.png");
  
  turnSelected = loadImage("turnSelected.png");
  
  // one
  oneImage = loadImage("one.png");
  oneOver = loadImage("oneOver.png");
  oneButton = new ImageButtons(104, 225, buttonX, buttonY, 
                               oneOver, oneImage, selected);
  // two
  twoImage = loadImage("two.png");
  twoOver = loadImage("twoOver.png");
  twoButton = new ImageButtons(104, 350, buttonX, buttonY, 
                               twoOver, twoImage, selected);
  // three
  threeImage = loadImage("three.png");
  threeOver = loadImage("threeOver.png");
  threeButton = new ImageButtons(156, 225, buttonX, buttonY, 
                                 threeOver, threeImage, selected);
  // four
  fourImage = loadImage("four.png");
  fourOver = loadImage("fourOver.png");
  fourButton = new ImageButtons(156, 350, buttonX, buttonY, 
                                fourOver, fourImage,selected);
  // five
  fiveImage = loadImage("five.png");
  fiveOver = loadImage("fiveOver.png");
  fiveButton = new ImageButtons(209, 225, buttonX, buttonY, 
                                fiveOver, fiveImage, selected);
  // six
  sixImage = loadImage("six.png");
  sixOver = loadImage("sixOver.png");
  sixButton = new ImageButtons(209, 350, buttonX, buttonY, 
                               sixOver, sixImage, selected);
                               
  // Reverse
  reverseImage = loadImage("reverse.png");
  reverseOver = loadImage("reverseOver.png");
  reverseButton = new ImageButtons(260, 225, buttonX, buttonY, 
                                   reverseOver, reverseImage,  selected);
                                   
  // Neutral
  neutralImage = loadImage("neutral.png");
  neutralOver = loadImage("neutralOver.png");
  neutralButton = new ImageButtons(260, 350, buttonX, buttonY, 
                                   neutralOver, neutralImage, selected);
                                   

}

void renderSpeed(int speedVal)
{
  fill(255);
  text("Speed: " + speedVal, 139, 215);
}

void updateFrontWheel(int x, int y)
{
  // Left Turn
  if(overWheel(79, 87, 76, 76)){ //if(overWheel(88, 113, 58, 74)){
    leftTurn = true;
  }
  // Right Turn
  else if(overWheel(244, 87, 76, 76)){ 
    rightTurn = true;
  }
  else { 
  leftTurn = rightTurn = false; 
  }
}

boolean overWheel(int x, int y, int width, int height)
{
 if(mouseX >= x && mouseX <= x + width &&
    mouseY >= y && mouseY <= y + height) {
     return true;
    }
  else {
   return false;
  } 
}

void speedButtons()
{
  oneButton.update();
  oneButton.display();
  if(oneButton.over){
    speed = 1;
    doForward();
  }

  twoButton.update();
  twoButton.display();
  if(twoButton.over){
    speed = 2;
    doForward();
  }
  
  threeButton.update();
  threeButton.display();
  if(threeButton.over){
    speed = 3;
    doForward();
  }
  
  fourButton.update();
  fourButton.display();
  if(fourButton.over){
    speed = 4;
    doForward();
  }
  
  fiveButton.update();
  fiveButton.display();
  if(fiveButton.over){
    speed = 5;
    doForward();
  }
  
  sixButton.update();
  sixButton.display();
  if(sixButton.over){
    speed = 6;
    doForward();
  }
  
  neutralButton.update();
  neutralButton.display();
  if(neutralButton.over) {
    speed = 0;
    doStop();
  }

  reverseButton.update();
  reverseButton.display();
  if(reverseButton.over) {
    speed = 3;
    doBackward();
  }
  
  lastSpeed = speed;
}

void directionButtons()
{
  if(speed == 0){
      frontWheels = loadImage("straight.png");
      image(frontWheels, 79, 87); //image(frontWheels, 88, 113);
      doStraight();
      doStop();
  }
  else if(speed > 0){
    if(leftTurn || rightTurn)
    {
      if(leftTurn){
        frontWheels = loadImage("turnLeft.png");
        image(frontWheels, 79, 87);
        doLeft();
      }
      if(rightTurn){
        frontWheels = loadImage("turnRight.png");
        image(frontWheels, 79, 87);
        doRight();
      }
    }
    else { 
      frontWheels = loadImage("straight.png");
      image(frontWheels, 79, 87);
      doStraight();
    }
  }
}

void setup()
{
  // Windows
  // change the portName and Baudrate accordingly
  //port = new Serial(this, portName, 9600);
  port = new Serial(this, portName, 38400);
  
  // MAC OS
  //String XBeePort = Serial.list()[0];
  //port = new Serial(this, XBeePort, 9600);
  
  // Setup the screen for output.
  size(400, 533);

  speed = 0;
  controlGUI();
}

void draw()
{
  background(carImage);
  
  speedButtons();
  updateFrontWheel(mouseX, mouseY);
  directionButtons();
  
  // Test run
  testRun();
}

  //Test run
void testRun() {
  
  speed = 3;
  
  forward(1200);
  delay(10);
  backward(800);
  
  speed = 5;
  forward(800);
  delay(10);
  
  left();
  delay(10);
  
  right();
  stop();
  
  /*
  speed = 5;
  
  backward(800);
  delay(10);
  stop();
  
  speed = 5;
  forward(1200);
  right();
  stop();

  backward(1000);
  */
  end();

}

void end()
{
  if(!running) 
    return;
  
  stop();
  straight();
  println(timestamp() + "--- END ---");

  running = false;
}

void interruptibleDelay(int millis)
{
  int start = millis();
  int d;
  
  while (running)
  {
    int timeLeftToWait = millis - (millis() - start);
    d = min(10, timeLeftToWait);
    if( d <= 0)
      return;
    
    delay(d);
  }
}

void forward(int millis)
{
  if(!running)
    return;
    
  forward();
  interruptibleDelay(millis);
  stop();
}

void forward()
{
  if(!running)
    return;
  
  doForward(); 
}

void doForward()
{
  command[0] = command[0] & ~DIR_BACKWARD;
  command[0] = command[0] | DIR_FORWARD;
  
  sendCommand();
}

void backward(int millis)
{
  if(!running)
    return;
    
  doBackward();
  interruptibleDelay(millis);
  stop();
}

void backward()
{
  if(!running)
    return;
  
  doBackward(); 
}

void doBackward()
{
  command[0] = command[0] & ~DIR_FORWARD;
  command[0] = command[0] | DIR_BACKWARD;
  
  sendCommand();
}

void left()
{
  if(!running)
    return;
  
  doLeft(); 
}

void doLeft()
{
  command[0] = command[0] & ~DIR_RIGHT;
  command[0] = command[0] | DIR_LEFT;
  
  sendCommand();
}

void right()
{
  if(!running)
    return;
  
  doRight(); 
}

void doRight()
{
  command[0] = command[0] & ~DIR_LEFT;
  command[0] = command[0] | DIR_RIGHT;
  
  sendCommand();
}

void straight()
{
  if(!running)
    return;
  
  doStraight(); 
}

void doStraight()
{
  command[0] = command[0] & ~DIR_RIGHT;
  command[0] = command[0] & ~DIR_LEFT;
  
  sendCommand();
}

void stop()
{
  if(!running)
    return;
  
  doStop();
}

void doStop()
{
  command[0] = command[0] & ~DIR_BACKWARD;
  command[0] = command[0] & ~DIR_FORWARD;

  sendCommand();
}

void serialEvent(Serial p)
{
  int input = p.read();
  lastInput = input;
}


void sendCommand()
{
  if(!isNewCommand())
    return;
  
  if(port != null)
  {
    port.write(COMMAND_HEADER);
    port.write(command[0]);
    
    // gear Number = 0 - 6, speed = 6, speed steps = 25
    command[1] = 255 - ((numberOfGear - speed) * speedStep);
    port.write(command[1]);
    
    if((command[0] & DIR_FORWARD) > 0)
    {
      
      println(timestamp() + " FORWARD\t");
    }
    if((command[0] & DIR_BACKWARD) > 0)
    {
      println(timestamp() + " BACKWARD\t");
    }
    if(((command[0] & DIR_FORWARD) == 0) && 
       ((command[0] & DIR_BACKWARD) == 0) )
    {
      println(timestamp() + " STOP\t");
    }
    if((command[0] & DIR_LEFT) > 0)
    {
      println(" LEFT\t");
    }
    if((command[0] & DIR_RIGHT) > 0)
    {
      println(" RIGHT\t");
    }
    if(((command[0] & DIR_LEFT) == 0) && 
       ((command[0] & DIR_RIGHT) == 0) )
    {
      println(" STRAIGHT\t");
    }
    
    println("SPEED = " + speed);
    
    lastCommand[0] = command[0];
    lastCommand[1] = command[1];
    
    lastSpeed = speed;
  }
}

boolean isNewCommand() 
{
  return ((command[0] != lastCommand[0]) || 
          (command[1] != lastCommand[1]) || 
          (speed != lastSpeed));
}

// =============================
// Button & ImageButtons Classes
// =============================
class Button
{
  int x, y;
  int w, h;
  color basecolor, highlightcolor;
  color currentcolor;
  boolean over = false;
  boolean pressed = false;   
  
  void pressed() {
    if(over && mousePressed) {
      pressed = true;
    } else {
      pressed = false;
    }    
  }
  
  boolean overRect(int x, int y, int width, int height) {
    if (mouseX >= x && mouseX <= x+width && 
      mouseY >= y && mouseY <= y+height) {
    return true;
    } else {
    return false;
    }
  }
}

class ImageButtons extends Button 
{
  PImage base;
  PImage roll;
  PImage down;
  PImage currentimage;

  ImageButtons(int ix, int iy, int iw, int ih, 
               PImage ibase, PImage iroll, PImage idown) 
  {
    x = ix;
    y = iy;
    w = iw;
    h = ih;
    base = ibase;
    roll = iroll;
    down = idown;
    currentimage = base;
  }
  
  void update() 
  {
    over();
    pressed();
    if(pressed) {
      currentimage = down;
    } else if (over){
      currentimage = roll;
    } else {
      currentimage = base;
    }
  }
  
  void over() 
  {
    if( overRect(x, y, w, h) ) {
      over = true;
    } else {
      over = false;
    }
  }
  
  void display() 
  {
    image(currentimage, x, y);
  }
}



