;**************************************************************************
; FILE:      reactometer.asm                                              *
; CONTENTS:  Reactometer reaction timer                                   *
; COPYRIGHT: MadLab Ltd. 2005                                             *
; AUTHOR:    James Hutchby                                                *
; UPDATED:   02/03/05                                                     *
;**************************************************************************

;     list p=10F202

     include "p10f202.inc"

     __config _WDT_OFF & _MCLRE_OFF & _CP_OFF

     __idlocs h'FFFF'

     errorlevel -305

;**************************************************************************
;                                                                         *
; Port assignments                                                        *
;                                                                         *
;**************************************************************************

GPIO_IO   equ  b'1000'             ; port I/O STATUS
BUTTON    equ  3                   ; pushbutton
PIEZOPOS  equ  0
PIEZONEG  equ  2 
LED       equ  2

;**************************************************************************
;                                                                         *
; Constants and timings                                                   *
;                                                                         *
;**************************************************************************

PERIODH       equ  2				   ; 852Hz
PERIODL       equ  d'75'
;F2H       equ  1                   ; 1209Hz
;F2L       equ  d'158'
HIOK	  equ  1
;HI2OK     equ  2

;**************************************************************************
;                                                                         *
; File register usage                                                     *
;                                                                         *
;**************************************************************************

RAM  set  h'10'

     cblock RAM
     temp
     t0h
     t0l
     nxth
     nxtl
;     nxt2h
;     nxt2l
     stat
	 lastt
     RAM_
     endc

     if RAM_ > h'20'
     error "File register usage overflow"
     endif


;--------------------------------------------------------------------------
; reset vector (after wrapping around from 1ff
;--------------------------------------------------------------------------

           org 0

	       andlw ~1
           movwf OSCCAL

	       goto main_entry

;--------------------------------------------------------------------------
; main entry point
;--------------------------------------------------------------------------

main_entry

          	clrf GPIO                     ; initialise port
          	movlw GPIO_IO
          	tris GPIO

          	movlw b'10001111'             ; weak pull-ups enabled
          	option

start     	btfsc GPIO,BUTTON
          	goto start          

			; Button pressed!
			clrf TMR0
			clrf t0h
			clrf t0l
        	movlw PERIODH
        	movwf nxth
			movlw PERIODL
        	movwf nxtl
        	;movlw F2H
        	;movwf nxt2h
			;movlw F2L
        	;movwf nxt2l
            clrf lastt
			bcf stat,HIOK
			;bcf stat,HI2OK

loop		;t0l = tmr0
        	movf TMR0,w
			movwf t0l

			;if lastt>t0l then ( inc t0h | if t0h=nxt1h then hi1ok=true (& same for hi2) )
			movf lastt,w
			subwf t0l,w
        	btfsc STATUS,C
        	goto step1a
        	;
            incf t0h,f
        	;
            movf nxth,w
			xorwf t0h,w
			btfsc STATUS,Z
			bsf stat,HIOK
            ;
            ;movf nxt2h,w
			;xorwf t0h,w
			;btfsc STATUS,Z
			;bsf stat,HI2OK

step1a		;if hi1ok and t0l>nxt1l then ( hi1ok = false  | nxt1+=period | toggle piezopos )
			btfss stat,HIOK
        	goto step1b
        	movf t0l,w
        	subwf nxtl,w
        	btfsc STATUS,C
        	goto step1b
        	bcf stat,HIOK
        	movlw PERIODL
        	addwf nxtl,f
        	btfsc STATUS,C
        	incf nxth,f
        	movlw PERIODH
        	addwf nxth,f
        	btfss GPIO,PIEZOPOS
        	goto step2a
        	bcf GPIO,PIEZOPOS
        	goto step1b
step2a   	bsf GPIO,PIEZOPOS

step1b		;if hi2ok and t0l>nxt2l then ( hi2ok = false  | nxt2+=period | toggle piezoneg )
			;btfss stat,HI2OK
        	;goto step3
        	;movf t0l,w
        	;subwf nxt2l,w
        	;btfsc STATUS,C
        	;goto step3
        	;bcf stat,HI2OK
        	;movlw F2L
        	;addwf nxt2l,f
        	;btfsc STATUS,C
        	;incf nxt2h,f
        	;movlw F2H
        	;addwf nxt2h,f
        	;btfss GPIO,PIEZONEG
        	;goto step2b
        	;bcf GPIO,PIEZONEG
        	;goto step3
step2b   	;bsf GPIO,PIEZONEG
		  
step3		;lastt = t01
        	movf t0l,w
        	movwf lastt

        	btfss GPIO,BUTTON
 		    goto loop
            goto start

delay	    movlw h'ff'
            movwf temp
repeat      decfsz temp
            goto repeat
            retlw 0

;--------------------------------------------------------------------------
; reset vector with osccal value in
;--------------------------------------------------------------------------

		  org 1ff
	      movlw 04

          end
