

#define ANALOG_PIN A9
#define SENSOR_LE 2
#define SENSOR_CLK 3
#define LED_DEBUG 13
#define TIME 100

#define NB_PIXELS 20
#define NB_PIXELS_MAX 2700

int tab[NB_PIXELS];

void setup() {
  pinMode(SENSOR_LE, OUTPUT); 
  pinMode(SENSOR_CLK, OUTPUT);
  pinMode(LED_DEBUG, OUTPUT);
  pinMode(8, OUTPUT); // turn a LED on 
  digitalWrite(8, LOW);  
  Serial.begin(9600);
}

void loop() {

  init_tab();

  clear_CCD();  

  read_CCD();

  send_processing();     

  //digitalWrite(13, !digitalRead(13));
  
}


void init_tab(){
  for(int i=0; i<NB_PIXELS; i++){
    tab[i]=0;
  }
}


void send_processing(){

  int val = 1026; // First data,
  Serial.write( 0xff);
  Serial.write( (val >> 8) & 0xff);
  Serial.write( val & 0xff);
  delay(TIME);
  for(int i=0; i<NB_PIXELS; i++){
    val = tab[i]; 
    Serial.write( 0xff);
    Serial.write( (val >> 8) & 0xff);
    Serial.write( val & 0xff);
    delay(TIME);
  }
  val = 1027; // last data
  Serial.write( 0xff);
  Serial.write( (val >> 8) & 0xff);
  Serial.write( val & 0xff);
  delay(TIME); 
} 

void read_CCD(){

  digitalWrite(SENSOR_LE, HIGH);
  digitalWrite(SENSOR_CLK, HIGH);            
  digitalWrite(SENSOR_CLK, LOW); 
  digitalWrite(SENSOR_LE, LOW);

  for(int i=0; i<NB_PIXELS; i++){
    for(int j=0; j<(NB_PIXELS_MAX/NB_PIXELS);j++){
      digitalWrite(SENSOR_CLK, HIGH);        
      digitalWrite(SENSOR_CLK, LOW); 
    }
    tab[i] = analogRead(ANALOG_PIN);
  }
}

void clear_CCD(){
  digitalWrite(SENSOR_LE, HIGH);
  digitalWrite(SENSOR_CLK, HIGH); 
  digitalWrite(SENSOR_CLK, LOW);
  digitalWrite(SENSOR_LE, LOW);

  for(int i = 0; i<NB_PIXELS_MAX; i++){ 
    digitalWrite(SENSOR_CLK, HIGH);      
    digitalWrite(SENSOR_CLK, LOW); 
  } 
}


