
/*
This program show a line of 20 square to represent the colors of 20 pixels 
received by the Arduino plugged on the CCD
The datas are received like this : 
data 0 = 1026
data 1 = pixel 1
data 2 = pixel 2
...
data 20 = pixel 20
data 21 = 1027
*/

import processing.serial.*;

Serial port;

String buff = "";
int cursor1,cursor2;
int[] tab= {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int cpt=0;
int val;
int[] values;
int flag=0;
 
void setup(){
  size(800,400);
  println("Available serial ports:");
  println(Serial.list());
  port = new Serial(this, Serial.list()[3], 9600);
  values = new int[width];
  port.bufferUntil('\n'); 
  rectMode(CENTER); 
}

int getY(int val) {
  return (int)(val / 1023.0f * height) - 1;
}

void draw(){ 
  background(240, 240, 240);
  
  while (port.available() >= 3) {
    if (port.read() == 0xff) {
      val = (port.read() << 8) | (port.read());
    }
    flag=1;
  }
  
  if(flag==1){
    if(val == 1026)
    {
      cpt=0; 
    }
    tab[cpt] = val;
    print(cpt);
    print("  ");
    println(val);
    if(cpt == 21)
    {
      cpt=0;
    }
    cpt++;
    flag=0;
  }

  if(tab[21] == 1027 && tab[20] <= 1024){  
    fill(0); 
    rect(width*0.29, height*0.9, width/100*2, width/100*2);
    for(int i=1; i<21;i++){
      fill(tab[i]/4);  // convert the 1024 analog 10bits to 255 8bits values
      rect(width*0.29+width*i*2/100, height*0.9, width/100*2, width/100*2);
      for(int j=1; j<=3; j++){
        if(tab[i]<= 650){line(width*0.5, height*0.15, width*0.29+width*i*2/100, height*0.9);}
      }
    }
    fill(255);
    rect(width*0.71, height*0.9, width/100*2, width/100*2); 
  
  }
  stroke(0,0,0);
  drawscreen();
}  

void drawscreen(){
  fill(0,0,255);
  text("Detection touch screen",width/2-65,20);
  rectMode(CENTER);  
  fill(200, 100, 200);
  rect(width*0.5, height*0.15, 20, 20);
}

void drawcursor(){
}

void mousePressed(){
}
