

#define ANALOG_PIN A9
#define SENSOR_LE 2
#define SENSOR_CLK 3
#define LED_DEBUG 13
#define TIME 200

#define NB_PIXELS 20
#define NB_PIXELS_MAX 2700

#define sensibility_1 650
#define sensibility_2 750
#define sensibility_3 900


int tab[2710];

void setup() {
  pinMode(SENSOR_LE, OUTPUT); 
  pinMode(SENSOR_CLK, OUTPUT);
  pinMode(LED_DEBUG, OUTPUT);
  Serial.begin(9600);
}

void loop() {
  
  clearData();
  
  clear_CCD();
  read_CCD();
  
  digitalWrite(LED_DEBUG, !digitalRead(LED_DEBUG));
  
  send_data_serial(); 
  
  delay(TIME);
}



void clearData(){
  for(int i=0; i<2710; i++){
    tab[i]=0;
  }
}

void send_data_serial(){
  
  for(int i=NB_PIXELS; i>0; i--){
    
    if(tab[i] >= sensibility_3){
      Serial.print("XXX");
    }
    else if(tab[i] >= sensibility_2){
      Serial.print("XX ");
    }
    else if(tab[i] >= sensibility_1){
      Serial.print(" X ");
    }
    else{
      Serial.print(tab[i]);
    }
    Serial.print("  ");
  }
  Serial.println();
}

void read_CCD(){

  digitalWrite(SENSOR_LE, HIGH);
  digitalWrite(SENSOR_CLK, HIGH);            
  digitalWrite(SENSOR_CLK, LOW); 
  digitalWrite(SENSOR_LE, LOW);

  for(int i=0; i<NB_PIXELS; i++){
    for(int j=0; j<(NB_PIXELS_MAX/NB_PIXELS);j++){
      digitalWrite(SENSOR_CLK, HIGH);        
      digitalWrite(SENSOR_CLK, LOW); 
    }
    tab[i] = analogRead(ANALOG_PIN);
  }
}

void clear_CCD(){
  digitalWrite(SENSOR_LE, HIGH);
  digitalWrite(SENSOR_CLK, HIGH); 
  digitalWrite(SENSOR_CLK, LOW);
  digitalWrite(SENSOR_LE, LOW);

  for(int i = 0; i<NB_PIXELS_MAX; i++){ 
    digitalWrite(SENSOR_CLK, HIGH);      
    digitalWrite(SENSOR_CLK, LOW); 
  } 
}






