#include <SdFat.h>
#include <Bounce.h>
#define SS_PIN 0
#define BUFSIZ 80

const int bluePin =  14;
const int pinkPin =  12;
const int maleButtonPin = 7;
const int femaleButtonPin = 8;
const int chipSelect = SS_PIN;
Bounce malePushButton = Bounce(maleButtonPin, 10);
Bounce femalePushButton = Bounce(femaleButtonPin, 10);
long randNumber;
char nameBuffer[BUFSIZ];
char maleFileName[14] = "males.txt";
char femaleFileName[14] = "females.txt";
char surnameFileName[14] = "surnames.txt";
// file system object
SdFat sd;

//ArduinoOutStream cout(Serial);

void setup() {                
  Serial.begin(9600);
    Serial.print("Initializing SD card...");
  // On the Ethernet Shield, CS is pin 4. It's set as an output by default.
  // Note that even if it's not used as the CS pin, the hardware SS pin 
  // (10 on most Arduino boards, 53 on the Mega) must be left as an output 
  // or the SD library functions will not work. 
  pinMode(0, OUTPUT);
  pinMode(maleButtonPin, INPUT_PULLUP);
  pinMode(femaleButtonPin, INPUT_PULLUP);
  pinMode(bluePin, OUTPUT);
  pinMode(pinkPin, OUTPUT);
  randomSeed(analogRead(8));

  // initialize the SD card at SPI_HALF_SPEED to avoid bus errors with
  // breadboards.  use SPI_FULL_SPEED for better performance.
  if (!sd.init(SPI_HALF_SPEED, chipSelect)) {
    sd.initErrorHalt();
    Serial.println("initialization failed!");
  }
  //Serial.println("initialization done.");
}

void loop()                     
{
  if (malePushButton.update()) {
    if (malePushButton.fallingEdge()) {
       //Serial.println("M Button is pressed...");
       digitalWrite(bluePin, HIGH);
       nameBuffer[0] = '\0';
       readFile(maleFileName);
       strcat(nameBuffer, " ");
       readFile(surnameFileName);
       Serial.println(nameBuffer);
       Keyboard.print(nameBuffer);
    }
    if (malePushButton.risingEdge())
    {
      digitalWrite(bluePin, LOW);
    }
  }
  if (femalePushButton.update()) {
    if (femalePushButton.fallingEdge()) {
       //Serial.println("F Button is pressed...");
       digitalWrite(pinkPin, HIGH);
       nameBuffer[0] = '\0';
       readFile(femaleFileName);
       strcat(nameBuffer, " ");
       readFile(surnameFileName);
       Serial.println(nameBuffer);
       Keyboard.print(nameBuffer);
    }
    if (femalePushButton.risingEdge())
    {
      digitalWrite(pinkPin, LOW);
    }
  } 
  delay(250);
}

void readFile(char* filename) {
  const int line_buffer_size = 18;
  char buffer[line_buffer_size];
  ifstream sdin(filename);
  int line_number = 0;
  int num_lines = 0;
  
  if (sdin.getline(buffer, line_buffer_size, '\n') || sdin.gcount()) {
    int count = sdin.gcount();
    
    line_number = atoi(buffer);
    //Serial.println(buffer);
  }
  
  num_lines = line_number;
  //Serial.print("Number of Lines: ");
  //Serial.println(num_lines);
   
  randNumber = random(1, num_lines) + 1;
  //Serial.print("Random line number: ");
  //Serial.println(randNumber);

  sdin.seekg(0);
  line_number = 0;
  
  while (sdin.getline(buffer, line_buffer_size, '\n') || sdin.gcount()) {
    int count = sdin.gcount();
    ++line_number;
    //Serial.println(randNumber);
    //Serial.println(line_number);
    //Serial.println(buffer);
    if (randNumber == line_number) {
      //Serial.print("Our random name: ");
      //Serial.println(buffer);
      strcat(nameBuffer, buffer);
      //Serial.println(nameBuffer);
      break;
    }
  } 
}

