/*
  Program code for the Pimp Your Chocolates project. 
  Charlieplexing 10 LEDs mounted into a chocolate box using ATtiny13 with some brightness control using pseudo-PWM
  
  The tilt switch motion sensor is connected to Pin 3 (PB4)
  See http://elabz.com/pimp-your-chocolates-with-arduino-ide-and-attiny13/ 
  for the complete circuit schematics
  
  Code by Elabz.com
  http://elabz.com/
  This example code is in the public domain. If you end up using it in a project, please drop me a message, I'd be happy to
  know it was of some use. I'll also be happy to feature your project on my site, so send some pictures, too.
  
  LED hookup can be gleaned from the bitmap[] array values. For example, first LED's value is B00000001 which means that
  to light the LED the D0 has to ho HIGH and D1 - LOW, so the LED's anode is facing D0. LED #2 is between the same legs but in reverse. 
  LED #3 is between D0 and D2, LED #4 is the same legs but in reverse and so on. 
  
//       ATMEL ATTINY13 / ARDUINO
//
//                 +-\/-+
// ADC0 (D 5) PB5 1|    |8 Vcc
// ADC3 (D 3) PB3 2|    |7 PB2 (D 2) ADC1
// ADC2 (D 4) PB4 3|    |6 PB1 (D 1) PWM1
//            GND 4|    |5 PB0 (D 0) PWM0
//                 +----+

  
  
 */
#include <avr/pgmspace.h>

#include <avr/sleep.h> // sleep code by insidegadgets.com
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif


byte bitmap[] PROGMEM ={0B00000001,0B00000010,0B00000001,0B00000100,0B00000001,0B00001000,0B00000010,0B00000100,0B00000010,0B00001000};
byte outModes[] PROGMEM ={0B00000011,0B00000011,0B00000101,0B00000101,0B00001001,0B00001001,0B00000110,0B00000110,0B00001010,0B00001010};
byte waveform[16] PROGMEM = {
  1,5,10,15,78,127,176,217,255,255,255,217,127,37,1,1  // arbitrary waveform (heartbit)
};

boolean d=true; // direction forward=true
byte j=0; // just a counter
unsigned long periodPWM;
int cycleDelay=450;

void setup() { 
periodPWM = cycleDelay/16;
  sbi(GIMSK,PCIE); // Turn on Pin Change interrupt
  sbi(PCMSK,PCINT4); // Which pins are affected by the interrupt
}

void loop() {
unsigned  long periodNow;
unsigned long offDelay;
DDRB = 0B00000000; // turn everything off at the beginnig of each LED's cycle - adjust that per your application!
  for(byte x=0; x<16; x++){ // counter for the waveform
      offDelay = 255 - pgm_read_byte(&(waveform[x]));
      periodNow = millis();
      
      while(millis()-periodNow < periodPWM)
      {
      DDRB = 0B00000000; // turn everything off
      delayMicroseconds(offDelay); // wait for the off period
      PORTB = pgm_read_byte(&(bitmap[j])); // turn LED on
      DDRB = pgm_read_byte(&(outModes[j]));
      delayMicroseconds(pgm_read_byte(&(waveform[x])));   // then wait
     
   }
  }


  if(j>8) 
  { d=false;
  }else if(j<1)
  { d=true;
    DDRB = 0B00000000; // turn everything off at the end of each LED's cycle - adjust that per your application!
    system_sleep();
  }
  if(d){j++;}else{j--;}


}

// From http://interface.khm.de/index.php/lab/experiments/sleep_watchdog_battery/
void system_sleep() {
  cbi(ADCSRA,ADEN); // Switch Analog to Digital converter OFF
  set_sleep_mode(SLEEP_MODE_PWR_DOWN); // Set sleep mode
  sleep_mode(); // System sleeps here
  sbi(ADCSRA,ADEN);  // Switch Analog to Digital converter ON
}

ISR(PCINT0_vect) {

}
