/* This is the code for the Arduino Leonardo, it will not work on the Uno. */

/* These are constants: If you want to change the number of analog inputs, you can simply do it once on this line, instead of changing it everywhere in your code.*/
#define NUMBER_OF_ANALOG_INPUTS  12 // The Leonardo has 12 analog inputs, we'll use all of them in this example. If you only need 6, change this to 6, and you'll be able to use A6 to A11 as normal I/O pins.
#define NUMBER_OF_DIGITAL_INPUTS 7  // If you use all 12 analog inputs, the Leonardo has 8 digital pins left. We'll be using pin13 for the status LED, so we can connect 7 switches. Adapt this to your own needs.

#define CHANNEL  1 //Send all messages on channel 1

/* The list with the corresponding controller numbers: for example, the values of the potentiometer on A0 will be sent as the first controller number in this list, A1 as the second, etc... 
 Here's the list with all controller numbers:  http://midi.org/techspecs/midimessages.php#3  You can change them if you want.*/
int controllers[NUMBER_OF_ANALOG_INPUTS] = { 
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B
};  

/* The list with the corresponding note numbers: for example, the values of the first button will be sent as the first note number in this list, the second switch as the second note, etc... 0x3C is defined in the MIDI implementation as the middle C.
 Here's the list with all note numbers:  http://www.electronics.dit.ie/staff/tscarff/Music_technology/midi/midi_note_numbers_for_octaves.htm  You can change them if you want.*/
int notes[NUMBER_OF_DIGITAL_INPUTS] = { 
  0x3C, 0x3D, 0x3E, 0x3F, 0x40, 0x41, 0x42

};

/* The list with the numbers of the pins that have a switch or push button connected. Make sure they do not interfere with the analog inputs. Adapt to your own needs.*/
int switches[NUMBER_OF_DIGITAL_INPUTS] = { 
  0,1,2,3,5,7,11
};


int analogVal[NUMBER_OF_ANALOG_INPUTS];  // We declare an array for the values from the analog inputs.

int analogOld[NUMBER_OF_ANALOG_INPUTS];  // We declare an array for the previous analog values. 


int digitalVal[NUMBER_OF_DIGITAL_INPUTS];  // We declare an array for the values from the digital inputs.

int digitalOld[NUMBER_OF_DIGITAL_INPUTS];  // We declare an array for the previous digital values. 

void setup() {
  for(int i = 0; i < NUMBER_OF_ANALOG_INPUTS; i++){  // We make the values of analogOld -1, so it will always be different from any possible analog reading.
    analogOld[i]=-1;
  }
  for(int i = 0; i < NUMBER_OF_DIGITAL_INPUTS; i++){  // We make the values of digitalOld -1, so it will always be different from any possible digital reading.
    digitalOld[i]=-1;
  }
  
  for(int i = 0; i < NUMBER_OF_DIGITAL_INPUTS; i++){  // Set all switch-pins as input, and enable the internal pull-up resistor.
    pinMode(switches[i], INPUT_PULLUP);
  }
  pinMode(13, OUTPUT);      // Set pin 13 (the one with the LED) to output
  digitalWrite(13, LOW);    // Turn off the LED
  delay(1000);              // Wait 1 second before sending messages, to be sure everything is set up, and to make uploading new sketches easier.
  digitalWrite(13, HIGH);   // Turn on the LED, when the loop is about to start.
}

void loop() {
  for(int i = 0; i < NUMBER_OF_ANALOG_INPUTS; i++){                         // Repeat this procedure for every analog input.
    analogVal[i] = analogRead(i)/8;                                       // The resolution of the Arduino's ADC is 10 bit, and the MIDI message has only 7 bits, 10 - 7 = 3, so we divide by 2^3, or 8.
    if(analogVal[i] != analogOld[i]){                                     // Only send the value, if it is a different value than last time.
      usbMIDI.sendControlChange(controllers[i], analogVal[i], CHANNEL);   /* Send the MIDI control change message: choose the i'th controller in the array above, get the right value from the analogVal array, on the predefined channel.
      NOTE: the compiler will not recognize this command if you don't have Teensyduino and TeeOnArdu installed, if the board type is not TeeOnArdu, or if the USB type is not set to MIDI.*/
    }
    analogOld[i] = analogVal[i];                                          // Put the analog values in the array for old analog values, so we can compare the new values with the previous ones.
  }
  
  for(int i = 0; i < NUMBER_OF_DIGITAL_INPUTS; i++){                        // Repeat this procedure for every digital input.
    digitalVal[i] = digitalRead(switches[i]);                                       // Read the switch and store the value (1 or 0) in the digitalVal array.
    if(digitalVal[i] != digitalOld[i]){                                   // Only send the value, if it is a different value than last time.
      if(digitalVal[i] == 0){                                             // If the i'th switch is pressed:
        usbMIDI.sendNoteOn(notes[i], 127, CHANNEL);   /* Send the MIDI note on message: choose the i'th note in the array above, set the velocity to 127 or 100%, on the predefined channel.
        NOTE: the compiler will not recognize this command if you don't have Teensyduino and TeeOnArdu installed, if the board type is not TeeOnArdu, or if the USB type is not set to MIDI.*/
      } else {                                                            // If the i'th switch is released:
        usbMIDI.sendNoteOff(notes[i], 127, CHANNEL);   /* Send the MIDI note off message: choose the i'th note in the array above, set the velocity to 127 or 100%, on the predefined channel.
        NOTE: the compiler will not recognize this command if you don't have Teensyduino and TeeOnArdu installed, if the board type is not TeeOnArdu, or if the USB type is not set to MIDI.*/
      }
    }
    digitalOld[i] = digitalVal[i];                                          // Put the digital values in the array for old digital values, so we can compare the new values with the previous ones.
  }

}




