// 
//   FILE:  dht11_test1.pde
// PURPOSE: DHT11 library test sketch for Arduino
//

//Celsius to Fahrenheit conversion
double Fahrenheit(double celsius)
{
  return 1.8 * celsius + 32;
}

//Celsius to Kelvin conversion
double Kelvin(double celsius)
{
  return celsius + 273.15;
}

// dewPoint function NOAA
// reference: http://wahiduddin.net/calc/density_algorithms.htm 
double dewPoint(double celsius, double humidity)
{
  double A0= 373.15/(273.15 + celsius);
  double SUM = -7.90298 * (A0-1);
  SUM += 5.02808 * log10(A0);
  SUM += -1.3816e-7 * (pow(10, (11.344*(1-1/A0)))-1) ;
  SUM += 8.1328e-3 * (pow(10,(-3.49149*(A0-1)))-1) ;
  SUM += log10(1013.246);
  double VP = pow(10, SUM-3) * humidity;
  double T = log(VP/0.61078);   // temp var
  return (241.88 * T) / (17.558-T);
}

// delta max = 0.6544 wrt dewPoint()
// 5x faster than dewPoint()
// reference: http://en.wikipedia.org/wiki/Dew_point
double dewPointFast(double celsius, double humidity)
{
  double a = 17.271;
  double b = 237.7;
  double temp = (a * celsius) / (b + celsius) + log(humidity/100);
  double Td = (b * temp) / (a - temp);
  return Td;
}


#include <DHT11.h>
#include <LiquidCrystal.h>

dht11 DHT11;

#define DHT11PIN 2
LiquidCrystal lcd(8,9,10,11,12,13);

void setup()
{
  Serial.begin(9600);
  Serial.println("DHT11 TEST PROGRAM ");
  Serial.print("LIBRARY VERSION: ");
  Serial.println(DHT11LIB_VERSION);
  Serial.println();
  lcd.clear();
  lcd.begin(16,2);
}

void loop()
{
  Serial.println("\n");

  int chk = DHT11.read(DHT11PIN);

  Serial.print("Read sensor: ");
  switch (chk)
  {
    case 0: Serial.println("OK"); break;
    case -1: Serial.println("Checksum error"); break;
    case -2: Serial.println("Time out error"); break;
    default: Serial.println("Unknown error"); break;
  }

  Serial.print("Humidity(%): ");
  Serial.println((float)DHT11.humidity, 2);
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("Humidity: ");
  lcd.setCursor(0,1);
  lcd.print((float)DHT11.humidity, 2);
  lcd.print("%");
  delay(2000);

  Serial.print("Temperature(oC): ");
  Serial.println((float)DHT11.temperature, 2);
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("Temperature: ");
  lcd.setCursor(0,1);
  lcd.print((float)DHT11.temperature, 2);
  lcd.print("oC");
  delay(2000);

  Serial.print("Temperature(oF): ");
  Serial.println(Fahrenheit(DHT11.temperature), 2);
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("Temperature: ");
  lcd.setCursor(0,1);
  lcd.print(Fahrenheit(DHT11.temperature), 2);
  lcd.print("oF");
  delay(2000);

  Serial.print("Temperature(K): ");
  Serial.println(Kelvin(DHT11.temperature), 2);
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("Temperature: ");
  lcd.setCursor(0,1);
  lcd.print(Kelvin(DHT11.temperature), 2);
  lcd.print("K");
  delay(2000);

  Serial.print("Dew Point(oC): ");
  Serial.println(dewPoint(DHT11.temperature, DHT11.humidity));
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("Dew Point: ");
  lcd.setCursor(0,1);
  lcd.print(dewPoint(DHT11.temperature, DHT11.humidity));
  lcd.print("oC");
  delay(2000);

  Serial.print("Dew PointFast(oC): ");
  Serial.println(dewPointFast(DHT11.temperature, DHT11.humidity));
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("Dew PointFast: ");
  lcd.setCursor(0,1);
  lcd.print(dewPointFast(DHT11.temperature, DHT11.humidity));
  lcd.print("oC");
  delay(2000);

}
//
// END OF FILE
//
