/*
* MainStation  functions and definitions
*
* Author: Marcell Stoer
* December 2018
*/

#ifndef MAINSTATIONDEFS
#define MAINSTATIONDEFS
#endif

// keep in sync with ESP_NOW sensor struct
struct __attribute__((packed)) SENSOR_DATA {
    float temp;
    float humidity;
    float pressure;
    float lightlvl;
} ;

// structure to hold info from each station
typedef struct __attribute__((packed)) SENSORSTN_INFO {
	char name[256];  // name of station based on location
	uint8_t mac[6];   // MAC address of station
	struct SENSOR_DATA sdata; // sensor readings
  char sensdtime[32]; // date/time of last sensor reading
} ;

// structure to save server uptime info
struct __attribute__((packed)) STATIONUPTIME {
  long secs;
  int mins;
  int hrs;
  int days;
} stationuptime;

// structure to save wifi uptime info
struct __attribute__((packed)) WIFIUPTIME {
  long secs;
  int mins;
  int hrs;
  int days;
} wifiuptime;

// Serial Gateway link baud rate
// Gateway module uses SoftSerial and cannot run at maximum serial speeds
#define sgBAUD_RATE 9600 // Serial Gateway baud rate

// defines maximum number of sensor stations
// if this number is changed, the sensor data structure and 
// data files variables need to be adjusted accordingly in 
// "SensorStationMAC.h"
#define MAXSTNS 5 // current maximum number of sensor stations

// Local network login info
const char* ssid     = "YOURWIFISSID"; // enter SSID of WIFI router here
const char* password = "YOURWIFIPASSWORD"; // enter password to WIFI router here

// Webpage functions
void handlewebclient(WiFiClient); // creates basic page
void printwebtable(WiFiClient); // prints basic table
void createtablerow(char *, int); // creates table row data
void sendwebpage(WiFiClient); // creates & sends the basic webpage to the client
void sendwebfile(WiFiClient, int); // sends requested data file to client

// Functions to handle other things
void readSerial( void );
void printSensorData( void );
int isEqual( uint8_t*, uint8_t* );
int findLocation( uint8_t* );
void writesensordata( uint8_t* );
void stationuptimecheck( void );
void checkwifi( void );
void wifiuptimeprint( void );

// SD Card usuage functions

void readFile(fs::FS &fs, const char * );
void writeFile(fs::FS &fs, const char * , const char * );
void appendFile(fs::FS &fs, const char * , const char * );
