/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.util.EventObject;
import org.jdesktop.beansbinding.Property;

public class PropertyStateEvent
extends EventObject {
    public static final Object UNREADABLE = new StringBuffer("UNREADABLE");
    private Object sourceObject;
    private final boolean valueChanged;
    private final Object oldValue;
    private final Object newValue;
    private final boolean writeableChanged;
    private boolean isWriteable;

    public PropertyStateEvent(Property sourceProperty, Object sourceObject, boolean valueChanged, Object oldValue, Object newValue, boolean writeableChanged, boolean isWriteable) {
        super(sourceProperty);
        if (!writeableChanged && !valueChanged) {
            throw new IllegalArgumentException("Nothing has changed");
        }
        if (valueChanged && oldValue == UNREADABLE && newValue == UNREADABLE) {
            throw new IllegalArgumentException("Value can't change from UNREADABLE to UNREADABLE");
        }
        this.sourceObject = sourceObject;
        this.valueChanged = valueChanged;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.writeableChanged = writeableChanged;
        this.isWriteable = isWriteable;
    }

    @Override
    public final Object getSource() {
        return super.getSource();
    }

    public final Property getSourceProperty() {
        return (Property)this.getSource();
    }

    public final Object getSourceObject() {
        return this.sourceObject;
    }

    public final boolean getValueChanged() {
        return this.valueChanged;
    }

    public final Object getOldValue() {
        if (!this.valueChanged) {
            throw new UnsupportedOperationException("value hasn't changed");
        }
        return this.oldValue;
    }

    public final Object getNewValue() {
        if (!this.valueChanged) {
            throw new UnsupportedOperationException("value hasn't changed");
        }
        return this.newValue;
    }

    public final boolean getReadableChanged() {
        return this.valueChanged && this.oldValue != this.newValue && (this.oldValue == UNREADABLE || this.newValue == UNREADABLE);
    }

    public final boolean isReadable() {
        if (!this.getReadableChanged()) {
            throw new UnsupportedOperationException("readability hasn't changed");
        }
        return this.newValue != UNREADABLE;
    }

    public final boolean getWriteableChanged() {
        return this.writeableChanged;
    }

    public final boolean isWriteable() {
        if (!this.writeableChanged) {
            throw new UnsupportedOperationException("writeability hasn't changed");
        }
        return this.isWriteable;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": Property ").append(this.getSourceProperty()).append(" changed on ").append(this.getSourceObject()).append(":\n");
        if (this.getValueChanged()) {
            buffer.append("    value changed from ").append(this.getOldValue()).append(" to ").append(this.getNewValue()).append('\n');
        }
        if (this.getReadableChanged()) {
            buffer.append("    readable changed from ").append(!this.isReadable()).append(" to ").append(this.isReadable()).append('\n');
        }
        if (this.getWriteableChanged()) {
            buffer.append("    writeable changed from ").append(!this.isWriteable()).append(" to ").append(this.isWriteable()).append('\n');
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }
}

