/* Eco Friendly Metal Detector - Arduino 
  
  V1 - First Production Release
*/ 

#include <UTFT.h> 
#include <URTouch.h>

//==== Creating Objects
 UTFT myGLCD(SSD1289,38,39,40,41); //Parameters should be adjusted to your Display/Schield model
// UTFT myGLCD(ILI9341_16,38,39,40,41); //Parameters should be adjusted to your Display/Schield model

URTouch  myTouch( 6, 5, 4, 3, 2);

//==== Defining Fonts
extern uint8_t SmallFont[];
extern uint8_t BigFont[];
extern uint8_t SevenSegNumFont[];
extern uint8_t SevenSeg_XXXL_Num[];

const float alpha = 0.8; 
float smoothedvalue1 = 4400;
float smoothedvalue2 = 4400;
float smoothedvalue3 = 4400;
float smoothedvalue4 = 4400;

int bline1 = 100; // Trace 1 and 2 Y coordinate
int bline2 = 220; // Trace 3 and 4 Y coordinate

int DS1alarm = 30; // Threshold for the alram on Display 1
int DS1refresh = 0; // Flag used to time the refresh of DS1 threshold circle
int DS4refresh = 0; // Flag used to time the refresh of DS4 screen

int DS1X = 160; // X location of Display1 X offset
int DS1Y = 120; // X location of Display1 X offset

int ytrace1 = 0;
int ytrace2 = 0;
int ytrace3 = 0;
int ytrace4 = 0;

int colour1 = 0;
int colour2 = 0;
int colour3 = 0;
int colour4 = 0;

int sensitivity = 2; // used to set the amplification of the display by 1x, 2x, 4x or 6x

//Store actual alarm threshold value to be shown on the screen
int alarm1 = 80;
int alarm2 = 80;
int alarm3 = 200;
int alarm4 = 200;

int tonefreq = 1000;  // Frequency of Audio to Piezo device

int calcounter; // Used to wait for "scount" reads of data to determine a baseline for each coil
boolean sample = false; // if true then do not rebaseline
int scount = 100; // Number of reads before calibrating once only
float threshp = 0.998; // Used to determine when to react after threshold set

long pc1 = 5000; // Determinesthe duration of pulse for channel 1
long pc2 = 5000; // Determinesthe duration of pulse for channel 2
long pc3 = 5000; // Determinesthe duration of pulse for channel 3
long pc4 = 5000; // Determinesthe duration of pulse for channel 4

int xtrace1 = 1; // X coordinate forcoil 1 trace
int xtrace2 = 1; // X coordinate forcoil 2 trace
int xtrace3 = 1; // X coordinate forcoil 3 trace
int xtrace4 = 1; // X coordinate forcoil 4 trace

int memtrace1[118]; // Coil 1 trace 117 x coordinates to remember
int memtrace2[118]; // Coil 2 trace 117 x coordinates to remember
int memtrace3[118]; // Coil 3 trace 117 x coordinates to remember
int memtrace4[118]; // Coil 4 trace 117 x coordinates to remember

long calav1 = 0; // Used to calcuate average of ten samples
long calav2 = 0; // Used to calcuate average of ten samples
long calav3 = 0; // Used to calcuate average of ten samples
long calav4 = 0; // Used to calcuate average of ten samples

int div1 = 0;
int div2 = 0;
int div3 = 0;
int div4 = 0;

boolean LPF = true; // Flag to determine if Low Pass Filter is enabled 
boolean mute = true; // Flag to mute sound = true

int dly1 = 4; // Period of time that TXR pin stays high ( range 2 to 500)
int dly2 = 1; // Delay after TXR pin goes LOW before reading starting to read the pulse duration - typically 1 uS 
int dly3 = 40; // Delay after sampling pulsewidth  before starting next cycle

int pwindow = 8000; // Timout period in uS for PulseIn function

// Touch screen variables
int xT = 0; // X coordinate for touch input from the screen
int yT = 0; // Y coordinate for touch input from the screen
boolean screenPressed = false;

int DS = 2; // Display Number used to determinescreen layout

void setup()
{

    Serial.begin(115200); // Setupserial interface for test data outputs
    
    // Setup Ports for each channel

    // Piezo speaker outpt port
    pinMode(A0,OUTPUT); // Pulse output from D8 Arduino
    
    // Channel 1 ports
    pinMode(8,OUTPUT); // Pulse output from D8 Arduino
    pinMode(9,INPUT); // Signal from LM339 in read by D9 on Arduino

    // Channel 2 ports
    pinMode(10,OUTPUT); // Pulse output from D10 Arduino
    pinMode(11,INPUT); // Signal from LM339 in read by D11 on Arduino

    // Channel 3 ports
    pinMode(12,OUTPUT); // Pulse output from D12 Arduino
    pinMode(13,INPUT); // Signal from LM339 in read by D13 on Arduino

    // Channel 4 ports
    pinMode(14,OUTPUT); // Pulse output from D14 Arduino
    pinMode(15,INPUT); // Signal from LM339 in read by D15 on Arduino

   
    // Initiate display
    myGLCD.InitLCD();
    myGLCD.clrScr();
    myTouch.InitTouch();
    myTouch.setPrecision(PREC_LOW);    

    drawscreen(); // Initiate the game
  //  drawthresholds(); // Draw screen thresholds
  // Set col0ur for text printout
    myGLCD.setColor(255, 255, 255);
    myGLCD.setBackColor(0, 0, 0);
    myGLCD.setFont(SmallFont);

for (int i=0; i <= 117; i++){ memtrace1[i] = 10;} // initialise array
for (int i=0; i <= 117; i++){ memtrace2[i] = 10;} // initialise array
for (int i=0; i <= 117; i++){ memtrace3[i] = 10;} // initialise array
for (int i=0; i <= 117; i++){ memtrace4[i] = 10;} // initialise array


}


void loop()
{

// Check if user input to touch screen
     myTouch.read();
 if (myTouch.dataAvailable() && !screenPressed) {
    xT = myTouch.getX();
    yT = myTouch.getY();        

    // Capture action from the request from user

    if ((xT>=0) && (xT<=40) && (yT>=0) && (yT<=40) ) { // Recallibrate the detector
        sample = false; // Reset callibrate flag to start calibration
          // Draw Cal Button Red
          myGLCD.setColor(255, 0, 0);    
          myGLCD.setFont(SmallFont);
          myGLCD.print("CAL",10,9);
          myGLCD.drawCircle(20,15,15);  


      if (DS >= 2) {
          clearthresholds(); // Clear thetheshold lines
      
          // Reset the threshold lines to the baseline values
          alarm1 = 80;
          alarm2 = 80;
          alarm3 = 200;
          alarm4 = 200;

          drawthresholds(); // Redraw thetheshold lines

        }          
          calav1 = 0; // Used to calcuate average of ten samples
          calav2 = 0; // Used to calcuate average of ten samples
          calav3 = 0; // Used to calcuate average of ten samples
          calav4 = 0; // Used to calcuate average of ten samples
          
          div1 = 0;
          div2 = 0;
          div3 = 0;
          div4 = 0;

    }

    if ((xT>=279) && (xT<=319) && (yT>=0) && (yT<=40)) { // Enable LPF
        if (LPF == false) {
           LPF = true; // Turn on the LPF flag to start LPF
           // Draw Low Pass Filter Button
           myGLCD.setColor(0, 255, 0);    
           myGLCD.setFont(SmallFont);
           myGLCD.print("LPF",289,9);
           myGLCD.drawCircle(299,15,15);  
        } else {
          LPF = false; // Turn off LPF flag 
          // Draw Low Pass Filter Button
          myGLCD.setColor(255, 0, 0);    
          myGLCD.setFont(SmallFont);
          myGLCD.print("LPF",289,9);
          myGLCD.drawCircle(299,15,15);                
        }
    }


    if ((xT>=0) && (xT<=40) && (yT>=150) && (yT<=190)) { // Display Button DS1, DS2,  DS3 or DS4
        if (DS == 1) {
          DS = 2; // Change DS flag to 2
            myGLCD.clrScr();
            drawscreen(); // Initiate the game


          // Draw Display 2 Button Green
            myGLCD.setColor(0, 255, 0);    
            myGLCD.setFont(SmallFont);
            myGLCD.print("DS2",10,174);
            myGLCD.drawCircle(20,180,15);  

        } else if (DS == 2) {
          DS = 3; // Change DS flag to 3
            myGLCD.clrScr();
            drawscreen(); // Initiate the game
      
          
          // Draw Display 1 Button Green
          myGLCD.setColor(0, 255, 0);      
          myGLCD.setFont(SmallFont);
          myGLCD.print("DS3",10,174);
          myGLCD.drawCircle(20,180,15);  

        } else if (DS == 3) {
          DS = 4; // Change DS flag to 4
            myGLCD.clrScr();
            drawscreen(); // Initiate the game
      
          
          // Draw Display 1 Button Green
          myGLCD.setColor(0, 255, 0);      
          myGLCD.setFont(SmallFont);
          myGLCD.print("DS4",10,174);
          myGLCD.drawCircle(20,180,15);  

        } else if (DS == 4) {
          DS = 1; // Change DS flag to 1
            myGLCD.clrScr();
            drawscreen(); // Initiate the game
      
          
          // Draw Display 1 Button Green
          myGLCD.setColor(0, 255, 0);      
          myGLCD.setFont(SmallFont);
          myGLCD.print("DS1",10,174);
          myGLCD.drawCircle(20,180,15);  

        }
    }




    if ((xT>=0) && (xT<=40) && (yT>=199) && (yT<=239)) { // Mute Sound
        if (mute == false) {
          mute = true; // Turn on the mute flag to mute sound
          // Draw Mute Button
          myGLCD.setColor(255, 0, 0);    
          myGLCD.setFont(SmallFont);
          myGLCD.print("0",10,218);
          myGLCD.drawLine(15,222,26,216);
          myGLCD.drawLine(15,225,26,231); 
          myGLCD.drawLine(26,216,26,231);      
          myGLCD.drawCircle(20,224,15); 
        } else {
          mute = false; // Turn off LPF flag and enable sound
          // Draw Green Mute Button
          myGLCD.setColor(0, 255, 0);    
          myGLCD.setFont(SmallFont);
          myGLCD.print("0",10,218);
          myGLCD.drawLine(15,222,26,216);
          myGLCD.drawLine(15,225,26,231); 
          myGLCD.drawLine(26,216,26,231);      
          myGLCD.drawCircle(20,224,15);                 
        }
    }



    if ((xT>=0) && (xT<=40) && (yT>=75) && (yT<=110)) { // Increment PW value
          // Increment PW value
          if (dly1 <= 999){
            dly1++;
            // Print new Pulse Width Value
            myGLCD.setColor(255, 255, 255); // Set colour for items in buttons
            myGLCD.setFont(SmallFont);
            myGLCD.printNumI(dly1,8,70,3); 
          }
    } else
    
    if ((xT>=0) && (xT<=40) && (yT>=130) && (yT<=165)) { // Decrement PW value
          // Decrement PW value
          if (dly1 >= 1){
            dly1--;
            // Print new Pulse Width Value
            myGLCD.setColor(255, 255, 255); // Set colour for items in buttons
            myGLCD.setFont(SmallFont);
            myGLCD.printNumI(dly1,8,70,3); 
          }
    }    

    if ((xT>=280) && (xT<=319) && (yT>=75) && (yT<=110)) { // Increment FRQ value
          // Increment PW value
          if (dly3 <= 999){
            dly3 = dly3 + 20;
            // Print new Pulse Width Value
            myGLCD.setColor(255, 255, 255); // Set colour for items in buttons
            myGLCD.setFont(SmallFont);
            myGLCD.printNumI(dly3,292,70,3); 
          }
    } else
    
    if ((xT>=280) && (xT<=319) && (yT>=130) && (yT<=165)) { // Decrement FRQ value
          // Decrement PW value
          if (dly3 >=25){
            dly3 = dly3 - 20;
            // Print new Pulse Width Value
            myGLCD.setColor(255, 255, 255); // Set colour for items in buttons
            myGLCD.setFont(SmallFont);
            myGLCD.printNumI(dly3,292,70,3); 
          }
    }


//  Coil 1 threshold line on screen *****************************************************************************
    if ((xT>=40) && (xT<=159) && (yT>=0) && (yT<=50)&& (DS >= 2)) { // Decrement and redraw Coil 1 threshold line on screen
          // Increment threshold value
          if (alarm1 >=1 ){

            // Delete old line 
            myGLCD.setColor(0, 0, 0);
        
            myGLCD.drawCircle(43, alarm1, 2); // Coil 1 LHS
            myGLCD.drawCircle(156, alarm1, 2); // Coil 1 RHS
            myGLCD.drawPixel(53, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(63, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(73, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(83, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(93, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(103, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(113, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(123, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(133, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(143, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(153, alarm1); // Coil 1 LHS
            // Increment line
            alarm1--;
            
            // Print new line

            myGLCD.setColor(255, 255, 255);
        
            myGLCD.drawCircle(43, alarm1, 2); // Coil 1 LHS
            myGLCD.drawCircle(156, alarm1, 2); // Coil 1 RHS
            myGLCD.drawPixel(53, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(63, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(73, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(83, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(93, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(103, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(113, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(123, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(133, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(143, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(153, alarm1); // Coil 1 LHS

          }
    }


    if ((xT>=40) && (xT<=159) && (yT>=70) && (yT<=119)&& (DS >= 2)) { // Increment and redraw Coil 1 threshold line on screen
          // Decrement threshold value
          if (alarm1 <= 158 ){

            // Delete old line 
            myGLCD.setColor(0, 0, 0);
        
            myGLCD.drawCircle(43, alarm1, 2); // Coil 1 LHS
            myGLCD.drawCircle(156, alarm1, 2); // Coil 1 RHS
            myGLCD.drawPixel(53, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(63, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(73, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(83, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(93, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(103, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(113, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(123, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(133, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(143, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(153, alarm1); // Coil 1 LHS

            // Decrement line
            alarm1++;
            
            // Print new line

            myGLCD.setColor(255, 255, 255);
        
            myGLCD.drawCircle(43, alarm1, 2); // Coil 1 LHS
            myGLCD.drawCircle(156, alarm1, 2); // Coil 1 RHS
            myGLCD.drawPixel(53, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(63, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(73, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(83, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(93, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(103, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(113, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(123, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(133, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(143, alarm1); // Coil 1 LHS
            myGLCD.drawPixel(153, alarm1); // Coil 1 LHS

          }
    }

//  Coil 2 threshold line on screen *****************************************************************************
    if ((xT>=161) && (xT<=279) && (yT>=0) && (yT<=50)&& (DS >= 2)) { // Decrement and redraw Coil 1 threshold line on screen
          // Increment threshold value
          if (alarm2 >=1 ){

            // Delete old line 
            myGLCD.setColor(0, 0, 0);
        
            myGLCD.drawCircle(164, alarm2, 2); // Coil 2 LHS
            myGLCD.drawCircle(276, alarm2, 2); // Coil 2 RHS
            myGLCD.drawPixel(174, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(184, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(194, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(204, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(214, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(224, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(234, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(244, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(254, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(264, alarm2); // Coil 2 LHS

            // Increment line
            alarm2--;
            
            // Print new line

            myGLCD.setColor(255, 255, 255);
        
            myGLCD.drawCircle(164, alarm2, 2); // Coil 2 LHS
            myGLCD.drawCircle(276, alarm2, 2); // Coil 2 RHS
            myGLCD.drawPixel(174, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(184, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(194, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(204, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(214, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(224, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(234, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(244, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(254, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(264, alarm2); // Coil 2 LHS

          }
    }


    if ((xT>=161) && (xT<=279) && (yT>=70) && (yT<=119)&& (DS >= 2)) { // Increment and redraw Coil 1 threshold line on screen
          // Decrement threshold value
          if (alarm2 <= 158 ){

            // Delete old line 
            myGLCD.setColor(0, 0, 0);
        
            myGLCD.drawCircle(164, alarm2, 2); // Coil 2 LHS
            myGLCD.drawCircle(276, alarm2, 2); // Coil 2 RHS
            myGLCD.drawPixel(174, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(184, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(194, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(204, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(214, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(224, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(234, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(244, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(254, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(264, alarm2); // Coil 2 LHS

            // Decrement line
            alarm2++;
            
            // Print new line

            myGLCD.setColor(255, 255, 255);
        
            myGLCD.drawCircle(164, alarm2, 2); // Coil 2 LHS
            myGLCD.drawCircle(276, alarm2, 2); // Coil 2 RHS
            myGLCD.drawPixel(174, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(184, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(194, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(204, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(214, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(224, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(234, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(244, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(254, alarm2); // Coil 2 LHS
            myGLCD.drawPixel(264, alarm2); // Coil 2 LHS

          }
    }

//  Coil 3 threshold line on screen *****************************************************************************
    if ((xT>=40) && (xT<=159) && (yT>=121) && (yT<=171)&& (DS >= 2)) { // Decrement and redraw Coil 1 threshold line on screen
          // Increment threshold value
          if (alarm3 >=122 ){

            // Delete old line 
            myGLCD.setColor(0, 0, 0);
        
            myGLCD.drawCircle(43, alarm3, 2); // Coil 1 LHS
            myGLCD.drawCircle(156, alarm3, 2); // Coil 1 RHS
            myGLCD.drawPixel(53, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(63, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(73, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(83, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(93, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(103, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(113, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(123, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(133, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(143, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(153, alarm3); // Coil 3 LHS

            // Increment line
            alarm3--;
            
            // Print new line

            myGLCD.setColor(255, 255, 255);
        
            myGLCD.drawCircle(43, alarm3, 2); // Coil 1 LHS
            myGLCD.drawCircle(156, alarm3, 2); // Coil 1 RHS
            myGLCD.drawPixel(53, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(63, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(73, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(83, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(93, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(103, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(113, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(123, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(133, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(143, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(153, alarm3); // Coil 3 LHS

          }
    }





    if ((xT>=40) && (xT<=159) && (yT>=189) && (yT<=239)&& (DS >= 2)) { // Increment and redraw Coil 1 threshold line on screen
          // Decrement threshold value
          if (alarm3 <= 238 ){

            // Delete old line 
            myGLCD.setColor(0, 0, 0);
        
            myGLCD.drawCircle(43, alarm3, 2); // Coil 1 LHS
            myGLCD.drawCircle(156, alarm3, 2); // Coil 1 RHS
            myGLCD.drawPixel(53, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(63, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(73, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(83, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(93, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(103, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(113, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(123, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(133, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(143, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(153, alarm3); // Coil 3 LHS

            // Decrement line
            alarm3++;
            
            // Print new line

            myGLCD.setColor(255, 255, 255);
        
            myGLCD.drawCircle(43, alarm3, 2); // Coil 1 LHS
            myGLCD.drawCircle(156, alarm3, 2); // Coil 1 RHS
            myGLCD.drawPixel(53, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(63, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(73, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(83, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(93, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(103, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(113, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(123, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(133, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(143, alarm3); // Coil 3 LHS
            myGLCD.drawPixel(153, alarm3); // Coil 3 LHS

          }
    }


//  Coil 4 threshold line on screen *****************************************************************************
    if ((xT>=161) && (xT<=279) && (yT>=121) && (yT<=171) && (DS >= 2)) { // Decrement and redraw Coil 1 threshold line on screen
          // Increment threshold value
          if (alarm4 >=122 ){

            // Delete old line 
            myGLCD.setColor(0, 0, 0);
        
            myGLCD.drawCircle(164, alarm4, 2); // Coil 4 LHS
            myGLCD.drawCircle(276, alarm4, 2); // Coil 4 RHS
            myGLCD.drawPixel(174, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(184, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(194, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(204, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(214, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(224, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(234, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(244, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(254, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(264, alarm4); // Coil 4 LHS

            // Increment line
            alarm4--;
            
            // Print new line

            myGLCD.setColor(255, 255, 255);
        
            myGLCD.drawCircle(164, alarm4, 2); // Coil 4 LHS
            myGLCD.drawCircle(276, alarm4, 2); // Coil 4 RHS
            myGLCD.drawPixel(174, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(184, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(194, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(204, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(214, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(224, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(234, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(244, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(254, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(264, alarm4); // Coil 4 LHS

          }
    }


    if ((xT>=161) && (xT<=279) && (yT>=189) && (yT<=239)&& (DS >= 2)) { // Increment and redraw Coil 1 threshold line on screen
          // Decrement threshold value
          if (alarm4 <= 238 ){

            // Delete old line 
            myGLCD.setColor(0, 0, 0);
        
            myGLCD.drawCircle(164, alarm4, 2); // Coil 4 LHS
            myGLCD.drawCircle(276, alarm4, 2); // Coil 4 RHS
            myGLCD.drawPixel(174, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(184, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(194, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(204, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(214, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(224, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(234, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(244, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(254, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(264, alarm4); // Coil 4 LHS

            // Decrement line
            alarm4++;
            
            // Print new line

            myGLCD.setColor(255, 255, 255);
        
            myGLCD.drawCircle(164, alarm4, 2); // Coil 4 LHS
            myGLCD.drawCircle(276, alarm4, 2); // Coil 4 RHS
            myGLCD.drawPixel(174, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(184, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(194, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(204, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(214, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(224, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(234, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(244, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(254, alarm4); // Coil 4 LHS
            myGLCD.drawPixel(264, alarm4); // Coil 4 LHS

          }
    }


  if ((xT>=40) && (xT<=280) && (yT>=0) && (yT<=119)&& (DS == 1)) { // Increment and redraw Coil 1 threshold line on screen
          // Increment threshold value
          if (DS1alarm <= 118 ){

            // Delete old circle 
            myGLCD.setColor(0, 0, 0);
            myGLCD.drawCircle(160,120,DS1alarm);         

            // Increment Threshold line
            DS1alarm++;
            
            // Print new line

            // Draw Blue threshold circle in centre of screen
              myGLCD.setColor(0, 0, 255);  
              myGLCD.drawCircle(160,120,DS1alarm); 
          }
    }

  if ((xT>=40) && (xT<=280) && (yT>=121) && (yT<=238)&& (DS == 1)) { // Decrement and redraw Coil 1 threshold line on screen
          // Decrement threshold value
          if (DS1alarm >=6 ){

            // Delete old circle 
            myGLCD.setColor(0, 0, 0);
            myGLCD.drawCircle(160,120,DS1alarm);         

            // Decrement Threshold line
            DS1alarm--;
            
            // Print new line

            // Draw Blue threshold circle in centre of screen
              myGLCD.setColor(0, 0, 255);  
              myGLCD.drawCircle(160,120,DS1alarm); 
          }
    }




    if ((xT>=280) && (xT<=319) && (yT>=200) && (yT<=239)) { // Change Sensitivity on screen
          
          if (sensitivity == 1 ){  // Change sensitivity to 2X
                sensitivity = 2;
                // Draw Sensitivity Button 
                myGLCD.setColor(0, 255, 0);    
                myGLCD.setFont(SmallFont);
                myGLCD.print("2X",292,218);
                myGLCD.drawCircle(299,224,15); 

                if (DS == 1) { // Increase the DS Alarm Threshold by 15
                  DS1alarm = 30;
                  drawscreen();
                }
          } else
          if (sensitivity == 2 ){  // Change sensitivity to 4X
                sensitivity = 4;
                // Draw Sensitivity Button 
                myGLCD.setColor(0, 255, 0);    
                myGLCD.setFont(SmallFont);
                myGLCD.print("4X",292,218);
                myGLCD.drawCircle(299,224,15);
                
                if (DS == 1) { // Increase the DS Alarm Threshold by 15
                  DS1alarm = 45;
                  drawscreen();                  
                }
          } else
          if (sensitivity == 4 ){  // Change sensitivity to 6X
                sensitivity = 6;
                // Draw Sensitivity Button 
                myGLCD.setColor(0, 255, 0);    
                myGLCD.setFont(SmallFont);
                myGLCD.print("6X",292,218);
                myGLCD.drawCircle(299,224,15); 
                
                if (DS == 1) { // Increase the DS Alarm Threshold by 15
                  DS1alarm = 60;
                  drawscreen();                  
                }
                
         } else
          if (sensitivity == 6 ){  // Change sensitivity to 1X
                sensitivity = 1;
                // Draw Sensitivity Button 
                myGLCD.setColor(0, 255, 0);    
                myGLCD.setFont(SmallFont);
                myGLCD.print("1X",292,218);
                myGLCD.drawCircle(299,224,15); 

                if (DS == 1) { // Increase the DS Alarm Threshold by 15
                  DS1alarm = 15;
                  drawscreen();                  
                }

          }         


      if (DS >= 2) {
        clearthresholds(); // Clear thetheshold lines
    
              // Reset the threshold lines to the baseline values
              alarm1 = 80;
              alarm2 = 80;
              alarm3 = 200;
              alarm4 = 200;
        
        drawthresholds(); // Redraw thetheshold lines
      }
  
      sample = false; // Reset callibrate flag to start calibration

          // Draw Cal Button Red
          myGLCD.setColor(255, 0, 0);    
          myGLCD.setFont(SmallFont);
          myGLCD.print("CAL",10,9);
          myGLCD.drawCircle(20,15,15);  
          
          calav1 = 0; // Used to calcuate average of ten samples
          calav2 = 0; // Used to calcuate average of ten samples
          calav3 = 0; // Used to calcuate average of ten samples
          calav4 = 0; // Used to calcuate average of ten samples
          
          div1 = 0;
          div2 = 0;
          div3 = 0;
          div4 = 0;
    }


         screenPressed = true;
   }
    // Doesn't allow holding the screen / you must tap it
    else if ( !myTouch.dataAvailable() && screenPressed){
      screenPressed = false;
   }
  
  
  // Callibrate
  // Wait for a period of time to set baseline for each coil
      
   if (sample == false){
         calcounter++;
         }

     if ( calcounter >= 90 ) { // Add up the samples andprepare to calculate the average

     if (pc1 > 4000) {
       calav1 = calav1 + pc1;
       div1++;
     }

     if (pc2 > 4000) {
       calav2 = calav2 + pc2;
       div2++;
     }
  
     if (pc3 > 4000) {
       calav3 = calav3 + pc3;
       div3++;
     }
  
     if (pc4 > 4000) {
       calav4 = calav4 + pc4;
       div4++;
     }
  
   }

  if ((calcounter >= scount)&&(sample == false)){

    // Test tone
    // tone(A0, 500);
    // noTone(A0); 

    // Set the thresholds

    calav1 = calav1/div1;
    calav2 = calav2/div2;
    calav3 = calav3/div3;
    calav4 = calav4/div4;      

    myGLCD.setColor(0, 255, 0);    
    myGLCD.setFont(SmallFont);
    myGLCD.print("CAL",10,9);
    myGLCD.drawCircle(20,15,15);
    
    // Reset the sample flag
    sample = true;
    calcounter = 0;
  
  myGLCD.clrScr();
  drawscreen();  // redraw screen
  } 

  // Reset samples
        pc1 = 0; // Reset counter after [printing result
        pc2 = 0; // Reset counter after [printing result
        pc3 = 0; // Reset counter after [printing result
        pc4 = 0; // Reset counter after [printing result 


    // Test tone
    // tone(A0, 500);
    // noTone(A0); 

  // Turn off any tones during sampleprocess
 
   noTone(A0); 

 
  // **********************************************************************************************
  // Pulse and read Channel 1 Coil --------------------------------------------- (Swap Channel 1 with Channel 2 receive function
  
  digitalWrite(8,HIGH); // Set the output pin to high
  delayMicroseconds(dly1); // Delay in microseconds before setting low on output pin
  digitalWrite(8,LOW); // Set low on output pin
  delayMicroseconds(dly2); // Delay 5000 microseconds before setting low on output pin
  pc1 = pulseIn(9,LOW,pwindow);
  delayMicroseconds(dly3); // Delay in microseconds before setting HIGH on output pin



  // Pulse and read Channe1 2 Coil ---------------------------------------------

  digitalWrite(10,HIGH); // Set the output pin to high
  delayMicroseconds(dly1); // Delay in microseconds before setting low on output pin
  digitalWrite(10,LOW); // Set low on output pin
  delayMicroseconds(dly2); // Delay 5000 microseconds before setting low on output pin
  pc2 = pulseIn(11,LOW,pwindow);
  delayMicroseconds(dly3); // Delay in microseconds before setting HIGH on output pin 
  
  // Pulse and read Channel 3 Coil ---------------------------------------------
  
  digitalWrite(12,HIGH); // Set the output pin to high
  delayMicroseconds(dly1); // Delay in microseconds before setting low on output pin
  digitalWrite(12,LOW); // Set low on output pin
  delayMicroseconds(dly2); // Delay 5000 microseconds before setting low on output pin
  pc3 = pulseIn(13,LOW,pwindow);
  delayMicroseconds(dly3); // Delay in microseconds before setting HIGH on output pin

  // Pulse and read Channel 4 Coil ---------------------------------------------
  
  digitalWrite(14,HIGH); // Set the output pin to high
  delayMicroseconds(dly1); // Delay in microseconds before setting low on output pin
  digitalWrite(14,LOW); // Set low on output pin
  delayMicroseconds(dly2); // Delay 5000 microseconds before setting low on output pin
  pc4 = pulseIn(15,LOW,pwindow);
  delayMicroseconds(dly3); // Delay in microseconds before setting HIGH on output pin

  if (DS == 1) {
    updatedisplay1(); // Swap this in 
    } else 
  if (DS == 2) {
    updatedisplay2();
    } else 
  if (DS == 3) {
    updatedisplay3();
    }   
  if (DS == 4) {
    updatedisplay4();
    } 
      
}


// Subroutines

void updatedisplay1(){ // Update Display 1 format
 
// Used to refresh threshold circle
DS1refresh++;

if (DS1refresh >= 40) {
    DS1refresh = 0; // Reset timer
    // Draw Blue threshold circle in centre of screen
    myGLCD.setColor(0, 0, 255);  
    myGLCD.drawCircle(160,120,DS1alarm); 
}

// Sound Alarm if Threshold breached on any thresholds - Vary if Multiplier on

if (((abs(160-DS1X)>=DS1alarm-5)||(abs(120-DS1Y)>=DS1alarm-5))&&(mute != true)){

  tone(A0, tonefreq);
}
 
// Delete Previous Bubble and reset DS1X, DS1Y
  myGLCD.setColor(0, 0, 0);
//  myGLCD.fillCircle(DS1X,DS1Y,10); // Delete previous
    myGLCD.drawRect(DS1X-5,DS1Y-5,DS1X+5,DS1Y+5); // Draw box at centre of balanaced signal
    
  DS1X = 160;
  DS1Y = 120;

  
 
// Draw trace for Coil 1 ****************************************************************************************************
 
 
      
  if (sample == true){
 
  // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
  if ( LPF == true) {
    if (pc1 >= 2000) {
      smoothedvalue1 = (alpha * smoothedvalue1) + ( (1 - alpha) * pc1);
 
      }
    pc1 = smoothedvalue1;
    }  
 
 
   
      if (pc1 != 0) {
 
  
    // Calculate trace pixel
 
      if(sensitivity == 1){ // Sensitivity x1
          ytrace1 = (pc1-calav1 );// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace1 = ((2*(pc1-calav1)) );// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace1 = ((4*(pc1-calav1)) );// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace1 = ((6*(pc1-calav1)) );// Calculate the y value for pixel  @ x6 Sensitivity
      }
 
  } 
      
}
  
 
 
  // Draw trace for Coil 2  ****************************************************************************************************
 
 
  if (sample == true){
 
    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc2 >= 2000) {
        smoothedvalue2 = (alpha * smoothedvalue2) + ( (1 - alpha) * pc2);
        }
      pc2 = smoothedvalue2;
    }  
 
  
    
 
    // Draw  trace
 
      if (pc2 != 0) {

    
    // Calculate trace pixel
 
      if(sensitivity == 1){ // Sensitivity x1
          ytrace2 = (pc2-calav2 );// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace2 = ((2*(pc2-calav2)) );// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace2 = ((4*(pc2-calav2)) );// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace2 = ((6*(pc2-calav2)) );// Calculate the y value for pixel  @ x6 Sensitivity
      }
 
   }
}
 
 
  // Draw trace for Coil 3 ****************************************************************************************************
 
  if (sample == true){
 
    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc3 >= 2000) {
        smoothedvalue3 = (alpha * smoothedvalue3) + ( (1 - alpha) * pc3);
        }
      pc3 = smoothedvalue3;
    }   
  
    
    // Draw  trace
 
      if (pc3 != 0) {
 
    
    // Calculate trace pixel
 
      if(sensitivity == 1){ // Sensitivity x1
          ytrace3 = (pc3-calav3 );// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace3 = ((2*(pc3-calav3)) );// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace3 = ((4*(pc3-calav3)) );// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace3 = ((6*(pc3-calav3)) );// Calculate the y value for pixel  @ x4 Sensitivity
      }
 
   }
 
}
 
 
  // Draw trace for Coil 4 ****************************************************************************************************
 
  if (sample == true){
 
    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc4 >= 2000) {
        smoothedvalue4 = (alpha * smoothedvalue4) + ( (1 - alpha) * pc4);
        }
      pc4 = smoothedvalue4;
    }   
  
    
    // Draw  trace
 
      if (pc4 != 0) {

    
    // Calculate trace pixel
 
 
      if(sensitivity == 1){ // Sensitivity x1
          ytrace4 = (pc4-calav4 );// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace4 = ((2*(pc4-calav4)) );// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace4 = ((4*(pc4-calav4)) );// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace4 = ((6*(pc4-calav4)) );// Calculate the y value for pixel  @ x6 Sensitivity
      }
      
 
    } 

  }

 /* Draw the Location of the target

    DS1X = DS1X + ytrace1 - ytrace2 + ytrace3 - ytrace4;
    DS1Y = DS1Y + ytrace1 + ytrace2 - ytrace3 - ytrace4;
*/

 // Draw the Location of the target

    DS1X = (DS1X + ytrace1 - ytrace2 + ytrace3 - ytrace4);
    DS1Y = (DS1Y + ytrace1 + ytrace2 - ytrace3 - ytrace4);
    
    // Reset to screen limits if exceeded X = 40 - 280, y = 0 - 239
    
    if (DS1X >= 235) { DS1X = 234; }
    if (DS1X <=  86) { DS1X =  87; }    
    
    if (DS1Y >= 190) { DS1Y = 189; }
    if (DS1Y <=  48) { DS1Y =  49; } 
    
//    myGLCD.setColor(0, 255, 0); 
    myGLCD.setColor(255, 255, 255);     
    myGLCD.drawRect(DS1X-5,DS1Y-5,DS1X+5,DS1Y+5); // Draw box at centre of balanaced signal
 
/* 
    // temp draw values for testing purposes
    myGLCD.setColor(255, 255, 255);
    myGLCD.printNumI(ytrace1,70,40,4);
    myGLCD.printNumI(ytrace2,170,40,4);
    myGLCD.printNumI(ytrace3,70,160,4);    
    myGLCD.printNumI(ytrace4,170,160,4);
*/ 
 
}



void updatedisplay2(){ // Update Display 1 format

// Sound Alarm if Threshold breached

  if ((ytrace1 <= alarm1)&&(mute != true)){
    tone(A0, tonefreq);
  }

  if ((ytrace2 <= alarm2)&&(mute != true)){
    tone(A0, tonefreq);
  }
  
  if ((ytrace3 <= alarm3)&&(mute != true)){
    tone(A0, tonefreq);
  }

  if ((ytrace4 <= alarm4)&&(mute != true)){
    tone(A0, tonefreq);
  }

  if (sample == true){


  // Draw trace for Coil 1 ****************************************************************************************************



  // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
  if ( LPF == true) {
    if (pc1 >= 2000) {
      smoothedvalue1 = (alpha * smoothedvalue1) + ( (1 - alpha) * pc1);
      }
    pc1 = smoothedvalue1;
    }  


    myGLCD.setColor(0, 255, 0);

    // Calculate trace pixel

      if(sensitivity == 1){ // Sensitivity x1
          ytrace1 = (pc1-calav1+bline1);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace1 = ((2*(pc1-calav1))+bline1);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace1 = ((4*(pc1-calav1))+bline1);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace1 = ((6*(pc1-calav1))+bline1);// Calculate the y value for pixel  @ x6 Sensitivity
      }




      if (ytrace1 <= 1){ // Upper and lower limit for trace is cut off here
        ytrace1 = 1;
      } else
      if (ytrace1 >= 118){
        ytrace1 = 118;
      }
    
    // Delete pixel in front of the trace
    if (xtrace1 <= 117) {

      if (pc1 != 0) {

        myGLCD.drawPixel(xtrace1+40,ytrace1); // Draw the pixel if pc1 not zero
 
      }

      myGLCD.setColor(0, 0, 0);
      myGLCD.drawPixel(xtrace1+41,memtrace1[xtrace1+1]); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
      memtrace1[xtrace1] = ytrace1; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
    myGLCD.setColor(0, 255, 255);
    myGLCD.printNumI(pc1,100,40,4);  


    
    xtrace1++; // Increment trace X value

    if (xtrace1 >= 118) {  // if Trace exceeds RHS then reset
      xtrace1 = 1;
      myGLCD.setColor(0, 0, 0);
      myGLCD.drawPixel(41,memtrace1[xtrace1]); // Top Left Coil 1
      }

 

  


  // Draw trace for Coil 2  ****************************************************************************************************



    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc2 >= 2000) {
        smoothedvalue2 = (alpha * smoothedvalue2) + ( (1 - alpha) * pc2);
        }
      pc2 = smoothedvalue2;
    }  

  
    
    // Set Colour
    myGLCD.setColor(255, 0, 0);
    
    // Calculate trace pixel

      if(sensitivity == 1){ // Sensitivity x1
          ytrace2 = (pc2-calav2+bline1);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace2 = ((2*(pc2-calav2))+bline1);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace2 = ((4*(pc2-calav2))+bline1);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace2 = ((6*(pc2-calav2))+bline1);// Calculate the y value for pixel  @ x6 Sensitivity
      }


      if (ytrace2 <= 1){ // Upper and lower limit for trace is cut off here
        ytrace2 = 1;
      } else
      if (ytrace2 >= 118){
        ytrace2 = 118;
      }


    // Delete pixel in front of the trace

    if (xtrace2 <= 117) {

      if (pc2 != 0) {
         myGLCD.drawPixel(xtrace2+161,ytrace2); // Draw the pixel not zero reading
      }


      myGLCD.setColor(0, 0, 0);
      myGLCD.drawPixel(xtrace2+162,memtrace2[xtrace2+1]); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
      memtrace2[xtrace2] = ytrace2; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
    myGLCD.setColor(0, 255, 255);
    myGLCD.printNumI(pc2,200,40,4);   


    
    xtrace2++; // Increment trace X value

    if (xtrace2 >= 118) {  // if Trace exceeds RHS then reset
        xtrace2 = 1;
        myGLCD.setColor(0, 0, 0);
        myGLCD.drawPixel(162,memtrace2[xtrace2]); // Top Left Coil 2
        }



  // Draw trace for Coil 3 ****************************************************************************************************



    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc3 >= 2000) {
        smoothedvalue3 = (alpha * smoothedvalue3) + ( (1 - alpha) * pc3);
        }
      pc3 = smoothedvalue3;
    }   
  
    
    // Set Colour
    myGLCD.setColor(255, 255, 0);
    
    // Calculate trace pixel

      if(sensitivity == 1){ // Sensitivity x1
          ytrace3 = (pc3-calav3+bline2);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace3 = ((2*(pc3-calav3))+bline2);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace3 = ((4*(pc3-calav3))+bline2);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace3 = ((6*(pc3-calav3))+bline2);// Calculate the y value for pixel  @ x4 Sensitivity
      }


      if (ytrace3 <= 122){
        ytrace3 = 122;
      } else
      if (ytrace3 >= 238){
        ytrace3 = 238;
      }

    // Delete pixel in front of the trace

    if (xtrace3 <= 117) {
      if (pc3 != 0) {
        myGLCD.drawPixel(xtrace3+40,ytrace3); // Draw the pixel if pc3 not zero reading
      }
      myGLCD.setColor(0, 0, 0);
      myGLCD.drawPixel(xtrace3+41,memtrace3[xtrace3+1]); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
      memtrace3[xtrace3] = ytrace3; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
    myGLCD.setColor(0, 255, 255);
    myGLCD.printNumI(pc3,100,140,4);    


    
    xtrace3++; // Increment trace X value

    if (xtrace3 >= 118) {  // if Trace exceeds RHS then reset
      xtrace3 = 1;
      myGLCD.setColor(0, 0, 0);
      myGLCD.drawPixel(41,memtrace3[xtrace3]); // Top Left Coil 1
      }

  




  // Draw trace for Coil 4 ****************************************************************************************************



    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc4 >= 2000) {
        smoothedvalue4 = (alpha * smoothedvalue4) + ( (1 - alpha) * pc4);
        }
      pc4 = smoothedvalue4;
    }   
  
    
    // Set Colour
    myGLCD.setColor(255, 255, 255);
    
    // Calculate trace pixel


      if(sensitivity == 1){ // Sensitivity x1
          ytrace4 = (pc4-calav4+bline2);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace4 = ((2*(pc4-calav4))+bline2);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace4 = ((4*(pc4-calav4))+bline2);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace4 = ((6*(pc4-calav4))+bline2);// Calculate the y value for pixel  @ x6 Sensitivity
      }
      

      if (ytrace4 <= 122){
        ytrace4 = 122;
      } else
      if (ytrace4 >= 238){
        ytrace4 = 238;
      }


    // Delete pixel in front of the trace

    if (xtrace4 <= 117) {

      if (pc4 != 0) {
        myGLCD.drawPixel(xtrace4+161,ytrace4); // Draw the pixel
      }
      myGLCD.setColor(0, 0, 0);
      myGLCD.drawPixel(xtrace4+162,memtrace4[xtrace4+1]); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
      memtrace4[xtrace4] = ytrace4; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
    myGLCD.setColor(0, 255, 255);
    myGLCD.printNumI(pc4,200,140,4);  


    
    xtrace4++; // Increment trace X value

    if (xtrace4 >= 118) {  // if Trace exceeds RHS then reset
        xtrace4 = 1;
        myGLCD.setColor(0, 0, 0);
        myGLCD.drawPixel(162,memtrace4[xtrace4]); // Top Left Coil 2
        drawthresholds(); // redraw the threshold lines
              
        }
  }

}


void updatedisplay3(){ // Update Display 3 format



  // Draw trace for Coil 1 ****************************************************************************************************

  if (sample == true){

  // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
  if ( LPF == true) {
    if (pc1 >= 2000) {
      smoothedvalue1 = (alpha * smoothedvalue1) + ( (1 - alpha) * pc1);
      }
    pc1 = smoothedvalue1;
    }  


    myGLCD.setColor(0, 255, 0);

    // Calculate trace pixel

      if(sensitivity == 1){ // Sensitivity x1
          ytrace1 = (pc1-calav1+bline1);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace1 = ((2*(pc1-calav1))+bline1);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace1 = ((4*(pc1-calav1))+bline1);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace1 = ((6*(pc1-calav1))+bline1);// Calculate the y value for pixel  @ x6 Sensitivity
      }




      if (ytrace1 <= 1){ // Upper and lower limit for trace is cut off here
        ytrace1 = 1;
      } else
      if (ytrace1 >= 118){
        ytrace1 = 118;
      }
    
    // Delete pixel in front of the trace
    if ((xtrace1 <= 117) && (xtrace1 >= 3)) {

      if (pc1 != 0) {

        myGLCD.fillCircle(xtrace1+40,ytrace1,2); // Draw the pixel if pc1 not zero
 
      }

      myGLCD.setColor(0, 0, 0);
      myGLCD.fillCircle(xtrace1+41,memtrace1[xtrace1+1],2); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
      memtrace1[xtrace1] = ytrace1; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
//    myGLCD.setColor(0, 255, 255);
//    myGLCD.printNumI(ytrace1,0,40,3);
//    myGLCD.printNumI(xtrace1,0,60,3);    
//    myGLCD.printNumI(pc1,0,100,4);  


    
    xtrace1++; // Increment trace X value

    if (xtrace1 >= 118) {  // if Trace exceeds RHS then reset
      xtrace1 = 3;
      myGLCD.setColor(0, 0, 0);
      myGLCD.fillCircle(41,memtrace1[xtrace1],3); // Top Left Coil 1
      }

  }

// Sound Alarm if Threshold breached

if ((ytrace1 <= alarm1)&&(mute != true)){
  tone(A0, tonefreq);
}
  


  // Draw trace for Coil 2  ****************************************************************************************************

  if (sample == true){

    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc2 >= 2000) {
        smoothedvalue2 = (alpha * smoothedvalue2) + ( (1 - alpha) * pc2);
        }
      pc2 = smoothedvalue2;
    }  

  
    
    // Set Colour
    myGLCD.setColor(255, 0, 0);
    
    // Calculate trace pixel

      if(sensitivity == 1){ // Sensitivity x1
          ytrace2 = (pc2-calav2+bline1);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace2 = ((2*(pc2-calav2))+bline1);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace2 = ((4*(pc2-calav2))+bline1);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace2 = ((6*(pc2-calav2))+bline1);// Calculate the y value for pixel  @ x6 Sensitivity
      }


      if (ytrace2 <= 1){ // Upper and lower limit for trace is cut off here
        ytrace2 = 1;
      } else
      if (ytrace2 >= 118){
        ytrace2 = 118;
      }


    // Delete pixel in front of the trace

    if ((xtrace2 <= 117)&& (xtrace2 >= 3)) {

      if (pc2 != 0) {
         myGLCD.fillCircle(xtrace2+161,ytrace2,2); // Draw the pixel not zero reading
      }


      myGLCD.setColor(0, 0, 0);
      myGLCD.fillCircle(xtrace2+162,memtrace2[xtrace2+1],2); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
      memtrace2[xtrace2] = ytrace2; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes

//    myGLCD.printNumI(pc1,0,100,4);  


    
    xtrace2++; // Increment trace X value

    if (xtrace2 >= 118) {  // if Trace exceeds RHS then reset
        xtrace2 = 3;
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillCircle(162,memtrace2[xtrace2],3); // Top Left Coil 2
        }
  }

if ((ytrace2 <= alarm2)&&(mute != true)){
  tone(A0, tonefreq);
}


  // Draw trace for Coil 3 ****************************************************************************************************

  if (sample == true){

    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc3 >= 2000) {
        smoothedvalue3 = (alpha * smoothedvalue3) + ( (1 - alpha) * pc3);
        }
      pc3 = smoothedvalue3;
    }   
  
    
    // Set Colour
    myGLCD.setColor(255, 255, 0);
    
    // Calculate trace pixel

      if(sensitivity == 1){ // Sensitivity x1
          ytrace3 = (pc3-calav3+bline2);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace3 = ((2*(pc3-calav3))+bline2);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace3 = ((4*(pc3-calav3))+bline2);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace3 = ((6*(pc3-calav3))+bline2);// Calculate the y value for pixel  @ x4 Sensitivity
      }


      if (ytrace3 <= 122){
        ytrace3 = 122;
      } else
      if (ytrace3 >= 238){
        ytrace3 = 238;
      }

    // Delete pixel in front of the trace

    if ((xtrace3 <= 117) && (xtrace3 >= 3)) {
      if (pc3 != 0) {
        myGLCD.fillCircle(xtrace3+40,ytrace3,2); // Draw the pixel if pc3 not zero reading
      }
      myGLCD.setColor(0, 0, 0);
      myGLCD.fillCircle(xtrace3+41,memtrace3[xtrace3+1],2); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
      memtrace3[xtrace3] = ytrace3; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
//    myGLCD.setColor(0, 255, 255);
//    myGLCD.printNumI(ytrace1,0,40,3);
//    myGLCD.printNumI(xtrace1,0,60,3);    
//    myGLCD.printNumI(pc1,0,100,4);  


    
    xtrace3++; // Increment trace X value

    if (xtrace3 >= 118) {  // if Trace exceeds RHS then reset
      xtrace3 = 3;
      myGLCD.setColor(0, 0, 0);
      myGLCD.fillCircle(41,memtrace3[xtrace3],3); // Top Left Coil 1
      }

  }

if ((ytrace3 <= alarm3)&&(mute != true)){
  tone(A0, tonefreq);
}


  // Draw trace for Coil 4 ****************************************************************************************************

  if (sample == true){

    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc4 >= 2000) {
        smoothedvalue4 = (alpha * smoothedvalue4) + ( (1 - alpha) * pc4);
        }
      pc4 = smoothedvalue4;
    }   
  
    
    // Set Colour
    myGLCD.setColor(255, 255, 255);
    
    // Calculate trace pixel


      if(sensitivity == 1){ // Sensitivity x1
          ytrace4 = (pc4-calav4+bline2);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace4 = ((2*(pc4-calav4))+bline2);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace4 = ((4*(pc4-calav4))+bline2);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace4 = ((6*(pc4-calav4))+bline2);// Calculate the y value for pixel  @ x6 Sensitivity
      }
      

      if (ytrace4 <= 122){
        ytrace4 = 122;
      } else
      if (ytrace4 >= 238){
        ytrace4 = 238;
      }


    // Delete pixel in front of the trace

    if ((xtrace4 <= 117) && (xtrace4 >= 3)) {

      if (pc4 != 0) {
        myGLCD.fillCircle(xtrace4+161,ytrace4,2); // Draw the pixel
      }
      myGLCD.setColor(0, 0, 0);
      myGLCD.fillCircle(xtrace4+162,memtrace4[xtrace4+1],2); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
      memtrace4[xtrace4] = ytrace4; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
//    myGLCD.setColor(0, 255, 255);
//    myGLCD.printNumI(ytrace1,0,40,3);
//    myGLCD.printNumI(xtrace1,0,60,3);    
//    myGLCD.printNumI(pc1,0,100,4);  
    
    xtrace4++; // Increment trace X value

    if (xtrace4 >= 118) {  // if Trace exceeds RHS then reset
        xtrace4 = 3;
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillCircle(162,memtrace4[xtrace4],3); // Top Left Coil 2
        drawthresholds(); // redraw the threshold lines
        
        // Draw 4 boxes to house the oscilliscope

        myGLCD.setColor(1, 73, 240);
        myGLCD.drawRoundRect(40, 0, 159, 119); 
        myGLCD.drawRoundRect(161, 0, 280, 119);  
        myGLCD.drawRoundRect(40, 121, 159, 239); 
        myGLCD.drawRoundRect(161, 121, 280, 239); 

      
        }
  }


  if ((ytrace4 <= alarm4)&&(mute != true)){
    tone(A0, tonefreq);
    }
}


void updatedisplay4(){ // Update Display  format

// Used to refresh threshold circle
DS4refresh++;

if (DS4refresh >= 650) {
    DS4refresh = 0; // Reset timer
    // Draw Blue threshold circle in centre of screen
    drawscreen();
}


// Sound Alarm if Threshold breached

  if ((ytrace1 <= alarm1)&&(mute != true)){
    tone(A0, tonefreq);
  }

  if ((ytrace2 <= alarm2)&&(mute != true)){
    tone(A0, tonefreq);
  }
  
  if ((ytrace3 <= alarm3)&&(mute != true)){
    tone(A0, tonefreq);
  }

  if ((ytrace4 <= alarm4)&&(mute != true)){
    tone(A0, tonefreq);
  }

  if (sample == true){


  // Draw trace for Coil 1 ****************************************************************************************************



  // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
  if ( LPF == true) {
    if (pc1 >= 2000) {
      smoothedvalue1 = (alpha * smoothedvalue1) + ( (1 - alpha) * pc1);
      }
    pc1 = smoothedvalue1;
    }  


    myGLCD.setColor(0, 255, 0);

    // Calculate trace pixel

      if(sensitivity == 1){ // Sensitivity x1
          ytrace1 = (pc1-calav1+bline1);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace1 = ((2*(pc1-calav1))+bline1);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace1 = ((4*(pc1-calav1))+bline1);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace1 = ((6*(pc1-calav1))+bline1);// Calculate the y value for pixel  @ x6 Sensitivity
      }




      if (ytrace1 <= 1){ // Upper and lower limit for trace is cut off here
        ytrace1 = 1;
      } else
      if (ytrace1 >= 118){
        ytrace1 = 118;
      }
    
    // Delete pixel in front of the trace
    if (xtrace1 <= 117) {

      if (pc1 != 0) {

        myGLCD.drawPixel(xtrace1+40,ytrace1); // Draw the pixel if pc1 not zero
 
      }

//      myGLCD.setColor(0, 0, 0);
//      myGLCD.drawPixel(xtrace1+41,memtrace1[xtrace1+1]); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
//      memtrace1[xtrace1] = ytrace1; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
//    myGLCD.setColor(0, 255, 255);
//    myGLCD.printNumI(ytrace1,0,40,3);
//    myGLCD.printNumI(xtrace1,0,60,3);    
//    myGLCD.printNumI(pc1,0,100,4);  


    
    xtrace1++; // Increment trace X value

    if (xtrace1 >= 118) {  // if Trace exceeds RHS then reset
      xtrace1 = 1;
//      myGLCD.setColor(0, 0, 0);
//      myGLCD.drawPixel(41,memtrace1[xtrace1]); // Top Left Coil 1
      }

 

  


  // Draw trace for Coil 2  ****************************************************************************************************



    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc2 >= 2000) {
        smoothedvalue2 = (alpha * smoothedvalue2) + ( (1 - alpha) * pc2);
        }
      pc2 = smoothedvalue2;
    }  

  
    
    // Set Colour
    myGLCD.setColor(255, 0, 0);
    
    // Calculate trace pixel

      if(sensitivity == 1){ // Sensitivity x1
          ytrace2 = (pc2-calav2+bline1);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace2 = ((2*(pc2-calav2))+bline1);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace2 = ((4*(pc2-calav2))+bline1);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace2 = ((6*(pc2-calav2))+bline1);// Calculate the y value for pixel  @ x6 Sensitivity
      }


      if (ytrace2 <= 1){ // Upper and lower limit for trace is cut off here
        ytrace2 = 1;
      } else
      if (ytrace2 >= 118){
        ytrace2 = 118;
      }


    // Delete pixel in front of the trace

    if (xtrace2 <= 117) {

      if (pc2 != 0) {
         myGLCD.drawPixel(xtrace2+161,ytrace2); // Draw the pixel not zero reading
      }


//      myGLCD.setColor(0, 0, 0);
//      myGLCD.drawPixel(xtrace2+162,memtrace2[xtrace2+1]); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
      memtrace2[xtrace2] = ytrace2; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes

//    myGLCD.printNumI(pc1,0,100,4);  


    
    xtrace2++; // Increment trace X value

    if (xtrace2 >= 118) {  // if Trace exceeds RHS then reset
        xtrace2 = 1;
//        myGLCD.setColor(0, 0, 0);
//        myGLCD.drawPixel(162,memtrace2[xtrace2]); // Top Left Coil 2
        }



  // Draw trace for Coil 3 ****************************************************************************************************



    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc3 >= 2000) {
        smoothedvalue3 = (alpha * smoothedvalue3) + ( (1 - alpha) * pc3);
        }
      pc3 = smoothedvalue3;
    }   
  
    
    // Set Colour
    myGLCD.setColor(255, 255, 0);
    
    // Calculate trace pixel

      if(sensitivity == 1){ // Sensitivity x1
          ytrace3 = (pc3-calav3+bline2);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace3 = ((2*(pc3-calav3))+bline2);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace3 = ((4*(pc3-calav3))+bline2);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace3 = ((6*(pc3-calav3))+bline2);// Calculate the y value for pixel  @ x4 Sensitivity
      }


      if (ytrace3 <= 122){
        ytrace3 = 122;
      } else
      if (ytrace3 >= 238){
        ytrace3 = 238;
      }

    // Delete pixel in front of the trace

    if (xtrace3 <= 117) {
      if (pc3 != 0) {
        myGLCD.drawPixel(xtrace3+40,ytrace3); // Draw the pixel if pc3 not zero reading
      }
//      myGLCD.setColor(0, 0, 0);
//      myGLCD.drawPixel(xtrace3+41,memtrace3[xtrace3+1]); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
//      memtrace3[xtrace3] = ytrace3; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
//    myGLCD.setColor(0, 255, 255);
//    myGLCD.printNumI(ytrace1,0,40,3);
//    myGLCD.printNumI(xtrace1,0,60,3);    
//    myGLCD.printNumI(pc1,0,100,4);  


    
    xtrace3++; // Increment trace X value

    if (xtrace3 >= 118) {  // if Trace exceeds RHS then reset
      xtrace3 = 1;
//      myGLCD.setColor(0, 0, 0);
//      myGLCD.drawPixel(41,memtrace3[xtrace3]); // Top Left Coil 1
      }

  




  // Draw trace for Coil 4 ****************************************************************************************************



    // Check if LPF enabled then apply Low Pass Filter to signal to smooth trace
    if ( LPF == true) {
      if (pc4 >= 2000) {
        smoothedvalue4 = (alpha * smoothedvalue4) + ( (1 - alpha) * pc4);
        }
      pc4 = smoothedvalue4;
    }   
  
    
    // Set Colour
    myGLCD.setColor(255, 255, 255);
    
    // Calculate trace pixel


      if(sensitivity == 1){ // Sensitivity x1
          ytrace4 = (pc4-calav4+bline2);// Calculate the y value for pixel @ x1 Sensitivity
      } else
      if(sensitivity == 2){ // Sensitivity x2
          ytrace4 = ((2*(pc4-calav4))+bline2);// Calculate the y value for pixel  @ x2 Sensitivity
      } else 
      if(sensitivity == 4){ // Sensitivity x4
          ytrace4 = ((4*(pc4-calav4))+bline2);// Calculate the y value for pixel  @ x4 Sensitivity
      }else 
      if(sensitivity == 6){ // Sensitivity x6
          ytrace4 = ((6*(pc4-calav4))+bline2);// Calculate the y value for pixel  @ x6 Sensitivity
      }
      

      if (ytrace4 <= 122){
        ytrace4 = 122;
      } else
      if (ytrace4 >= 238){
        ytrace4 = 238;
      }


    // Delete pixel in front of the trace

    if (xtrace4 <= 117) {

      if (pc4 != 0) {
        myGLCD.drawPixel(xtrace4+161,ytrace4); // Draw the pixel
      }
//      myGLCD.setColor(0, 0, 0);
//      myGLCD.drawPixel(xtrace4+162,memtrace4[xtrace4+1]); // Delete Pixel in front of new pixel to clear scree    

      // Record the current Y value of pixel in array for future deletion after next sweep  
//      memtrace4[xtrace4] = ytrace4; // Store the current y coordinate of the trace so it can be cleared later

      } 


    // temp draw values for testing purposes
//    myGLCD.setColor(0, 255, 255);
//    myGLCD.printNumI(ytrace1,0,40,3);
//    myGLCD.printNumI(xtrace1,0,60,3);    
//    myGLCD.printNumI(pc1,0,100,4);  


    
    xtrace4++; // Increment trace X value

    if (xtrace4 >= 118) {  // if Trace exceeds RHS then reset
        xtrace4 = 1;
//        myGLCD.setColor(0, 0, 0);
//       myGLCD.drawPixel(162,memtrace4[xtrace4]); // Top Left Coil 2
        drawthresholds(); // redraw the threshold lines
              
        }
  }

} 


// ===== Draw startup screen for each Display setting
void drawscreen() {

    myGLCD.clrScr(); // Clear the screen  
  
  // Draw Cal Button 
    myGLCD.setColor(0, 255, 0);    
    myGLCD.setFont(SmallFont);
    myGLCD.print("CAL",10,9);
    myGLCD.drawCircle(20,15,15);  

if (DS == 1) {
  // Draw Display 1 Button Green
    myGLCD.setColor(0, 255, 0);      
    myGLCD.setFont(SmallFont);
    myGLCD.print("DS1",10,174);
    myGLCD.drawCircle(20,180,15);  

  // Draw Blue threshold circle in centre of screen
    myGLCD.setColor(0, 0, 255);  
    myGLCD.drawCircle(160,120,DS1alarm); 
  // Draw Large Outer Circle
    myGLCD.drawCircle(160,120,119);   
  /* Draw Small 4 Outer Circles
    myGLCD.drawCircle(110,70,10);   
    myGLCD.drawCircle(210,70,10);  
    myGLCD.drawCircle(110,170,10);  
    myGLCD.drawCircle(210,170,10);  
  */
} else 
if (DS == 2) {
  // Draw Display 2 Button Green
    myGLCD.setColor(0, 255, 0);    
    myGLCD.setFont(SmallFont);
    myGLCD.print("DS2",10,174);
    myGLCD.drawCircle(20,180,15);  
  // DrawThreshold lines
    drawthresholds(); // Draw screen thresholds

    // Draw 4 boxes to house the oscilliscope
            myGLCD.setColor(1, 73, 240);
            myGLCD.drawRoundRect(40, 0, 159, 119);        
            myGLCD.drawRoundRect(161, 0, 280, 119);      
            myGLCD.drawRoundRect(40, 121, 159, 239);       
            myGLCD.drawRoundRect(161, 121, 280, 239); 

} else 
if (DS == 3) {
  // Draw Display 2 Button Green
    myGLCD.setColor(0, 255, 0);    
    myGLCD.setFont(SmallFont);
    myGLCD.print("DS3",10,174);
    myGLCD.drawCircle(20,180,15);  
  // DrawThreshold lines
    drawthresholds(); // Draw screen thresholds

    // Draw 4 boxes to house the oscilliscope
            myGLCD.setColor(1, 73, 240);
            myGLCD.drawRoundRect(40, 0, 159, 119);        
            myGLCD.drawRoundRect(161, 0, 280, 119);      
            myGLCD.drawRoundRect(40, 121, 159, 239);       
            myGLCD.drawRoundRect(161, 121, 280, 239); 
} else 
if (DS == 4) {
  // Draw Display 2 Button Green
    myGLCD.setColor(0, 255, 0);    
    myGLCD.setFont(SmallFont);
    myGLCD.print("DS4",10,174);
    myGLCD.drawCircle(20,180,15);  
  // DrawThreshold lines
    drawthresholds(); // Draw screen thresholds

    // Draw 4 boxes to house the oscilliscope
            myGLCD.setColor(1, 73, 240);
            myGLCD.drawRoundRect(40, 0, 159, 119);        
            myGLCD.drawRoundRect(161, 0, 280, 119);      
            myGLCD.drawRoundRect(40, 121, 159, 239);       
            myGLCD.drawRoundRect(161, 121, 280, 239); 
}        

if (LPF == true) {
  // Draw Green Low Pass Filter Button
    myGLCD.setColor(0, 255, 0);    
    myGLCD.setFont(SmallFont);
    myGLCD.print("LPF",289,9);
    myGLCD.drawCircle(299,15,15);  
    } else {
  // Draw Red Low Pass Filter Button
    myGLCD.setColor(255, 0, 0);    
    myGLCD.setFont(SmallFont);
    myGLCD.print("LPF",289,9);
    myGLCD.drawCircle(299,15,15);   
    }

  // Draw Sensitivity Button
          if (sensitivity == 2 ){  // Draw sensitivity 2X
                // Draw Sensitivity Button 
                myGLCD.setColor(0, 255, 0);    
                myGLCD.setFont(SmallFont);
                myGLCD.print("2X",292,218);
                myGLCD.drawCircle(299,224,15); 
          } else
          if (sensitivity == 4 ){  // Draw sensitivity  4X
                // Draw Sensitivity Button 
                myGLCD.setColor(0, 255, 0);    
                myGLCD.setFont(SmallFont);
                myGLCD.print("4X",292,218);
                myGLCD.drawCircle(299,224,15);
          } else
          if (sensitivity == 6 ){  // Draw sensitivity 1X
                // Draw Sensitivity Button 
                myGLCD.setColor(0, 255, 0);    
                myGLCD.setFont(SmallFont);
                myGLCD.print("6X",292,218);
                myGLCD.drawCircle(299,224,15); 
         } else
          if (sensitivity == 1 ){  // Draw sensitivity 6X
                // Draw Sensitivity Button 
                myGLCD.setColor(0, 255, 0);    
                myGLCD.setFont(SmallFont);
                myGLCD.print("1X",292,218);
                myGLCD.drawCircle(299,224,15); 
          }         

  // Draw Mute Button

if (mute == true) { // Red Button
    myGLCD.setColor(255, 0, 0);    
    myGLCD.setFont(SmallFont);
    myGLCD.print("0",10,218);
    myGLCD.drawLine(15,222,26,216);
    myGLCD.drawLine(15,225,26,231); 
    myGLCD.drawLine(26,216,26,231);      
    myGLCD.drawCircle(20,224,15);  

} else { // Green Button

    myGLCD.setColor(0, 255, 0);    
    myGLCD.setFont(SmallFont);
    myGLCD.print("0",10,218);
    myGLCD.drawLine(15,222,26,216);
    myGLCD.drawLine(15,225,26,231); 
    myGLCD.drawLine(26,216,26,231);      
    myGLCD.drawCircle(20,224,15);  
}

    // Pulse Width Button
    myGLCD.setColor(255, 255, 255); // Set colour for items in buttons
    myGLCD.setFont(BigFont);
    myGLCD.print("+", 11, 91); 
    myGLCD.print("-", 11, 135);
    myGLCD.setFont(SmallFont);
    myGLCD.print("PW",12,115);
    myGLCD.printNumI(dly1,8,70,3);   
    myGLCD.setColor(1, 73, 240); // Set colour for exterior of screen buttons
    myGLCD.drawRoundRect(1, 88, 36, 152); // PW button surround
    myGLCD.drawRoundRect(1, 62, 36, 87); // PW value surround   
 

    // Frequency Button
    myGLCD.setColor(255, 255, 255); // Set colour for items in buttons
    myGLCD.setFont(BigFont);
    myGLCD.print("+", 295, 91); 
    myGLCD.print("-", 295, 135);
    myGLCD.setFont(SmallFont);
    myGLCD.print("DLY",292,115);
    myGLCD.printNumI(dly3,292,70,3); 
    myGLCD.setColor(1, 73, 240); // Set colour for exterior of screen buttons
    myGLCD.drawRoundRect(284, 88, 319, 152); // FRQ button surround   
    myGLCD.drawRoundRect(284, 62, 319, 87); // FRQ value surround 


//    myGLCD.drawRoundRect(132, 80, 152, 100); // time hour -


  //Draw Background lines
  
}


void drawthresholds() {
  
// Draw initial alarm thresholds around box

    myGLCD.setColor(255, 255, 255);

// Coil 1 threshold line

    myGLCD.drawCircle(43, alarm1, 2); // Coil 1 LHS
    myGLCD.drawCircle(156, alarm1, 2); // Coil 1 RHS
    myGLCD.drawPixel(53, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(63, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(73, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(83, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(93, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(103, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(113, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(123, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(133, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(143, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(153, alarm1); // Coil 1 LHS

// Coil 2 threshold line

    myGLCD.drawCircle(164, alarm2, 2); // Coil 2 LHS
    myGLCD.drawCircle(276, alarm2, 2); // Coil 2 RHS
    myGLCD.drawPixel(174, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(184, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(194, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(204, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(214, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(224, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(234, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(244, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(254, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(264, alarm2); // Coil 2 LHS

// Coil 3 threshold line

    myGLCD.drawCircle(43, alarm3, 2); // Coil 1 LHS
    myGLCD.drawCircle(156, alarm3, 2); // Coil 1 RHS
    myGLCD.drawPixel(53, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(63, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(73, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(83, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(93, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(103, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(113, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(123, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(133, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(143, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(153, alarm3); // Coil 3 LHS

// Coil 4 threshold line

    myGLCD.drawCircle(164, alarm4, 2); // Coil 4 LHS
    myGLCD.drawCircle(276, alarm4, 2); // Coil 4 RHS
    myGLCD.drawPixel(174, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(184, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(194, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(204, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(214, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(224, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(234, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(244, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(254, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(264, alarm4); // Coil 4 LHS
}

void clearthresholds() {
  
// Draw initial alarm thresholds around box

    myGLCD.setColor(0, 0, 0);

// Coil 1 threshold line

    myGLCD.drawCircle(43, alarm1, 2); // Coil 1 LHS
    myGLCD.drawCircle(156, alarm1, 2); // Coil 1 RHS
    myGLCD.drawPixel(53, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(63, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(73, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(83, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(93, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(103, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(113, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(123, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(133, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(143, alarm1); // Coil 1 LHS
    myGLCD.drawPixel(153, alarm1); // Coil 1 LHS

// Coil 2 threshold line

    myGLCD.drawCircle(164, alarm2, 2); // Coil 2 LHS
    myGLCD.drawCircle(276, alarm2, 2); // Coil 2 RHS
    myGLCD.drawPixel(174, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(184, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(194, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(204, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(214, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(224, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(234, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(244, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(254, alarm2); // Coil 2 LHS
    myGLCD.drawPixel(264, alarm2); // Coil 2 LHS

// Coil 3 threshold line

    myGLCD.drawCircle(43, alarm3, 2); // Coil 1 LHS
    myGLCD.drawCircle(156, alarm3, 2); // Coil 1 RHS
    myGLCD.drawPixel(53, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(63, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(73, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(83, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(93, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(103, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(113, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(123, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(133, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(143, alarm3); // Coil 3 LHS
    myGLCD.drawPixel(153, alarm3); // Coil 3 LHS

// Coil 4 threshold line

    myGLCD.drawCircle(164, alarm4, 2); // Coil 4 LHS
    myGLCD.drawCircle(276, alarm4, 2); // Coil 4 RHS
    myGLCD.drawPixel(174, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(184, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(194, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(204, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(214, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(224, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(234, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(244, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(254, alarm4); // Coil 4 LHS
    myGLCD.drawPixel(264, alarm4); // Coil 4 LHS
}







