/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioSample;
import ddf.minim.Minim;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.JOptionPane;
import processing.core.PApplet;

public class EncodeAudio
extends PApplet {
    int SAMPLES = 30000;
    Minim minim;
    AudioSample sample;

    public void setup() {
        this.size(512, 200);
        String string = this.selectInput("Select audio file to encode.");
        if (string == null) {
            this.exit();
            return;
        }
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.minim = new Minim((PApplet)this);
            this.sample = this.minim.loadSample(string);
            float[] fArray = this.sample.getChannel(1);
            float f = 0.0f;
            int n = 0;
            while (n < fArray.length) {
                if (EncodeAudio.abs((float)fArray[n]) > f) {
                    f = fArray[n];
                }
                ++n;
            }
            n = 0;
            while (n < fArray.length) {
                if (EncodeAudio.abs((float)fArray[n]) / f > 0.01f) break;
                ++n;
            }
            String string2 = "";
            int n2 = n;
            while (n2 < fArray.length && n2 - n < this.SAMPLES) {
                string2 = String.valueOf(string2) + EncodeAudio.constrain((int)PApplet.parseInt((float)EncodeAudio.map((float)fArray[n2], (float)(-f), (float)f, (float)0.0f, (float)256.0f)), (int)0, (int)255) + ", ";
                ++n2;
            }
            clipboard.setContents(new StringSelection(string2), null);
            JOptionPane.showMessageDialog(null, "Audio data copied to the clipboard.", "Success!", 1);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Maybe you didn't pick a valid audio file?\n" + exception, "Error!", 0);
        }
        this.exit();
    }

    public void stop() {
        this.sample.close();
        this.minim.stop();
        super.stop();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "EncodeAudio"});
    }
}

