//
// Table of command codes to signal data to control
// various devices in the Entertainment Center.
//
// (c) 428 Industries, June 2013
//

//
// A table to map from actions to file names containing
// signal data. 
//

typedef struct {
    const char *action;
    const char *fileName;
} EcSymTableEntry;

EcSymTableEntry EcSymTable[] = {
    {"audioOn",           "aOn.txt"},
    {"audioOff",          "aOff.txt"},
    {"audioMute",         "aMute.txt"},
    {"audioVolumeUp",     "aVolUp.txt"},
    {"audioVolumeDown",   "aVolDown.txt"},
    {"audioAuxChannel",   "aAux.txt"},
    {"audioCDChannel",    "aCD.txt"},
    {"audioVideoChannel", "aVid.txt"},
    {"videoVolumeUp",     "vVolUp.txt"},
    {"videoVolumeDown",   "vVolDown.txt"},
    {"videoChannelUp",    "vChUp.txt"},
    {"videoChannelDown",  "vChDown.txt"},
    {"videoInput",        "vInput.txt"},
    {"videoUpKey",        "vUp.txt"},
    {"videoDownKey",      "vDown.txt"},
    {"videoLeftKey",      "vLeft.txt"},
    {"videoRightKey",     "vRight.txt"},
    {"videoSelectKey",    "vSel.txt"},
    {"videoGuide",        "vGuide.txt"},
    {"cableOnOff",        "cOnOff.txt"},
    {"appleMenu",         "Amenu.txt"},
    {"applePlay",         "Aplay.txt"},
    {"appleLeft",         "Aleft.txt"},
    {"appleRight",        "Aright.txt"},
    {"appleUp",           "Aup.txt"},
    {"appleDown",         "Adown.txt"},
    {"appleSelect",       "Asel.txt"},
    {"dvdPlay",           "bPlay.txt"},
    {"dvdPause",          "bPause.txt"},
    {"dvdPrev",           "bPrev.txt"},
    {"dvdNext",           "bNext.txt"},
    {"dvdUp",             "bUp.txt"},
    {"dvdDown",           "bDown.txt"},
    {"dvdLeft",           "bLeft.txt"},
    {"dvdRight",          "bRight.txt"},
    {"dvdSelect",         "bSel.txt"},
    {"audioSpeakersA",    "aSpA.txt"},
    {"audioSpeakersB",    "aSpB.txt"},
    {"fox",               "v2.txt"},
    {"kqedTv",            "v9.txt"},
    {"abc",               "v7.txt"},
    {"cbs",               "v5.txt"},
    {"nbc",               "v4.txt"},
    {"videoPageUp",       "vPageUp.txt"},
    {"videoPageDown",     "vPageDn.txt"},
    {"arcOn",             "arcOn.txt"},
    {"arcOff",            "arcOff.txt"},
    {"arcThrob",          "arcThrob.txt"},
    {"arcAny",            "arcAny.txt"},
    {NULL, NULL}
};
