﻿package com.Red5Link{
	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import flash.events.EventDispatcher;
	import flash.events.NetStatusEvent;
	import flash.events.SecurityErrorEvent;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	import flash.media.Camera;
	import flash.media.Microphone;
	import flash.media.Video;
	import flash.display.Sprite;
	import flash.errors.*;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import flash.text.TextField;

	public class Red5Broadcast extends Sprite {
		private var netConnection:NetConnection;
		private var netStream:NetStream;
		private var connectionUrl:String;
		private var streamUrl:String;
		private var cam:Camera;
		private var mic:Microphone;
		private var video:Video;
		private var _isconnected:Boolean;
		private var reconnectTimer:Timer;
		private var statusTextField:TextField;
		private var autoStartStream:Boolean;
		private var autoStartBroadcast:Boolean;

		public function Red5Broadcast(conUrl:String,stream:String,statusDisplay:TextField) {
			connectionUrl=conUrl;
			streamUrl=stream;
			statusTextField=statusDisplay;
			autoStartStream=false;
			autoStartBroadcast=false;
			video=new Video();
			netConnection=new NetConnection();
			netConnection.addEventListener(NetStatusEvent.NET_STATUS,netStatusHandler);
			netConnection.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorHandler);
			connectNetConnection();
			reconnectTimer=new Timer(5000);
			reconnectTimer.addEventListener("timer", timerHandler);
		}
		
		private function connectNetConnection():void{
			statusTextField.htmlText="Connecting...";
			statusTextField.textColor=0x333333;
			netConnection.connect(connectionUrl);
		}
		
		private function closeNetConnection():void{
			statusTextField.htmlText="Closed";
			statusTextField.textColor=0xCC3300;
			netConnection.close();
			isconnected=false;
		}
		
		public function set isconnected(val:Boolean):void {
			_isconnected=val;
		}

		public function get isconnected():Boolean {
			return _isconnected;
		}

		private function setupCameraAndMic():void {
			// setup cam
			cam=Camera.getCamera();
			// setting dimensions and framerate
			cam.setMode(320,240,20);
			// set to minimum of 70% quality
			cam.setQuality(300000,80);

			// setup mic
			mic=Microphone.getMicrophone(2);
			mic.setLoopBack(false);
			mic.setSilenceLevel(0);
			mic.gain=50;
			mic.rate=5;
		}

		public function broadcastStream():void {
			if (isconnected) {
				trace("broadcast");
				setupCameraAndMic();
				netStream=new NetStream(netConnection);
				netStream.attachCamera(cam);
				//netStream.attachAudio(mic);

				video.attachCamera(cam);
				addChild(video);

				// publish your cam/mic to red5 for broadcasting
				netStream.publish(streamUrl,"live");
			}else{
				autoStartBroadcast=true;
				connectNetConnection();
			}
		}

		public function playStream():void {
			if (isconnected) {
				netStream=new NetStream(netConnection);

				video.attachNetStream(netStream);
				addChild(video);

				// publish your cam/mic to red5 for broadcasting
				netStream.play(streamUrl, -1);
			}else{
				autoStartStream=true;
			}
		}

		public function stopBroadcastingStream():void {
			trace("netStream="+netStream)
			if (isconnected && netStream!=null) {
				trace("STOP STREAM")
				// close the netStream object
				netStream.attachCamera(null);
				netStream.close();
				
				// clear the videoContainer
				video.attachCamera(null);
				video.clear();
				removeChild(video);
				closeNetConnection();
			}
		}

		public function stopPlayingStream():void {
			if (isconnected) {
				// close the netStream object
				netStream.close();
				// clear the videoContainer
				video.attachNetStream(null);
				video.clear();
			}
		}

		private function netStatusHandler(event:NetStatusEvent):void {
			switch (event.info.code) {
				case "NetConnection.Connect.Success" :
					trace("NetConnection.Connect.Success");
					statusTextField.htmlText="Connected";
					statusTextField.textColor=0x009900;
					if(reconnectTimer.running){
						reconnectTimer.stop();
					}
					isconnected=true;
					if (autoStartStream) {
						playStream();
					}else if(autoStartBroadcast){
						broadcastStream();
					}					
					break;

				case "NetConnection.Connect.Closed" :
					trace("NetConnection.Connect.Closed");
					/*statusTextField.htmlText="Closed";
					statusTextField.textColor=0x333333;
					isconnected=false;*/
					break;

				case "NetConnection.Connect.Failed" :
					trace("NetConnection.Connect.Failed");
					statusTextField.htmlText="Failed";
					statusTextField.textColor=0xCC3300;
					isconnected=false;
					reconnectTimer.start();
					break;

				case "NetConnection.Connect.AppShutdown" :
					trace("NetConnection.Connect.AppShutdown");
					statusTextField.htmlText="App shutdown";
					statusTextField.textColor=0xCC3300;
					isconnected=false;
					reconnectTimer.start();
					break;

				case "NetConnection.Call.Failed" :
					trace("NetConnection.Call.Failed");
					statusTextField.htmlText="Call failed";
					statusTextField.textColor=0xCC3300;
					isconnected=false;
					reconnectTimer.start();
					break;

				case "NetConnection.Connect.InvalidApp" :
					trace("NetConnection.Connect.InvalidApp");
					statusTextField.htmlText="Invalid App";
					statusTextField.textColor=0xCC3300;
					isconnected=false;
					reconnectTimer.start();
					break;

				case "NetConnection.Connect.Rejected" :
					trace("NetConnection.Connect.Rejected");
					statusTextField.htmlText="Rejected";
					statusTextField.textColor=0xCC3300;
					isconnected=false;
					reconnectTimer.start();
					break;

			}
		}

		private function securityErrorHandler(event:SecurityErrorEvent):void {
			trace("securityErrorHandler: "+event);
		}
		
		private function timerHandler(event:TimerEvent):void {
            trace("Reconnect NetConnection.");
			connectNetConnection();		
        }
	}
}