/*
  Fridge Door Alarm Detector
  Version 02
  
  Written by Pavel Mihaylov and Tatqna Mihaylova
  11 September 2012
  
  This version is ready to be uploaded to ATtiny85 microcontroller using Arduino Uno as a programmer.
 */
 

int pwr = 1; //(Could be pin 3 on Arduino) hard pin 6 on ATtiny
int alarm = 4; //(Could be pin 4 on Arduino) hard pin 3 on ATtiny
int door  = 2; //(Could be pin 5 on Arduino) hard pin 7 on ATtiny
int LDR = 3; //(Could be pin A0 on Arduino) hard pin 2 on ATtiny
int time_door_open = (1)*1000; //Time that sets the beep alarm on after the fridge door is opened
int time = 50; //Time delay
int time_tone = 40;  //Time delay to make the beep tone
int time_tone2 = 20;  //Time delay to make the beep tone
float trig = 2.5; //Trigger level for the LDR
float LDRval = 0; //Initial value of the LDR measurement level
int door_left = 0; //Variable to set whether the door is left opened (1) or closed (0)
extern volatile unsigned long timer0_overflow_count; //This is required to know when a rollover occurs

void setup() {                
  pinMode(pwr, OUTPUT);
  pinMode(alarm, OUTPUT);
  pinMode(door, OUTPUT);  
  pinMode(LDR, INPUT);       
}
  
  //Main program loop
  
void loop() {
  
  if(read_light())
  {
    
    door_left = 1;
    
    timer0_overflow_count = 0;
    unsigned long start = millis(); // This is the time countdown when the door is opened
    while( (millis() - start) <= time_door_open )
    {
      if(millis() - start < 0) //break while loop if rollover occures
      {
        break;
      }

      if(read_light() == 0) // If door is closed the program does nothing and starts again
      {
        door_left = 0;
        break;
      }
      delay(time); //delay needed
      
    }
    
    if(door_left == 1) // If door is opened start the beep sound!
      {        
        alarm_sound();
      }    
  }
    

  delay(time);
  delay(time);
  delay(time);
  
}



//Function to read the light sensor (LDR) and return either 0 (door is closed) or 1 (door is opened)

int read_light()
{
  digitalWrite(pwr, HIGH);    // turn the pwr pin on by making the voltage high to allow a measurement to be taken
  
  delay(10);               // wait for some time
  
  LDRval = analogRead(LDR); // read the sensor value

  delay(5); // wait some time
  
  digitalWrite(pwr, LOW);    // turn the pwr pin off by making the voltage low
  
  
  LDRval = LDRval/1024*5; // sensor value is in the range 0 to 1023 and we need it between 0 and 5 - this is the calculation required
  
  if(LDRval<trig) // This compares the reading to the trigger level
  {
    digitalWrite(door, HIGH); // Turn the external LED ON to show that the door is opened
    return 1; // Means door is opened
  }
  else
  {
    digitalWrite(door, LOW); // Turn the external LED OFF to show that the door is closed
    return 0; // Means door is closed
  }

}


/*
   Loop to make the beep sounds
   First makes three 3-beep sounds
   Then makes 4-beep spunds for ever if the door remains opened
*/


void alarm_sound()
{
  int looop1=0;
  int sound_loop1_skip = 0;
  while(read_light() && looop1<3 && sound_loop1_skip == 0) // This makes the loop beep 3 times a 3-beep tone
  {
    
  
    
    int i;
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone);
    delay(time_tone2);
    
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    


    looop1++;
    read_light();
    delay(290);


  }
  
  
  //second beep loop now begins
  
  looop1 = 0;
  while(read_light())
  {
    delay(300);
      
    int i;
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone);
    delay(time_tone);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on 
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    

    delay(270);

  }
  
  //now go on beeping if door is still opened
  if(read_light())
  {
    sound_loop1_skip = 1; // This will make the program skip the 3-beep sound and continue the 4-beep sound
    delay(2000);             
    alarm_sound();
  }
  else
  {
    sound_loop1_skip = 0;
  } 
}
