/*
  Fridge Door Alarm Detector
  Version 03
  
  Written by Pavel Mihaylov and Tatqna Mihaylova
  09 October 2012
  
  This version is ready to be uploaded to ATtiny85 microcontroller using Arduino Uno as a programmer.
  For full instructions see: http://www.instructables.com/id/Fridge-Door-Detector-Alarm/
 */

// Following lines are essential to enable sleep mode
#include <avr/sleep.h>
#include <avr/wdt.h>

#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif
volatile boolean f_wdt = 1;


int pwr = 1; //(Could be pin 3 on Arduino) hard pin 6 on ATtiny
int alarm = 4; //(Could be pin 4 on Arduino) hard pin 3 on ATtiny
int door  = 2; //(Could be pin 5 on Arduino) hard pin 7 on ATtiny
int LDR = 3; //(Could be pin A0 on Arduino) hard pin 2 on ATtiny
int time_door_open = (3)*300; //Time that sets the beep alarm on after the fridge door is opened
int time = 50; //Time delay
int time_tone = 40;  //Time delay to make the beep tone
int time_tone2 = 20;  //Time delay to make the beep tone
float trig = 3.5; //Trigger level for the LDR
float LDRval = 0; //Initial value of the LDR measurement level
int door_left = 0; //Variable to set whether the door is left opened (1) or closed (0)
extern volatile unsigned long timer0_overflow_count; //This is required to know when a rollover occurs

//Pins setup
void setup() {                
  pinMode(pwr, OUTPUT);
  pinMode(alarm, OUTPUT);
  pinMode(door, OUTPUT);  
  pinMode(LDR, INPUT); 
  setup_watchdog(8); // approximately 4 seconds sleep
  // 0=16ms, 1=32ms,2=64ms,3=128ms,4=250ms,5=500ms 6=1 sec,7=2 sec, 8=4 sec, 9= 8sec
}
  
  //Main program loop
void loop() {
  //
  if (f_wdt==1) {  // wait for timed out watchdog / flag is set when a watchdog timeout occurs
    f_wdt=0;       // reset flag
    //
    
    if(read_light()) //In case the door is opened this statement will be true
    {
    
      door_left = 1;
    
      timer0_overflow_count = 0;
      unsigned long start = millis(); // This is the time countdown when the door is opened
      while( (millis() - start) <= time_door_open )
      {
        if(millis() - start < 0) break; //break while loop if rollover occures

        if(read_light() == 0) // If door is closed the program does nothing and starts again
        {
          door_left = 0;
          break;
        }
        delay(time); //delay needed
      }
    
      if(door_left == 1) alarm_sound(); // If door is opened start the beep sound!
       
    }     
      //Now put the system to sleep
      system_sleep();
  }
}



//Function to read the light sensor (LDR) and return either 0 (door is closed) or 1 (door is opened)

int read_light()
{
  digitalWrite(pwr, HIGH);    // turn the pwr pin on by making the voltage high to allow a measurement to be taken
  
  LDRval = analogRead(LDR); // read the sensor value

  digitalWrite(pwr, LOW);    // turn the pwr pin off by making the voltage low  
  
  LDRval = LDRval/1024*5; // sensor value is in the range 0 to 1023 and we need it between 0 and 5 - this is the calculation required
  
  if(LDRval<trig) // This compares the reading to the trigger level
  {
    digitalWrite(door, HIGH); // Turn the external LED ON to show that the door is opened
    return 1; // Means door is opened
  }
  else
  {
    digitalWrite(door, LOW); // Turn the external LED OFF to show that the door is closed
    return 0; // Means door is closed
  }
}


/*
   Loop to make the beep sounds
   First makes three 3-beep sounds
   Then makes 4-beep spunds for ever if the door remains opened
*/

void alarm_sound()
{
  int looop_1_count=0;
  int sound_loop1_skip = 0;
  while(read_light() && looop_1_count<3 && sound_loop1_skip == 0) // This makes the loop beep 3 times a 3-beep tone
  {
      
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone);
    delay(time_tone2);
    
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    looop_1_count++;
    read_light();
    delay(290);
  }
   
  //second beep loop now begins
  
  looop_1_count = 0;
  while(read_light())
  {
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone);
    delay(time_tone);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on 
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    digitalWrite(alarm, HIGH); //make beep sound on
    delay(time_tone2);
    digitalWrite(alarm, LOW); //make beep sound stop
    delay(time_tone2);
    
    delay(570);

  }
  
  //now go on beeping if door is still opened
  if(read_light())
  {
    sound_loop1_skip = 1; // This will make the program skip the 3-beep sound and continue the 4-beep sound
    delay(2000);             
    if(read_light()) alarm_sound();
  }
  else sound_loop1_skip = 0;
}


// set system into the sleep state 
// system wakes up when wtchdog is timed out
void system_sleep() {
  cbi(ADCSRA,ADEN);                    // switch Analog to Digitalconverter OFF

  set_sleep_mode(SLEEP_MODE_PWR_DOWN); // sleep mode is set here
  sleep_enable();

  sleep_mode();                        // System sleeps here

  sleep_disable();                     // System continues execution here when watchdog timed out 
  sbi(ADCSRA,ADEN);                    // switch Analog to Digitalconverter ON
}

// 0=16ms, 1=32ms,2=64ms,3=128ms,4=250ms,5=500ms
// 6=1 sec,7=2 sec, 8=4 sec, 9= 8sec
void setup_watchdog(int ii) {

  byte bb;
  int ww;
  if (ii > 9 ) ii=9;
  bb=ii & 7;
  if (ii > 7) bb|= (1<<5);
  bb|= (1<<WDCE);
  ww=bb;

  MCUSR &= ~(1<<WDRF);
  // start timed sequence
  WDTCR |= (1<<WDCE) | (1<<WDE);
  // set new watchdog timeout value
  WDTCR = bb;
  WDTCR |= _BV(WDIE);

}
  
// Watchdog Interrupt Service / is executed when watchdog timed out
ISR(WDT_vect) {
  f_wdt=1;  // set global flag
}

