'' *****************************
'' GPS routines
''  (c) 2007 Perry James Mole
''  pjm@ridge-communications.ca
'' *****************************

' PVH Comment - Excellent small GPS reader routines.
' $GPRMC  Recommended minimum data                 ie: $GPRMC,081836,A,3751.6565,S,14507.3654,E,000.0,360.0,130998,011.3,E*62
' $GPGGA  GPS Fix Data                             ie: $GPGGA,170834,4124.8963,N,08151.6838,W,1,05,1.5,280.2,M,-34.0,M,,,*75
' $PGRMZ  eTrex proprietary barametric altitude ft ie: $PGRMZ,453,f,2*18

' modified for use of 2 Serial-GPS

CON

  CR = 13                                               ' ASCII <CR>
  LF = 10                                               ' ASCII <LF>
  
  
VAR  
   long gps_stack[30] 
   byte GPRMCb[68],GPGGAb[80]',PGRMZb[40]   
   long GPRMCa[20],GPGGAa[20]',PGRMZa[20]   


   byte gps_buff[80],Rx',cksum
   long cog,cptr,ptr,arg,j
   long Null[1]

 '  -----  gps2 -------

  
   byte GPRMCb2[68],GPGGAb2[80]',PGRMZb2[40]   
   long GPRMCa2[20],GPGGAa2[20]',PGRMZa2[20]   


   byte gps_buff2[80],Rx2
   long cptr2,ptr2,arg2,j2
   long Null2[1]


   
   
OBJ
  uart :  "FullDuplexSerial_mini"
  uart2 : "FullDuplexSerial_mini" 
PUB start(Receive,Transmit,R,T) : okay

'' Starts uart object (at baud specified) in a cog
'' -- returns false if no cog available

  okay := uart.start(Receive,Transmit,0,9600)
   uart2.start(R,T,0,9600)
  return cog := cognew(readNEMAS,@gps_stack) + 1
PUB readNEMAS
repeat


   repeat 4
   
    readNEMA1

   repeat 4
    readNEMA2
PUB readNEMA1
  Null[0] := 0
  
   longfill(gps_buff,20,0)
   repeat while Rx <>= "$"      ' wait for the $ to insure we are starting with
     Rx := uart.rx              '   a complete NMEA sentence 
   cptr := 0

   repeat while Rx <>= CR       '  continue to collect data until the end of the NMEA sentence 
     Rx := uart.rx              '  get character from Rx Buffer
     if Rx == ","   
       gps_buff[cptr++] := 0    '  If "," replace the character with 0   

     


     else 

      
       gps_buff[cptr++] := Rx   '  else save the character   
    if  Rx == "."      
     cptr--
   
   if gps_buff[2] == "G"             
     if gps_buff[3] == "G"            
       if gps_buff[4] == "A"            
           copy_buffer(@GPGGAb, @GPGGAa)

   if gps_buff[2] == "R"             
     if gps_buff[3] == "M"            
       if gps_buff[4] == "C"           
           copy_buffer(@GPRMCb, @GPRMCa)

 'waitcnt(clkfreq / 200 + cnt)
                   
 {  if gps_buff[0] == "P"
    if gps_buff[1] == "G"  
     if gps_buff[2] == "R"
      if gps_buff[3] == "M"  
       if gps_buff[4] == "Z"
           copy_buffer(@PGRMZb, @PGRMZa)
  }



           
pub copy_buffer ( buffer,args)
         bytemove(buffer,@gps_buff,cptr) '  copy received data to buffer
         ptr := buffer
         arg := 0
         repeat j from 0 to 78           ' build array of pointers
          if byte[ptr] == 0               ' to each
             if byte[ptr+1] == 0           ' record
                long[args][arg] := Null     ' in 
             else                            ' the
                long[args][arg] := ptr+1     ' data buffer
             arg++
          ptr++
          
' now we just need to return the pointer to the desired record
          




pub time
   return GPGGAa[0]

pub seconds | s

 s := 10 * BYTE[GPGGAa[0] + 4] + BYTE[GPGGAa[0] + 5] - $210 
 
 return s
pub latitude
   return GPGGAa[1]

pub latitude_deg| c, s , z
 

IF STRSIZE(GPGGAa[1])           'Not a null string
  s~
  REPEAT z from 0 to 1
      c := BYTE[GPGGAa[1]+z]
    IF c == "-"
      s := -1
    ElSE      
      RESULT := RESULT * 10 + c - $30
  IF s
    RESULT := -1 * RESULT     
ELSE
  RESULT := 0         'To signal invalid value since -1 can be a
                             'valid result in some proprietary sentence
'-------------------------------------------------------------------------
pub latitude_min| c, s , z

IF STRSIZE(GPGGAa[1])           'Not a null string
  s~
  REPEAT z from 2 to 7
      c := BYTE[GPGGAa[1]+z]
    IF c == "-"
      s := -1
    ElSE      
      RESULT := RESULT * 10 + c - $30
  IF s
    RESULT := -1 * RESULT     
ELSE
  RESULT := 0         'To signal invalid value since -1 can be a
                             'valid result in some proprietary sentence

 

pub longitude_deg| c, s , z
 

IF STRSIZE(GPGGAa[3])           'Not a null string
  s~
  REPEAT z from 0 to 2
      c := BYTE[GPGGAa[3]+z]
    IF c == "-"
      s := -1
    ElSE      
      RESULT := RESULT * 10 + c - $30
  IF s
    RESULT := -1 * RESULT     
ELSE
  RESULT := 0         'To signal invalid value since -1 can be a
                             'valid result in some 
'-------------------------------------------------------------------------
pub longitude_min| c, s , z

IF STRSIZE(GPGGAa[3])           'Not a null string
  s~
  REPEAT z from 3 to 8
      c := BYTE[GPGGAa[3]+z]
    IF c == "-"
      s := -1
    ElSE      
      RESULT := RESULT * 10 + c - $30
  IF s
    RESULT := -1 * RESULT     
ELSE
  RESULT := 0         'To signal invalid value since -1 can be a
                             'valid result in some proprietary sentence

 

pub longitude_dec  |  c

 result:= (longitude_deg*10000000)  + (longitude_min*50/3)

 

pub latitude_dec
 result :=  (latitude_deg*10000000)   + (latitude_min*50/3)
                             
pub N_S
   return GPGGAa[2]
     
pub longitude
   return GPGGAa[3]
    
pub E_W
   return GPGGAa[4]

pub satellites_dec  | s ,z,c  

 IF STRSIZE(GPGGAa[6]) == 1

   result:=  BYTE[GPGGAa[6]]  - $30

if STRSIZE(GPGGAa[6]) == 2
    result:= 10 * BYTE[GPGGAa[6] ] + BYTE[GPGGAa[6] + 1] - $210     

IF STRSIZE(GPGGAa[6]) == 0
  result := 0

pub satellites
   return GPGGAa[6]



pub satellites2
   return GPGGAa2[6]                 








PUB readNEMA2
  Null2[0] := 0
  
   longfill(gps_buff2,20,0)
   repeat while Rx2 <>= "$"      ' wait for the $ to insure we are starting with
     Rx2 := uart2.rx              '   a complete NMEA sentence 
   cptr2 := 0

   repeat while Rx2 <>= CR       '  continue to collect data until the end of the NMEA sentence 
     Rx2 := uart2.rx              '  get character from Rx Buffer
     if Rx2 == ","   
       gps_buff2[cptr2++] := 0    '  If "," replace the character with 0   

     


     else 

      
       gps_buff2[cptr2++] := Rx2   '  else save the character   
    if  Rx2 == "."      
     cptr2--
     
   
   if gps_buff2[2] == "G"             
    if gps_buff2[3] == "G"            
      if gps_buff2[4] == "A"            
          copy_buffer2(@GPGGAb2, @GPGGAa2)
           
   if gps_buff2[2] == "R"             
    if gps_buff2[3] == "M"            
     if gps_buff2[4] == "C"           
           copy_buffer2(@GPRMCb2, @GPRMCa2)
                   
{   if gps_buff2[2] == "R"
     if gps_buff2[3] == "M"  
       if gps_buff2[4] == "Z"
           copy_buffer2(@PGRMZb2, @PGRMZa2)
 }               
pub copy_buffer2 ( buffer2,args2)
         bytemove(buffer2,@gps_buff2,cptr2) '  copy received data to buffer
         ptr2 := buffer2
         arg2 := 0
         repeat j2 from 0 to 78           ' build array of pointers
          if byte[ptr2] == 0               ' to each
             if byte[ptr2+1] == 0           ' record
                long[args2][arg2] := Null2     ' in 
             else                            ' the
                long[args2][arg2] := ptr2+1     ' data buffer
             arg2++
          ptr2++
          
' now we just need to return the pointer to the desired record
          




pub time2
   return GPGGAa2[0]

pub seconds2 | s

 s := 10 * BYTE[GPGGAa2[0] + 4] + BYTE[GPGGAa2[0] + 5] - $210 
 
 return s
pub latitude2
   return GPGGAa2[1]

pub latitude_deg2| c, s , z
 

IF STRSIZE(GPGGAa2[1])           'Not a null string
  s~
  REPEAT z from 0 to 1
      c := BYTE[GPGGAa2[1]+z]
    IF c == "-"
      s := -1
    ElSE      
      RESULT := RESULT * 10 + c - $30
  IF s
    RESULT := -1 * RESULT     
ELSE
  RESULT := 0         'To signal invalid value since -1 can be a
                             'valid result in some proprietary sentence
'-------------------------------------------------------------------------
pub latitude_min2| c, s , z

IF STRSIZE(GPGGAa2[1])           'Not a null string
  s~
  REPEAT z from 2 to 7
      c := BYTE[GPGGAa2[1]+z]
    IF c == "-"
      s := -1
    ElSE      
      RESULT := RESULT * 10 + c - $30
  IF s
    RESULT := -1 * RESULT     
ELSE
  RESULT := 0         'To signal invalid value since -1 can be a
                             'valid result in some proprietary sentence

 

pub longitude_deg2| c, s , z
 

IF STRSIZE(GPGGAa2[3])           'Not a null string
  s~
  REPEAT z from 0 to 2
      c := BYTE[GPGGAa2[3]+z]
    IF c == "-"
      s := -1
    ElSE      
      RESULT := RESULT * 10 + c - $30
  IF s
    RESULT := -1 * RESULT     
ELSE
  RESULT := 0         'To signal invalid value since -1 can be a
                             'valid result in some 
'-------------------------------------------------------------------------
pub longitude_min2| c, s , z

IF STRSIZE(GPGGAa2[3])           'Not a null string
  s~
  REPEAT z from 3 to 8
      c := BYTE[GPGGAa2[3]+z]
    IF c == "-"
      s := -1
    ElSE      
      RESULT := RESULT * 10 + c - $30
  IF s
    RESULT := -1 * RESULT     
ELSE
  RESULT := 0         'To signal invalid value since -1 can be a
                             'valid result in some proprietary sentence

 

pub longitude_dec2

 result :=  (longitude_deg2*10000000)  + (longitude_min2*50/3)

pub latitude_dec2
 result :=  (latitude_deg2*10000000)   + (latitude_min2*50/3)
                             
pub N_S2
   return GPGGAa2[2]
     
pub longitude2
   return GPGGAa2[3]
    
pub E_W2
   return GPGGAa2[4]

pub satellites_dec2

IF STRSIZE(GPGGAa2[6]) == 1

   result:=  BYTE[GPGGAa2[6]]  - $30

if STRSIZE(GPGGAa2[6]) == 2
    result:= 10 * BYTE[GPGGAa2[6] ] + BYTE[GPGGAa2[6] + 1] - $210     

IF STRSIZE(GPGGAa2[6]) == 0
  result := 0
