//////////////////////////////////////////////////////////////////////////
//
//	AP Digital light 
// 
//	PIC18F2320 based hard drive clock controller
//	CLK 40MHz, one cycle - 1uSec
//	ver 1.0	04/2009
//
//	
//	
//
//////////////////////////////////////////////////////////////////////////



#include "HD_clock.h"
#include "LCD.C"
#include "DS1307.C"

void lcd_msg1(void);
void read_RTC(void);

void show_white(void);
void show_red(void);
void show_green(void);
void show_blue(void);
void show_cyan(void);
void show_yellow(void);
void show_magenta(void);
void show_nothing(void);

void ec_f1(int);	//spinning 8 colors pattern
void ec_f1_1(int);	//still 8 color pattern
void ec_f2(void);	//interchanging spinning colors
void ec_f2_1(void);
void ec_f2_2(void);
void ec_f2_3(void);
void ec_f3(int,int);
void ec_ff(int, long, long);

// A4 - open drain output!!!

#define LED1_pin 	PIN_C2
#define LED2_pin 	PIN_C5

#define PB1_pin 	PIN_B1		//Low level is active
#define PB2_pin 	PIN_B2

#define red_pin		PIN_B4
#define green_pin	PIN_B3
#define blue_pin	PIN_B5

#define sec_pin		blue_pin
#define min_pin		green_pin
#define hour_pin	red_pin


//timer1 control register
#BYTE T1CON = 0xFCD

long dr_time = 0;	//time of full revolution
long tick_time = 0;	//duration of one sec (1/60 of dr_time)
long tick_time1 = 0;
long LED_delay =0;	//duration of LED being ON
long ec_tick = 0;	//
	
long pos_sec = 0;		//position of sec hand
long pos_sec1 =0;
long pos_min = 0;		//position of min hand
long pos_min1 =0;
long pos_hour = 0;		//position of min hand
long pos_hour1 =0;

long current_pos = 0;	//current position of disc



//RTC data
BYTE sec = 0; 
BYTE min = 0; 
BYTE hour = 0; 
BYTE day = 0; 
BYTE month = 0; 
BYTE year = 0; 
BYTE dow = 0; 

//max_day of month
const BYTE  max_day[] = {32,30,32,31,32,31,32,32,31,32,31,32};

const char dow_str[7][5] = {
	{"MON "},
	{"TUE "},
	{"WEN "},
	{"THU "},
	{"FRI "},
	{"SAT "},
	{"SUN "}};

const char month_str[12][4] = {
	{"JAN"},
	{"FEB"},
	{"MAR"},
	{"APR"},
	{"MAY"},
	{"JUN"},
	{"JUL"},
	{"AUG"},
	{"SEP"},
	{"OCT"},
	{"NOV"},
	{"DEC"}};


int part_sec = 0;		//amount of fraction of second (4*part_sec = sec)

int1 tmr0_ovf = 1;		//timer 0 overflow
int1 f_read_rtc = 0;	//request data from RTC
int1 f_write_rtc = 0;	//write data to RTC 
int1 f_write_lcd = 0;	//output on LCD
int1 f_ec_step = 0;
int1 f_demo_mode = 0;	//demo mode is active	
int1 f_demo_pause = 0;	
int1 PB1s = 0;			//PB1 1 - pressed, 0 - released
int1 PB2s = 0;			//PB2


int ad = 0;					//ad 
int state = 0;				//state indicator
int eye_candy = 0;
int ec_counter = 0;

int i = 0;

//muasures time of disk revolution
#int_TIMER0
TIMER0_isr() 
{
//	output_toggle(test_pin2);
//	tmr0_ovf = 1;

}

//real time clock
//period of interrupt - 0.25 sec
#int_TIMER1
TIMER1_isr() 
{
//output_high(test_pin2);


	set_timer1(0xe000);		//period of interrupt - 0.25 sec

	if(!input(PB1_pin))
	{
		PB1s = 1; 
		output_high(LED1_pin);
	}
	else
	{
		PB1s = 0; 
		output_low(LED1_pin);
	}

	if(!input(PB2_pin))
	{
		PB2s = 1; 
		output_high(LED2_pin);
	}
	else
	{
		PB2s = 0; 
		output_low(LED2_pin);
	}



	part_sec++;
	if(part_sec==4) {

		ec_counter++;
		part_sec = 0;
		sec++;

		tick_time = dr_time/60;
		tick_time1 = dr_time/12;

		pos_sec = dr_time - tick_time*sec - LED_delay;
		pos_sec1 = pos_sec + LED_delay;
		pos_min = dr_time - tick_time*min - LED_delay ;
		pos_min1 = pos_min + LED_delay;

		if(hour>=12) {
			pos_hour = dr_time - tick_time1*(hour-12) - tick_time1/60*min;
		}
		else {
			pos_hour = dr_time - tick_time1*hour - tick_time1/60*min;
		}
		pos_hour1 = pos_hour + LED_delay;

		if(sec == 60) {
			sec=0;
			pos_sec = 0;
			pos_sec1 = LED_delay;	  
			min++;
			if(min == 60) {
				min=0;
				pos_min = 0;
				pos_min1 = LED_delay;	  
				f_read_rtc = 1;		//request data from RTC
			}
		}
		f_write_lcd = 1;
	}

	switch (state) {
		case 0:	if (!input(PB1_pin)) 
				{
					state = 1; 
				}
				if (!input(PB2_pin)) 
				{
					state = 50; 	//enter DEMO mode
					f_demo_mode = 1;
				}
				break;		


		case 1: if (input(PB1_pin)) state = 2; break;		//sec
		case 2: if (!input(PB1_pin)) state = 3;
				else 
					if (!input(PB2_pin)) {
						sec=0;
						f_write_lcd = 1;
						f_write_rtc = 1;
					}
		break;
		case 3: if (input(PB1_pin)) state = 4; break;		//min
		case 4: if (!input(PB1_pin)) state = 5;	
				else
					if(!input(PB2_pin)) {
						min++;
						if(min>=60) min=0;
						f_write_lcd = 1;
						f_write_rtc = 1;
					}
		break;
		case 5: if (input(PB1_pin)) state = 6; break;		//hrs
		case 6: if (!input(PB1_pin)) state = 7; 
				else
					if(!input(PB2_pin)) {
						hour++;
						if(hour>=24) hour=0;
						f_write_lcd = 1;
						f_write_rtc = 1;
					}
		break;
		case 7: if (input(PB1_pin)) state = 8; break;		//day
		case 8: if (!input(PB1_pin)) state = 9; 
				else
					if(!input(PB2_pin)) {
						day++;
						if(day>=max_day[month-1]) day=1;
						f_write_lcd = 1;
						f_write_rtc = 1;
					}
		break;
		case 9: if (input(PB1_pin)) state = 10; break;		//month
		case 10: if (!input(PB1_pin)) state = 11; 
				else
					if(!input(PB2_pin)) {
						month++;
						if(month>=13) month=1;
						f_write_lcd = 1;
						f_write_rtc = 1;
					}
		break;
		case 11: if (input(PB1_pin)) state = 12; break;	//year
		case 12: if (!input(PB1_pin)) state = 13; 
				else
					if(!input(PB2_pin)) {
						year++;
						if(year>=100) year=0;
						f_write_lcd = 1;
						f_write_rtc = 1;
					}
		break;
		case 13: if (input(PB1_pin)) state = 14; break;	//day of weak
		case 14: if (!input(PB1_pin)) state = 15; 
				else
					if(!input(PB2_pin)) {
						dow++;
						if(dow>=8) dow=1;
						f_write_lcd = 1;
						f_write_rtc = 1;
					}
		break;	//
		case 15: if (input(PB1_pin)) state = 0; break;

		case 50: if(input(PB2_pin)) state = 51; break;

		case 51: if (!input(PB1_pin)) state = 52; break;
		case 52: if (input(PB1_pin)) state = 53; break;	//

		case 53: if (!input(PB1_pin)) state = 54; break;
		case 54: if (input(PB1_pin)) state = 55; break;	//

		case 55: if (!input(PB1_pin)) state = 56; break;
		case 56: if (input(PB1_pin)) state = 57; break;	//

		case 57: if (!input(PB1_pin)) state = 58; break;
		case 58: if (input(PB1_pin)) state = 59; break;	//

		case 59: if (!input(PB1_pin)) state = 60; break;
		case 60: if (input(PB1_pin)) state = 61; break;	//

		case 61: if (!input(PB1_pin)) state = 62; break;
		case 62: if (input(PB1_pin))
				{ 
					state = 0; 
					f_demo_mode = 0;
				}
				break;	//
	}
}

#int_TIMER2 
TIMER2_isr() 
{

}

#int_TIMER3
TIMER3_isr() 
{

}

//full revolution takes 13.64 msec
#int_EXT HIGH
EXT_isr() 
{
//output_high(test_pin2);
// 	output_toggle(test_pin);

	dr_time = get_timer0(); 
	set_timer0(0);
	f_ec_step=1;

}

#int_SSP
SSP_isr() 
{

}



//#define LCD_TYPE 1
void main()
{
   setup_oscillator(False);

   setup_adc_ports(NO_ANALOGS|VSS_VDD);
   setup_adc(ADC_OFF|ADC_TAD_MUL_0);
   setup_wdt(WDT_OFF);
	//set up external interrupt
	EXT_INT_EDGE(L_TO_H);
   	//muasures time of disk revolution
	//increment .4uS
	setup_timer_0(RTCC_INTERNAL|RTCC_DIV_4);
	//LED ON delay 
//	LED_delay = 100; //40uS
	LED_delay = 200; //80uS

//   setup_timer_1(T1_INTERNAL|T1_DIV_BY_1);

	//real time clock
	//external clock source - crystal 32768Hz  
	setup_timer_1(T1_EXTERNAL|T1_DIV_BY_1);
	set_timer1(0xe000);		//period of interrupt - 0.25 sec
	bit_set(T1CON,3);	//start oscillator

	setup_timer_2(T2_DIV_BY_1,255,1);


//period 230 uSec (1/60 of full rev)
//	setup_timer_2(T2_DIV_BY_16,142,1);

   setup_timer_3(T3_DISABLED|T3_DIV_BY_1);
   setup_comparator(NC_NC_NC_NC);
   setup_vref(FALSE);
	enable_interrupts(INT_TIMER0);
	enable_interrupts(INT_TIMER1);
//	enable_interrupts(INT_TIMER2);
	//enable_interrupts(INT_TIMER3);
	enable_interrupts(INT_EXT);
	//enable_interrupts(INT_SSP);
   enable_interrupts(GLOBAL);

	output_low(LED1_pin);		
	output_low(LED2_pin);	

	lcd_init();

	ds1307_init(); 
	read_RTC();

 // TODO: USER CODE!!
	

	while(true)
	{
		if(f_read_rtc)
		{
			f_read_rtc = 0;	
			read_RTC();
		}
		if(f_write_rtc) {
			f_write_rtc = 0;
			ds1307_set_date_time(day,month,year,dow,hour,min,sec);	
		}

		//get current position of disk
		current_pos=get_timer0();
		//show second's hand
		if(current_pos>=pos_sec && current_pos<=pos_sec1)
		{
			output_high(sec_pin);
		}
		else output_low(sec_pin);
		
		//show minute's hand
		if(current_pos>=pos_min && current_pos<=pos_min1)
		{
			output_high(min_pin);
		}
		else output_low(min_pin);

		//show hour's hand
		if(current_pos>=pos_hour && current_pos<=pos_hour1)
		{
			output_high(hour_pin);
		}
		else output_low(hour_pin);
		
		if(f_demo_mode)
		{
			switch(state) {
				case 51: ec_f1_1(5); break;
				case 53: ec_f2(); break;
				case 55: ec_f2_3(); break;
				case 57: ec_f2_1(); break;
				case 59: ec_f2_2(); break;
				case 61: ec_f1(5); break;
			}
		}

		if(f_write_lcd)
		{
			f_write_lcd = 0;
			//write routine takes 4mS!!!		
			output_low(sec_pin);
			output_low(min_pin);
			output_low(hour_pin);			

			if(!state)
			{
			    printf(lcd_putc,"\f    %02u:%02u:%02u\n",hour,min,sec);
				ad++; 
				if(ad==10) {
					ad = 0;
					lcd_putc("AP Digital light");	
				}
				else 
				{
					lcd_putc(dow_str[dow-1]);
					lcd_putc(month_str[month-1]);
			    	printf(lcd_putc,"-%02u-20%02u",day,year);
					
				}
			}
			else 
			{
				if(state>50)
				{ 
				    printf(lcd_putc,"\fDEMO %u\n", state);
				}
				else {

				switch (state){
				case 2: 
					printf(lcd_putc,"\f%02u seconds",sec);
					lcd_putc("\nSET to reset");
				break;
				case 4:
					printf(lcd_putc,"\f%02u minutes",min);
					lcd_msg1();
				break;
				case 6:
					printf(lcd_putc,"\f%02u hours",hour);
					lcd_msg1();
				break;
				case 8:
					printf(lcd_putc,"\f%02u of ",day);
					lcd_putc(month_str[month-1]);	
					lcd_msg1();
				break;
				case 10:
					lcd_putc("\fMonth is ");
					lcd_putc(month_str[month-1]);	
					lcd_msg1();
				break;
				case 12:
					printf(lcd_putc,"\fNow is 20%02u",year);
					lcd_msg1();
				break;
				case 14:
					lcd_putc("\fDay is ");
					lcd_putc(dow_str[dow-1]);
					lcd_msg1();
				break;
				default:  
				}					
				}	
			}
		}
	}
}

void lcd_msg1()
{
	lcd_putc("\nSET to change");
}

void read_RTC()
{
	ds1307_get_time(hour,min,sec); 
	ds1307_get_date(day,month,year,dow);	
}


void show_white()
{
	output_high(red_pin);
	output_high(green_pin);
	output_high(blue_pin);
}

void show_red()
{
	output_high(red_pin);
	output_low(green_pin);
	output_low(blue_pin);
}

void show_green()
{
	output_low(red_pin);
	output_high(green_pin);
	output_low(blue_pin);
}

void show_blue()
{
	output_low(red_pin);
	output_low(green_pin);
	output_high(blue_pin);
}

void show_cyan()
{
	output_high(red_pin);
	output_low(green_pin);
	output_high(blue_pin);
}

void show_yellow()
{
	output_high(red_pin);
	output_high(green_pin);
	output_low(blue_pin);
}

void show_magenta()
{
	output_low(red_pin);
	output_high(green_pin);
	output_high(blue_pin);
}

void show_nothing()
{
	output_low(red_pin);
	output_low(green_pin);
	output_low(blue_pin);
}


//test pattern, still 8 colors
//
//=========== DEMO mode, state=51
//
void ec_f1_1(int duration)
{
	long tt = 0;
	int ind_t = 0;
	ec_counter = 0;
	tt =  dr_time/8;

//	while(ec_counter<duration)
	while(state == 51)

	{
		for(ind_t=0;ind_t<8;ind_t++)
		{
			ec_ff(ind_t+1,ind_t*tt,(ind_t+1)*tt);
		}
	}
}

//----------------------------------------------------------------------
//----------------------------------------------------------------------
//----------------------------------------------------------------------
//test pattern, spinning 8 colors
//
//=========== DEMO mode, state=61
//

void ec_f1(int duration)
{
	long start = 0;		//current start position
	long cur_c_pos = 0;	//current position
	long ss = 0;		//size of segment 
	long h_limit = 0;
	long l_limit = 0;
	int ind_c = 0;		//color's index 

	ec_counter = 0;
	ss =  dr_time/8;

	h_limit = dr_time + ss;
	l_limit = dr_time - ss;
	
	start = 0;
	
//	while(ec_counter<duration)
	while(state == 61)
	{
		if(f_ec_step)
		{
			f_ec_step=0;
			start+=100;
			if(start>=dr_time)
			{
				start = 0;
			}
		}

		for(ind_c=0;ind_c<8;ind_c++)
		{
			cur_c_pos = ind_c*ss+start;	//current position

			if(cur_c_pos>dr_time)
			{
				ec_ff(ind_c+1,cur_c_pos-dr_time,cur_c_pos-l_limit);
			}		
			else
			{
				if(cur_c_pos>l_limit)
				{
					ec_ff(ind_c+1,0,cur_c_pos-l_limit);
					ec_ff(ind_c+1,cur_c_pos,dr_time);
				}
				else
				{
					ec_ff(ind_c+1,cur_c_pos,cur_c_pos+ss);
				}
			}
		}
	}
}




void ec_ff(int color, long start_time, long end_time)
{
	current_pos=get_timer0();
	if(current_pos>=start_time && current_pos<=end_time)
	{
		switch(color)
		{
			case 1:	show_green(); break;
			case 2: show_red(); break;
			case 3: show_blue(); break;
			case 4: show_yellow(); break;
			case 5: show_cyan(); break;
			case 6: show_magenta(); break;
			case 7: show_white();break;
			case 8: show_nothing();break;
			default:
		}
	}
}




///////////////////////////////////////
//
//=========== DEMO mode, state=53
//
void ec_f2()
{
	long t1 = 0;
	int1 f_true = 1;
	int1 f_final = 0;
	int color1 = 1;
	int color2 = 8; 

	ec_counter = 0;
	
	while(state == 53)
	{
		while(f_true && state == 53)
		{
			if(f_ec_step)
			{
				f_ec_step=0;
				t1+=300;	//end coordinate
				if(t1>=dr_time) 
				{
					if(f_final) f_true = 0;
					t1 = 0;
					color2 = color1;
					color1 += 1;
					if(color1 == 8) f_final = 1;
				}
			}
			ec_ff(color1,0,t1);
			ec_ff(color2,t1,dr_time);
		}	
		t1 = 0;
		f_true = 1;
		f_final = 0;
		color1 = 1;
		color2 = 8; 
		ec_counter = 0;
	}
}

///////////////////////////////////////
//
//=========== DEMO mode, state=57
//

void ec_f2_1()
{
	long t1 = 0;
	long t2 = 0;
	long tt = 0;

	int1 f_true = 1;
	int1 f_start = 0;
	int1 f_final = 0;
	int st = 0;

	int color1 = 1;
	int color2 = 8;
	int color3 = 8; 

	tt = dr_time/2;

	t2 = tt;
	ec_counter = 0;

	while(state == 57)
	{
	while(f_true && state == 57)
	{
		if(f_ec_step && !PB2s)
		{
			f_ec_step=0;
			t1+=200;	//end coordinate
			t2+=200;
			if(t1>=tt) 
			{
				switch(st) {
					case 0:	st = 1; break;	//start sequense, one color
					case 1: color3 = color2; break;	//two colors
				}
				if(f_final) f_true = 0;
				t2 = t1;
				t1 = 0;
				color2 = color1;
				color1 += 1;
				if(color1 == 8) f_final = 1;
			}
		}
	
		ec_ff(color1,0,t1);

		if(!st)
		{
			ec_ff(color2,t1,dr_time);
		}
		else
		{
			ec_ff(color2,t1,tt+t1);
		}
		ec_ff(color3,tt+t1,dr_time);
	}	

	t1 = 0;
	t2 = 0;
	tt = 0;
	f_true = 1;
	f_start = 0;
	f_final = 0;
	st = 0;

	color1 = 1;
	color2 = 8;
	color3 = 8; 

	tt = dr_time/2;

	t2 = tt;
	ec_counter = 0;
}

}

///////////////////////////////////////
//
//=========== DEMO mode, state=59
//

void ec_f2_2()
{
	long t1 = 0;
	int1 f_true = 1;
	int1 f_final = 0;
	int color1 = 1;
	int color2 = 8; 

	ec_counter = 0;

	while(state == 59)
	{
		while(f_true && state == 59)
		{
			if(f_ec_step)
			{
				f_ec_step=0;
				t1+=300;	//end coordinate
				if(t1>=dr_time/2) 
				{
					if(f_final) f_true = 0;
					t1 = 0;
					color2 = color1;
					color1 += 1;
					if(color1 == 8) f_final = 1;
				}
			}
			ec_ff(color1,0,t1);
			ec_ff(color1,dr_time-t1,dr_time);
			ec_ff(color2,t1,dr_time-t1);
		}	
		t1 = 0;
		f_true = 1;
		f_final = 0;
		color1 = 1;
		color2 = 8; 
		ec_counter = 0;
	}
}

///////////////////////////////////////
//
//=========== DEMO mode, state=55
//
void ec_f2_3()
{
	long t1 = 0;
	int1 f_true = 1;
	int1 f_final = 0;
	int1 f_dir = 0;
	int1 f_cc = 0;
	int color1 = 1;
	int color2 = 8; 

	ec_counter = 0;
	while(state == 55)
	{

		while(f_true && state == 55)
		{
			if(f_ec_step)
			{
				f_ec_step=0;
				if(!f_dir)
				{
					t1+=300;	//end coordinate
					if(t1>=dr_time/2) 
					{
						f_cc = 1;
						f_dir = 1;
					}
				}
				else
				{
					t1-=300;
					if(t1<=0)
					{
						f_cc = 1;
						f_dir = 0;
					}	
				}
				if(f_cc)
				{	
					f_cc = 0;
					if(f_final) f_true = 0;
					color2 = color1;
					color1 += 1;
					if(color1 == 8) f_final = 1;
				}
			}
			ec_ff(color1,0,t1);
			ec_ff(color1,dr_time-t1,dr_time);
			ec_ff(color2,t1,dr_time-t1);
		}
		t1 = 0;
		f_true = 1;
		f_final = 0;
		f_dir = 0;
		f_cc = 0;
		color1 = 1;
		color2 = 8; 
		ec_counter = 0;
	}
}

