#include <X10Firecracker.h>
#include <Servo.h> 
#include <NewSoftSerial.h>

NewSoftSerial mySerial =  NewSoftSerial(13, 12);  // Pin 13 to xbee tx, Pin 12 to xbee rx
Servo myservo;             // New instance of Servo.h

int buttonPin = 8;         // Button pin GND+100K+Pin8 - V5
int shakerPin = 7;         // Servo used to shake (continous rotating servo)
int servoPin = 6;          // Servo used to rotate the CD
int dtrPin = 3;            // DTR line for C17A - DB9 pin 4
int rtsPin = 2;            // RTS line for C17A - DB9 pin 7

int buttonState = 0;       // Initialize button state to low
int bitDelay = 1;          // mS delay between bits (1 mS OK)    
int counter = 0;          // counter used to change/toogle lcd message

char code[32] = "";

void setup(){
  pinMode(buttonPin, INPUT);
  myservo.attach(servoPin);
  pinMode(shakerPin, OUTPUT);
  Serial.begin(9600);
  clearLCD();
  displayMessage("Getting code."); 
  moveCursor("02", "01");
  displayMessage("Please wait...");   
  mySerial.begin(9600);
  mySerial.println("[[[http:/my.apexserver.com/pls/apex/getcode]]]");
  delay(1000); 
  X10.init(rtsPin, dtrPin, bitDelay);  // Initialize X10 C17A
  myservo.write(0);
  digitalWrite(shakerPin, HIGH);
  delay(1000); 
  digitalWrite(shakerPin, LOW);
  setBacklightBrightness(5); 
}

void loop(){
  buttonState = digitalRead(buttonPin);
  char charIn = 0;
  byte i = 0;
  char stringIn[32] = "";

  while(mySerial.available()) {
    charIn = mySerial.read();
    stringIn[i] = charIn;
    i += 1;
  }
           
  if (strlen(stringIn) > 0){
    if (stringIn[0] == 'c'){ // Drop Candy
      dropCandy();
    }else if (stringIn[0] == '*'){ // Display custom message
      clearLCD();
      displayMessage(stringIn);
    }else if (stringIn[0] == '-'){ // Clear LCD screen
      clearLCD(); 
      mySerial.println("[[[get|http:/my.apexserver.com/pls/apex/getcode]]]");     
    }else if (stringIn[0] == 's'){ // Shake candy
      clearLCD();
      displayMessage("Shaking...");  
      shake();
      clearLCD();
      mySerial.println("[[[get|http:/my.apexserver.com/pls/apex/getcode]]]");
    }else{
      //strncpy(code, stringIn, 32);
      strncpy(code, stringIn, strlen(stringIn) -1);
    }
  }
  
  if (buttonState == HIGH) { 
    dropCandy();
  }
 
  if ((counter == 0 || counter == 75) && strlen(code) > 0 ){
    clearLCD();
    moveCursor("01", "01");
    displayMessage("Text/Call ");
    displayMessage(code);
    moveCursor("02", "01");
    displayMessage("(512) XXX-XXXX");
    turnCursorOff();
  }else if(counter == 150  &&  strlen(code) > 0){
    clearLCD();
    moveCursor("01", "01");
    displayMessage("Tweet \"@tweetfortreat ");
    displayMessage(code);
    displayMessage("\"");
    turnCursorOff();
    counter = 0;
  }  
  
  delay(100);
  counter++;
}

void dropCandy(){
  //Clear LCD  
  clearLCD();
  setBacklightBrightness(9);
  turnBlinkingCursorOn();  
  displayMessage("Watch out for    falling candy!");  
  //Turn on X10 light and fog
  X10.sendCmd( hcC, 1, cmdOn );
  X10.sendCmd( hcC, 3, cmdOn );
  myservo.write(180);
  delay(700);
  myservo.write(0);
  clearLCD();    
  displayMessage("Happy Halloween!");
  //Wait 30 seconds before next candy
  shake();
  //Turn on X10 light and fog
  X10.sendCmd( hcC, 1, cmdOff );
  X10.sendCmd( hcC, 3, cmdOff );  
  clearLCD();  
  turnBlinkingCursorOff();  
  mySerial.println("[[[get|http:/my.apexserver.com/pls/apex/getcode]]]");
}

void shake(){
  int var = 0;
  char buffer[5];
  // Activate the continous rotation servo.
  while(var < 800){
    digitalWrite(shakerPin,HIGH);
    delayMicroseconds(1200); // 1.5ms
    digitalWrite(shakerPin,LOW);
    delay(20); // 20ms   
    var++;
  }
}
