//
// ioBridge Serial LCD Functions and Parameters
//
// The ioBridge Serial LCD Uses a Baud Rate of 9600 on Pin 1  

void displayMessage(char* message){
  Serial.print(message);
}

void clearLCD(){
  Serial.print(0xFE, BYTE);    
  Serial.print("Z");
}

void setBacklightBrightness(int level){
  // level
  // 0=Off -> 9=Brightest

  Serial.print(0xFE, BYTE); 
  Serial.print("B");
  Serial.print(level);
}

void setBacklightTime(int level, byte seconds){
  // level
  // 0=Off -> 9=Brightest

  // seconds
  // 01 = 1 seconds => 06 = 60 seconds

  Serial.print(0xFE, BYTE); 
  Serial.print("T");
  Serial.print(level);
  Serial.print(seconds, BYTE);
}

void moveCursorHome(){
  Serial.print(0xFE, BYTE);    
  Serial.print("H");
}

void turnCursorOn(){
  Serial.print(0xFE, BYTE);    
  Serial.print("J");
}

void turnCursorOff(){
  Serial.print(0xFE, BYTE);    
  Serial.print("K");
}

void turnBlinkingCursorOn(){
  Serial.print(0xFE, BYTE);    
  Serial.print("P");
}

void turnBlinkingCursorOff(){
  Serial.print(0xFE, BYTE);    
  Serial.print("Q");
}

void scrollMessage(int row, int speed, char* message){
  // row
  // 1=First Line -> 2=Second Line

  // speed
  // 0=Slowest -> 9=Fastest

  Serial.print(0xFE, BYTE);    
  Serial.print("S");
  Serial.print(row);
  Serial.print(speed);
  Serial.print(message);
  Serial.print(0xFE, BYTE); 
}

void moveCursor(char* row, char* column){
  // row
  // 01=First Line -> 02=Second Line

  // column
  // 01=First Position -> 16=Last Position

  Serial.print(0xFE, BYTE);    
  Serial.print("L");
  Serial.print(row);
  Serial.print(column); 
}

void drawHorizontalGauge(int row, char* leftLabel, char* rightLabel, char* length){
  // row
  // 1=First Line -> 2=Second Line

  // leftLabel and rightLabel
  // 2 character labels

  // length
  // a=Empty -> k=Full (filled in from left to right)

  Serial.print(0xFE, BYTE);    
  Serial.print("G");
  Serial.print(row);
  Serial.print(leftLabel);
  Serial.print(rightLabel); 
  Serial.print(length); 
}

void drawVerticalGauge(int height){
  // height
  // 0=Bottom -> 8=Top (filled in from bottom to top)

  Serial.print(0xFE, BYTE);    
  Serial.print("V");
  Serial.print(height);  

}
