#include <X10Firecracker.h>
#include <Servo.h> 
#include <NewSoftSerial.h>

#include "WProgram.h"
void setup();
void loop();
void dropCandy();
void shake();
void displayMessage(char* message);
void clearLCD();
void setBacklightBrightness(int level);
void setBacklightTime(int level, byte seconds);
void moveCursorHome();
void turnCursorOn();
void turnCursorOff();
void turnBlinkingCursorOn();
void turnBlinkingCursorOff();
void scrollMessage(int row, int speed, char* message);
void moveCursor(char* row, char* column);
void drawHorizontalGauge(int row, char* leftLabel, char* rightLabel, char* length);
void drawVerticalGauge(int height);
NewSoftSerial mySerial =  NewSoftSerial(13, 12);  // Pin 13 to xbee tx, Pin 12 to xbee rx
Servo myservo;             // New instance of Servo.h

int buttonPin = 8;         // Button pin GND+100K+Pin8 - V5
int shakerPin = 7;         // Servo used to shake (continous rotating servo)
int servoPin = 6;          // Servo used to rotate the CD
int dtrPin = 3;            // DTR line for C17A - DB9 pin 4
int rtsPin = 2;            // RTS line for C17A - DB9 pin 7

int buttonState = 0;       // Initialize button state to low
int bitDelay = 1;          // mS delay between bits (1 mS OK)    
int counter = 0;          // counter used to change/toogle lcd message

char code[32] = "";

void setup(){
  pinMode(buttonPin, INPUT);
  myservo.attach(servoPin);
  pinMode(shakerPin, OUTPUT);
  Serial.begin(9600);
  clearLCD();
  displayMessage("Getting code."); 
  moveCursor("02", "01");
  displayMessage("Please wait...");   
  mySerial.begin(9600);
  mySerial.println("[[[get|http://bit.ly/99pW3p]]]");
  delay(1000); 
  X10.init(rtsPin, dtrPin, bitDelay);  // Initialize X10 C17A
  myservo.write(0);
  digitalWrite(shakerPin, HIGH);
  delay(1000); 
  digitalWrite(shakerPin, LOW);
  setBacklightBrightness(5); 
}

void loop(){
  buttonState = digitalRead(buttonPin);
  char charIn = 0;
  byte i = 0;
  char stringIn[32] = "";

  while(mySerial.available()) {
    charIn = mySerial.read();
    stringIn[i] = charIn;
    i += 1;
  }
           
  if (strlen(stringIn) > 0){
    if (stringIn[0] == 'c'){ // Drop Candy
      dropCandy();
    }else if (stringIn[0] == '*'){ // Display custom message
      clearLCD();
      displayMessage(stringIn);
    }else if (stringIn[0] == '-'){ // Clear LCD screen
      clearLCD(); 
      mySerial.println("[[[get|http://bit.ly/99pW3p]]]");     
    }else if (stringIn[0] == 's'){ // Shake candy
      clearLCD();
      displayMessage("Shaking...");  
      shake();
      clearLCD();
      mySerial.println("[[[get|http://bit.ly/99pW3p]]]");
    }else{
      //strncpy(code, stringIn, 32);
      strncpy(code, stringIn, strlen(stringIn) -1);
    }
  }
  
  if (buttonState == HIGH) { 
    dropCandy();
  }
 
  if ((counter == 0 || counter == 75) && strlen(code) > 0 ){
    clearLCD();
    moveCursor("01", "01");
    displayMessage("Text/Call ");
    displayMessage(code);
    moveCursor("02", "01");
    displayMessage("(512) 430-4506");
    turnCursorOff();
  }else if(counter == 150  &&  strlen(code) > 0){
    clearLCD();
    moveCursor("01", "01");
    displayMessage("Tweet \"@tweetfortreat ");
    displayMessage(code);
    displayMessage("\"");
    turnCursorOff();
    counter = 0;
  }  
  
  delay(100);
  counter++;
}

void dropCandy(){
  //Clear LCD  
  clearLCD();
  setBacklightBrightness(9);
  turnBlinkingCursorOn();  
  displayMessage("Watch out for    falling candy!");  
  //Turn on X10 light and fog
  X10.sendCmd( hcC, 1, cmdOn );
  X10.sendCmd( hcC, 3, cmdOn );
  myservo.write(180);
  delay(700);
  myservo.write(0);
  clearLCD();    
  displayMessage("Happy Halloween!");
  //Wait 30 seconds before next candy
  shake();
  //Turn on X10 light and fog
  X10.sendCmd( hcC, 1, cmdOff );
  X10.sendCmd( hcC, 3, cmdOff );  
  clearLCD();  
  turnBlinkingCursorOff();  
  mySerial.println("[[[get|http://bit.ly/99pW3p]]]");
}

void shake(){
  int var = 0;
  char buffer[5];
  // Activate the continous rotation servo.
  while(var < 800){
    digitalWrite(shakerPin,HIGH);
    delayMicroseconds(1200); // 1.5ms
    digitalWrite(shakerPin,LOW);
    delay(20); // 20ms   
    var++;
  }
}
//
// ioBridge Serial LCD Functions and Parameters
//
// The ioBridge Serial LCD Uses a Baud Rate of 9600 on Pin 1  

void displayMessage(char* message){
  Serial.print(message);
}

void clearLCD(){
  Serial.print(0xFE, BYTE);    
  Serial.print("Z");
}

void setBacklightBrightness(int level){
  // level
  // 0=Off -> 9=Brightest

  Serial.print(0xFE, BYTE); 
  Serial.print("B");
  Serial.print(level);
}

void setBacklightTime(int level, byte seconds){
  // level
  // 0=Off -> 9=Brightest

  // seconds
  // 01 = 1 seconds => 06 = 60 seconds

  Serial.print(0xFE, BYTE); 
  Serial.print("T");
  Serial.print(level);
  Serial.print(seconds, BYTE);
}

void moveCursorHome(){
  Serial.print(0xFE, BYTE);    
  Serial.print("H");
}

void turnCursorOn(){
  Serial.print(0xFE, BYTE);    
  Serial.print("J");
}

void turnCursorOff(){
  Serial.print(0xFE, BYTE);    
  Serial.print("K");
}

void turnBlinkingCursorOn(){
  Serial.print(0xFE, BYTE);    
  Serial.print("P");
}

void turnBlinkingCursorOff(){
  Serial.print(0xFE, BYTE);    
  Serial.print("Q");
}

void scrollMessage(int row, int speed, char* message){
  // row
  // 1=First Line -> 2=Second Line

  // speed
  // 0=Slowest -> 9=Fastest

  Serial.print(0xFE, BYTE);    
  Serial.print("S");
  Serial.print(row);
  Serial.print(speed);
  Serial.print(message);
  Serial.print(0xFE, BYTE); 
}

void moveCursor(char* row, char* column){
  // row
  // 01=First Line -> 02=Second Line

  // column
  // 01=First Position -> 16=Last Position

  Serial.print(0xFE, BYTE);    
  Serial.print("L");
  Serial.print(row);
  Serial.print(column); 
}

void drawHorizontalGauge(int row, char* leftLabel, char* rightLabel, char* length){
  // row
  // 1=First Line -> 2=Second Line

  // leftLabel and rightLabel
  // 2 character labels

  // length
  // a=Empty -> k=Full (filled in from left to right)

  Serial.print(0xFE, BYTE);    
  Serial.print("G");
  Serial.print(row);
  Serial.print(leftLabel);
  Serial.print(rightLabel); 
  Serial.print(length); 
}

void drawVerticalGauge(int height){
  // height
  // 0=Bottom -> 8=Top (filled in from bottom to top)

  Serial.print(0xFE, BYTE);    
  Serial.print("V");
  Serial.print(height);  

}

int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

