MyCamera cam;
int index = 0;
ArrayList<BoxGen> boxes;

void setup() {
  size(6600/6, 8400/6, P3D);

  cam = new MyCamera(width);

  rectMode(CENTER);
  noStroke();
  boxes = new ArrayList<BoxGen>();

  for (int i=0; i < 500; i++)
    boxes.add( new BoxGen( new PVector(random(-width/4, width/4), random(-width/4, width/4),random(-width/4, width/4) ), random(10, 30) ) );
}

void draw() {
  background(255);
  lights();
  directionalLight(51, 102, 126, 0, -1, 0);
  cam.render();

  for (BoxGen b : boxes)
    b.display();
}


void keyPressed() {
  if (key == CODED) {
    if (keyCode == RIGHT) {
      cam.moveRight();
    }
    if (keyCode == LEFT) {
      cam.moveLeft();
    }
  }

  if (key == ' ') {
    saveFrame("data/01-box3-" + index + ".jpg"); 
    index++;
  }
}

