//lenticular is 22x28" inches - 3D 20LPI
//Epson Stylus Pro Printer: 2880 x 1440 dpi
//At 300dpi the dimensions are - 6600x8400 ******USING THIS****
//At 600dpi the dimensions are - 13200x16800
//At 1200dpi the dimensions are - 26400x33600
//At 2880dpi the dimensions are - 63360x80640 pixels

int lensPerInch = 20; //LPI
int printerResolution = 300; //DPI
int pixelsPerLens = printerResolution / lensPerInch; //30 pixels per inch at 600dpi //15 pixels per inch at 300dpi
int numImages = 5; //6 pixels per lens //3 pixels per lens  ///***after tests 5 works well with 2 pixelsPerLace***
PImage[] images = new PImage[numImages];
PImage finalImage;
int pixelsPerLace = 3; //actual 3 pixels per image

void setup() {
  size(6600/6, 8400/6); //size of images loaded
  
  //view values above for final print (6600x8400) for 300 dpi final print
  background(255);

  finalImage = createImage(width, height, RGB);

  //load images
  for (int i = 0; i<images.length; i++) {
    images[i] = loadImage( "images/" + i + ".jpg");
    images[i] = loadImage( "rects/01-box3-"+i+".jpg");
  }

  interlace();
}

void draw() {
  noLoop();
}

//after saving image
//open image in photo shope > image size
//turn off resample
//up resolution to 300dpi
//or just copy it into a 300 dpi photoshop file




void interlace() {
  //loop through images and set final image
  for (int y = 0; y<height; y++) {
    int index = 0;
    int imageNum = 0;

    for (int x = 0; x<width; x++) {
      int loc = y*width + x;

      index++;
      if (index >= pixelsPerLace) { //how many pixels per interlace
        index=0;
        imageNum++;
      }
      if (imageNum > numImages-1) {
        imageNum = 0;
      }

      finalImage.pixels[loc] = images[imageNum].pixels[loc];
    }
  }

  image(finalImage, 0, 0);
  
  saveFrame("data/processed/"+pixelsPerLace+"pixelperlace-1angle.jpg");
}
