// Power Switch Controller
server.log("Impowered");

currentACState   <- "Power is off";

//--------------------------------------------------------------------------------------------------------
function checkACStatus()
{
    
    if( hardware.pin1.read() == 1 )
    {
        currentACState = "Power is off";
    }
    else
    {
        currentACState = "Power is on";
    }
    
    agent.send( "acCircuitStatus", currentACState );
   

}

//--------------------------------------------------------------------------------------------------------
// Turn relay on or off depending on the previous output state
//--------------------------------------------------------------------------------------------------------
function toggleRelay()
{
    // Set pin1 and pin7 to that same state. The new state
    // is the inverse of the previous state.
    hardware.pin1.write( hardware.pin1.read() == 0 ? 1 : 0 );
    hardware.pin7.write( hardware.pin1.read() )
    
    checkACStatus();

}

//--------------------------------------------------------------------------------------------------------
agent.on("buttonPressed", function( value ) 
{
    if( value )
    {
        server.log("Received buttonPressed event from Agent: " + value );
        toggleRelay();
    }
    
}); 

//--------------------------------------------------------------------------------------------------------
// Main configuration statement required for all Imp programs
//--------------------------------------------------------------------------------------------------------
imp.configure("Impowered", [], [] );

//--------------------------------------------------------------------------------------------------------
// Configure pins. PIN7 = Relay Control, PIN1 Relay Control, PIN2 = ADC for thermistor
//--------------------------------------------------------------------------------------------------------
hardware.pin7.configure(DIGITAL_OUT);
hardware.pin1.configure(DIGITAL_OUT);

// Make sure pins are high - relays off
hardware.pin7.write(1);
hardware.pin1.write(1);

function keepAlive()
{
    imp.wakeup(10.0, keepAlive );
}

keepAlive();
