// This is the main code, it should run on the main processor.
// Read PPM signals from 3 channels of an RC reciever and convert the values to PWM in either direction.
// digital pins 5 & 9 control motor1, digital pins 6 & 10 control motor2. 
// DP 12 and 13 are neutral indicator lights. 
// DP 2 and 3 are inputs from the R/C receiver. 
// All analog pins are open. 
// When motor pin is HIGH, bridge is open.
// JDW 2009



int motor1_a = 5;
int motor1_b = 9;

int motor2_a = 6;
int motor2_b = 10;

int ledPin1 = 13;
int ledPin2 = 12;
int ledPin3 = 14;

int servo1 = 2; 
int servo2 = 3;
int servo3 = 7;

int power = 4;

int relay_Pin = 8;

unsigned int relay_val;

volatile unsigned long servo1_startPulse;
volatile unsigned servo1_val; 
volatile int adj_val1;  
volatile int servo1_Ready;

volatile unsigned long servo2_startPulse;
volatile unsigned servo2_val; 
volatile int adj_val2;  
volatile int servo2_Ready;

int deadband_high = 275; 
int deadband_low = 235;  

int pwm_ceiling = 256; 
int pwm_floor = 255;  

int low1 = 292;
int high1 = 464;
int low2 = 276;
int high2 = 472;

int n = 0;

void setup() {
  
//  TCCR0B = TCCR0B & 0b11111000 | 0x03;
  TCCR1B = TCCR1B & 0b11111000 | 0x01;
  
  Serial.begin(9600);
  
  //motor1 pins
  pinMode(motor1_a, OUTPUT);
  pinMode(motor1_b, OUTPUT);

  pinMode(motor2_a, OUTPUT);
  pinMode(motor2_b, OUTPUT);

  pinMode(relay_Pin, OUTPUT);
  
  pinMode(power, OUTPUT);

  //led's
  pinMode(ledPin1, OUTPUT);
  pinMode(ledPin2, OUTPUT);
  pinMode(ledPin3, OUTPUT);

  //PPM inputs from RC receiver
  pinMode(servo1, INPUT); //Pin 2 as input
  pinMode(servo2, INPUT); //Pin 3 as input
  pinMode(servo3, INPUT); //Pin 3 as input

  digitalWrite(power, HIGH);
  digitalWrite(relay_Pin, LOW);
  
  delay(1200);

  attachInterrupt(0, rc1_begin, RISING);    // catch interrupt 0 (digital pin 2) going HIGH and send to rc1()
  attachInterrupt(1, rc2_begin, RISING);    // catch interrupt 1 (digital pin 3) going HIGH and send to rc2()

}


void rc1_begin() {           // enter rc1_begin when interrupt pin goes HIGH.

  servo1_startPulse = micros();     // record microseconds() value as servo1_startPulse
  
  detachInterrupt(0);  // after recording the value, detach the interrupt from rc1_begin
  
  attachInterrupt(0, rc1_end, FALLING); // re-attach the interrupt as rc1_end, so we can record the value when it goes low
  
}

void rc1_end() {
 
 servo1_val = micros() - servo1_startPulse;  // when interrupt pin goes LOW, record the total pulse length by subtracting previous start value from current micros() vlaue.
  
 detachInterrupt(0);  // detach and get ready to go HIGH again
 
 if (servo1_val < 150 || servo1_val > 600) {  // only set the servo1_Ready flag if the value is a valid Servo pulse between 600-2400 microseconds.
  servo1_Ready = false; 
  servo1_val = 260;
 }
 else {
  servo1_Ready = true; // if not, don't pass the value to be processed
 }
 
 attachInterrupt(0, rc1_begin, RISING);
 
}


void rc2_begin() {

  servo2_startPulse = micros();

  detachInterrupt(1);
  
  attachInterrupt(1, rc2_end, FALLING);
  
}

void rc2_end() {
 
 servo2_val = micros() - servo2_startPulse;
  
 detachInterrupt(1);
 
 if (servo2_val < 150 || servo2_val > 600) {
  servo2_Ready = false; 
  servo2_val = 260;
 }
 else {
  servo2_Ready = true; 
 }
 
 attachInterrupt(1, rc2_begin, RISING); 
 
}



void loop() {
	         
    if (servo1_Ready) {
      
      servo1_Ready = false;  
      adj_val1 = map(constrain(servo1_val, 150, 600), low1, high1, 0, 511); 
      constrain(adj_val1, 0, 511);

      if (adj_val1 < 0) {
        adj_val1 = 0; 
      }     
      if (adj_val1 > 511) {
        adj_val1 = 511; 
      }

      if (adj_val1 > deadband_high) {
        //Forward
        digitalWrite(motor1_b, LOW);
        analogWrite(motor1_a, adj_val1 - pwm_ceiling); 
        digitalWrite(ledPin1, LOW);
      }
      else if (adj_val1 < deadband_low) {
        //REVERSE
        digitalWrite(motor1_a, LOW);
        analogWrite(motor1_b, pwm_floor - adj_val1);
        digitalWrite(ledPin1, LOW);
      }
      else {
        //STOP
        digitalWrite(motor1_a, LOW);
        digitalWrite(motor1_b, LOW);
        digitalWrite(ledPin1, HIGH); // turn on neutral light, turn motor pins off
      }
      
    }
    


   if (servo2_Ready) {
      
      servo2_Ready = false;  
      adj_val2 = map(constrain(servo2_val, 150, 600), low1, high1, 0, 511); 
      constrain(adj_val2, 0, 511);

      if (adj_val2 < 0) {
        adj_val2 = 0; 
      }     
      if (adj_val2 > 511) {
        adj_val2 = 511; 
      }

      if (adj_val2 > deadband_high) {
        //Forward
        digitalWrite(motor2_b, LOW);
        analogWrite(motor2_a, adj_val2 - pwm_ceiling); 
        digitalWrite(ledPin2, LOW);
      }
      else if (adj_val2 < deadband_low) {
        //REVERSE
        digitalWrite(motor2_a, LOW);
        analogWrite(motor2_b, pwm_floor - adj_val2);
        digitalWrite(ledPin2, LOW);
      }
      else {
        //STOP
        digitalWrite(motor2_a, LOW);
        digitalWrite(motor2_b, LOW);
        digitalWrite(ledPin2, HIGH); // turn on neutral light, turn motor pins off
      }
      
    }





    //print values
    Serial.print("ch1:  ");
    Serial.print(adj_val1);
    Serial.print("  ");
    Serial.print("rc1:  ");
    Serial.print(servo1_val);
    Serial.print("  ");
    Serial.print("ch2:  ");
    Serial.print(adj_val2);
    Serial.print("  ");
    Serial.print("rc2:  ");
    Serial.print(servo2_val);
    Serial.println("  ");    

    n++;

 
}



