// Demo using DHCP and DNS to perform a web client request.
// 2011-06-08 <jc@wippler.nl> http://opensource.org/licenses/mit-license.php

#include <EtherCard.h>


#define LED_A A0
#define LED_B A1
#define LED_C A2
#define LED_D 2
#define LED_E 3
#define LED_F 4
#define LED_G 5
//#define LED_DP 7

#define LED_CHAR1 6
#define LED_CHAR2 7
#define LED_CHAR3 8
#define LED_CHAR4 9     

String followers;


// ethernet interface mac address, must be unique on the LAN
static byte mymac[] = { 0x74,0x69,0x69,0x2D,0x30,0x31 };

byte Ethernet::buffer[500];
static uint32_t timer;
//add www before domain name without subdomain
//const char website[] PROGMEM = "www.nikodembartnik.pl";

//when you use subdomain don't use www befor subdomain name
const char website[] PROGMEM = "livecounter.esy.es";

// called when the client request is complete
static void my_callback (byte status, word off, word len) {
  Ethernet::buffer[off+400] = 0;
  String res = (const char*) Ethernet::buffer + off;
  Serial.println(res);
  int start_position = res.indexOf("$%#");
  String followers_number = res.substring(start_position + 3);
  followers_number = followers_number.substring(0, followers_number.indexOf("$%#"));
  followers_number.trim();
  followers = followers_number;
  Serial.print(followers_number);
  Serial.println();

  
  
  //Serial.println("...");
}

void setup () {

  pinMode(LED_A, OUTPUT);
  pinMode(LED_B, OUTPUT);
  pinMode(LED_C, OUTPUT);
  pinMode(LED_D, OUTPUT);
  pinMode(LED_E, OUTPUT);
  pinMode(LED_F, OUTPUT);
  pinMode(LED_G, OUTPUT);
  pinMode(LED_CHAR1, OUTPUT);
  pinMode(LED_CHAR2, OUTPUT);
  pinMode(LED_CHAR3, OUTPUT);
  
  Serial.begin(57600);

  if (ether.begin(sizeof Ethernet::buffer, mymac) == 0) 
    Serial.println("Failed to access enc28j60");
  if (!ether.dhcpSetup())
    Serial.println(F("DHCP failed"));

  ether.printIp("IP:  ", ether.myip);
  ether.printIp("GW:  ", ether.gwip);  
  ether.printIp("DNS: ", ether.dnsip);  

//#if 1
  // use DNS to resolve the website's IP address
  if (!ether.dnsLookup(website))
    Serial.println("DNS failed");
    Serial.println("#1");
    /*
#elif 2
  // if website is a string containing an IP address instead of a domain name,
  // then use it directly. Note: the string can not be in PROGMEM.
  char websiteIP[] = "95.211.80.4";
  ether.parseIp(ether.hisip, websiteIP);
  Serial.println("#2");
#else
  // or provide a numeric IP address instead of a string
  byte hisip[] = { 95,211,80,4 };
  ether.copyIp(ether.hisip, hisip);
  Serial.println("#3");
#endif
    */
  ether.printIp("SRV: ", ether.hisip);
}

void loop () {
  
  ether.packetLoop(ether.packetReceive());
  
  if (millis() > timer) {
    //update every 5 minutes
    timer = millis() + 1000 * 60 * 5;
   
    ether.browseUrl(PSTR("/"), "counter.php", website, my_callback);
  }
 
for(int a = 0; a < 4; a++){
show_number(a+1, followers.substring(a, a+1).toInt(), 0);
  delay(1);
  
} 
}




void show_number(int char_number, int number, int decimal_point){

  //turning off all segments of display

  digitalWrite(LED_A, HIGH);
  digitalWrite(LED_B, HIGH);
  digitalWrite(LED_C, HIGH);
  digitalWrite(LED_D, HIGH);
  digitalWrite(LED_E, HIGH);
  digitalWrite(LED_F, HIGH);
  digitalWrite(LED_G, HIGH);

  digitalWrite(LED_CHAR1, LOW);
  digitalWrite(LED_CHAR2, LOW);
  digitalWrite(LED_CHAR3, LOW);

  //turning leds on

  if(number == 0 || number == 2 || number == 3 || number == 5 || number == 6 || number == 7 || number == 8 || number == 9){
    digitalWrite(LED_A, LOW);
  }
  if(number == 0 || number == 1 || number == 2 || number == 3 || number == 4 || number == 7 || number == 8 || number == 9){
    digitalWrite(LED_B, LOW);
  }
  if(number == 0 || number == 1 || number == 3 || number == 4 || number == 5 || number == 6 || number == 7 || number == 8 || number == 9){
    digitalWrite(LED_C, LOW);
  }
  if(number == 0|| number == 2 || number == 3 || number == 5 || number == 6 || number == 8 || number == 9){
    digitalWrite(LED_D, LOW);
  }
  if(number == 0|| number == 2 || number == 6 || number == 8){
    digitalWrite(LED_E, LOW);
  }
  if(number == 0 || number == 4 || number == 5 || number == 6 || number == 8 || number == 9){
    digitalWrite(LED_F, LOW);
  }
  if(number == 2 || number == 3 || number == 4 || number == 5 || number == 6 || number == 8 || number == 9){
    digitalWrite(LED_G, LOW);
  }
  /*
  if(decimal_point > 0){
      LED_DP_PORT &= ~LED_DP;
  }
*/
if(char_number == 1){
  digitalWrite(LED_CHAR1, HIGH);
}else if(char_number == 2){
  digitalWrite(LED_CHAR2, HIGH);
}else if(char_number == 3){
  digitalWrite(LED_CHAR3, HIGH);

}else if(char_number == 4){
  digitalWrite(LED_CHAR4, HIGH);

}
}
