/*
  MechLabWatch.h - Library for controlling the mechLab Watch.

  This Object stores the time and controls the display and inputs
  
  Created by Jonathan Hodgins, August 2, 2017.
*/

#ifndef MechLabsWatch_h
#define MechLabsWatch_h

#include "Arduino.h"
class Watch
{
  public:
    Watch(void);
    void initilize(void);
    void setTime(int hh,int mm);
    void showTime();
    void showRaw(boolean leds[28]);
    int hours;
    int minutes;
    
  private:
    const long ledOnTime = 50;//in uS
    const boolean columnOn = 1;
    const boolean columnOff = 0;
    const int8_t numRow = 6;
    const int8_t numCol = 5;
    void setRow(int8_t row,boolean ledState);
    void setColumn(int8_t column,boolean turnOn);
};

#endif
