
#include "Arduino.h"
#include "Motor.h"



void Motor::setInputs(int pinA,int pinB,int pwm)
{
	pinMode(pinA, OUTPUT);
	pinMode(pinB, OUTPUT);
	pinMode(pwm, OUTPUT);
	
	_pinA = pinA;
	_pinB = pinB;
	_pwm = pwm;
}

void Motor::goForward(int pwm)
{
	digitalWrite(_pinA, HIGH);
	digitalWrite(_pinB, LOW);
	analogWrite(_pwm, pwm);
}

void Motor::goBackward(int pwm)
{
	digitalWrite(_pinA, LOW);
	digitalWrite(_pinB, HIGH);
	analogWrite(_pwm, pwm);
}

void Motor::motorstop()
{
	digitalWrite(_pinA, HIGH);
	digitalWrite(_pinB, HIGH);
	analogWrite(_pwm, 255);
}

void Motor::stop()
{
	digitalWrite(_pinA, LOW);
	digitalWrite(_pinB, LOW);
	analogWrite(_pwm, 0);
}





