#include "WProgram.h"
void display(int ms_delay);
int double_to_int(double a);
double takeTemp();
void displayTemp(double T, boolean inCelcius);
void demo();
void chrono();
void timer();
void changeDisplay(int changeTo,int num);
/* Digital thermometer
 * ---------------- 
 *
 * Reads the analog signal from a LM35DZ then outputs the
 * average of the past 10 temperature readings to a 7 segment display
 *
 * Created 2 April 2007
 * copyleft 2007 Jonathan Hodgins
 */

int tempPin=0;
double temp=0;
const boolean celcius = true, fahrenheit = false;
const int numAvg = 10;
double pastRead[numAvg];

int sliderPin=1;
int sliderValue=0;
int demoCounter=0;

long startTime=millis();
long currentTime=millis();
int waitA=0, waitB=0, waitTime=0;

int mode=0,modePin =12, modePinState=LOW;
const int numModes=4;
const int numSubModes[numModes]={
  2,3,4,4};
int subMode=0, subModePin =13, subModePinState=LOW;

const bool on=true,off=false;
bool dimmer = on;
const int numOutputs = 2;
int segPins[8]={
  2,3,4,5,6,7,8,9};
int seg[numOutputs][8];
int cathodes[]={
  10,11};

int del = 100;//time between readings
int fps=120;
int delayFrame=(1000/120)/numOutputs;//sets to 60 frames/sec

void setup() 
{
  for(int i=0;i<numAvg;i++)
    pastRead[i]=0;

  for(int i=0;i<9;i++)
  {
    pinMode(segPins[i],OUTPUT);
    digitalWrite(segPins[i],HIGH);
  }

  pinMode(modePin,INPUT);
  pinMode(subModePin,INPUT);

  for(int i=0;i<numOutputs;i++)
    for(int j=0;j<8;j++)
      seg[i][j]=LOW;
}

void display(int ms_delay)
{

  long clock = millis();
  while (millis()-clock < ms_delay)
  {
    for(int number=0;number<numOutputs;number++)
    {
      digitalWrite(cathodes[number],HIGH);
      for (int segNum=0;segNum<=8;segNum++)
      {
        if(seg[number][segNum]==HIGH)
          digitalWrite(segPins[segNum],LOW);
      }
      if(dimmer)
        delay(abs(delayFrame - ((0.0072*sliderValue)-2.3176)));
      else
        delay(delayFrame);
      digitalWrite(cathodes[number],LOW);
      if(dimmer)
        delay(abs((0.0072*sliderValue)-2.3176));
      for (int segNum=0;segNum<=8;segNum++)
      {
        digitalWrite(segPins[segNum],HIGH);
      }
    }
  }
}

int double_to_int(double a)
{
  return a;
}

double takeTemp()
{
  for(int i=numAvg-1;i>0;i--)
    pastRead[i] = pastRead[i-1];
  pastRead[0] = analogRead(tempPin);
  double avg=0;
  for(int i=0;i<numAvg;i++)
    avg += pastRead[i];
  avg = avg/numAvg;

  return avg;
}

void displayTemp(double T, boolean inCelcius)
{
  if (!inCelcius)
  {
    T=(T*(1.8)) + 32;
  }
  if (T>=10 && T <100)
  {
    changeDisplay(T/10,0);
    seg[0][7]=LOW;
    changeDisplay( double_to_int(T)%10,1);
  }
  else if (T>=0 && T < 10)
  {
    changeDisplay(T,0);
    seg[0][7]=HIGH;
    changeDisplay(double_to_int(T*10)%10,1);
  }
  /*else if (T<0 && T > -10)
  {
    changeDisplay(-1,0);
    changeDisplay(double_to_int(T),1);
  }*/
  else
  {
    changeDisplay(-1,0);
    changeDisplay(-1,1);
  }

}

void demo()
{
  for(int i=0;i<numOutputs;i++)
  {
    seg[i][0]=LOW;
    seg[i][1]=LOW;
    seg[i][2]=LOW;
    seg[i][3]=LOW;
    seg[i][4]=LOW;
    seg[i][5]=LOW;
    seg[i][6]=LOW;
    seg[i][7]=LOW;
  }
  if (subMode==0)
  {
    seg[0][5-demoCounter]=HIGH;
    demoCounter = (demoCounter+1)%6;
    seg[1][demoCounter]=HIGH;
  }
  else if (subMode==1)
  {
    demoCounter = (demoCounter+1)%10;
    if(demoCounter==0)
    {
      seg[0][4]=HIGH;
      seg[0][5]=HIGH;
    }
    else if(demoCounter==1 || demoCounter==2)
    {
      seg[demoCounter-1][0]=HIGH;
      seg[demoCounter-1][3]=HIGH;
      seg[demoCounter-1][6]=HIGH;
    }
    else if(demoCounter==3)
    {
      seg[1][1]=HIGH;
      seg[1][2]=HIGH;
    }
  }
  else if (subMode==2)
  {
    demoCounter = (demoCounter+1)%3;
    seg[0][demoCounter*3]=HIGH;
    seg[1][demoCounter*3]=HIGH;
  }
  else if (subMode==3)
  {
    demoCounter = (demoCounter+1)%12;

    if(demoCounter<6)
      for(int i=0;i<=demoCounter;i++)
      {
        seg[0][(i+1)%6]=HIGH;
        seg[1][5-i]=HIGH;
      }
    else
      for(int i=5;i>=demoCounter%6;i--)
      {
        seg[0][(i+1)%6]=HIGH;
        seg[1][5-i]=HIGH;
      }

  }
}

void chrono()
{
  if(subMode==0)//Reset
  {
    startTime=millis();
    changeDisplay(0,0);
    changeDisplay(0,1);
  }
  else if(subMode==1)//Time
  {
    currentTime=millis();
    changeDisplay(((currentTime-startTime)/1000)/10,0);
    changeDisplay(((currentTime-startTime)/1000)%10,1);
    if((currentTime-startTime)/1000>=99)
      subMode++;
  }
  else if(subMode==2)//Stop
  {
    changeDisplay(((currentTime-startTime)/1000)/10,0);
    changeDisplay(((currentTime-startTime)/1000)%10,1);
  }
}

void timer()
{
  if(subMode==0)//set digit 0
  {
    waitA=abs(-(0.013*sliderValue)+13.5);
    waitB=0;
    changeDisplay(waitA,0);
    changeDisplay(waitB,1);
  }
  else if(subMode==1)//set digit 1
  {
    waitB=abs(-(0.013*sliderValue)+13.5);
    changeDisplay(waitA,0);
    changeDisplay(waitB,1);
    waitTime=(waitA*10)+waitB;
    startTime=millis();
  }
  else if(subMode==2)//start
  {
    currentTime=millis();
    changeDisplay((waitTime-((currentTime-startTime)/1000))/10,0);
    changeDisplay((waitTime-((currentTime-startTime)/1000))%10,1);
    if((waitTime-((currentTime-startTime)/1000))<1)
      subMode++;
  }
  else if(subMode==3)//alarm(well, not really :)
  {
  }
}

void loop()
{
  modePinState = digitalRead(modePin);
  subModePinState = digitalRead(subModePin);
  sliderValue=analogRead(sliderPin);

  /*if(modePinState==HIGH)
  {
    mode = (mode + 1)%numModes;
    subMode=0;
    while(modePinState==HIGH || subModePinState==HIGH)
    {
      modePinState = digitalRead(modePin);
      subModePinState = digitalRead(subModePin);
      display(del/2);
    }
  }
  else if(subModePinState==HIGH)
  {
    subMode = (subMode + 1)%numSubModes[mode];
    while(modePinState==HIGH || subModePinState==HIGH)
    {
      modePinState = digitalRead(modePin);
      subModePinState = digitalRead(subModePin);
      display(del/2);
    }
  }*/

  if(mode==0)//temperature reading
  {
    temp = takeTemp();
    if (subMode==0)
      displayTemp(temp,celcius);
    else if (subMode=1)
      displayTemp(temp,fahrenheit);
    dimmer = on;
    display(del);
  }
  else if(mode==1)//Count Up Timer(chronograph)
  {
    chrono();
    dimmer = on;
    display(del);
  }
  else if(mode==2)//Count Down Timer
  {
    timer();
    dimmer = off;
    display(del);
  }
  else if(mode==3)//Demo Mode
  {
    demo();
    dimmer = off;
    display(sliderValue/8);
  }
}


void changeDisplay(int changeTo,int num)
{
  switch(changeTo)
  {
  case 0:
    seg[num][0]=HIGH;
    seg[num][1]=HIGH;
    seg[num][2]=HIGH;
    seg[num][3]=HIGH;
    seg[num][4]=HIGH;
    seg[num][5]=HIGH;
    seg[num][6]=LOW;
    break;
  case 1:
    seg[num][0]=LOW;
    seg[num][1]=HIGH;
    seg[num][2]=HIGH;
    seg[num][3]=LOW;
    seg[num][4]=LOW;
    seg[num][5]=LOW;
    seg[num][6]=LOW;
    break;
  case 2:
    seg[num][0]=HIGH;
    seg[num][1]=HIGH;
    seg[num][2]=LOW;
    seg[num][3]=HIGH;
    seg[num][4]=HIGH;
    seg[num][5]=LOW;
    seg[num][6]=HIGH;
    break;
  case 3:
    seg[num][0]=HIGH;
    seg[num][1]=HIGH;
    seg[num][2]=HIGH;
    seg[num][3]=HIGH;
    seg[num][4]=LOW;
    seg[num][5]=LOW;
    seg[num][6]=HIGH;
    break;
  case 4:
    seg[num][0]=LOW;
    seg[num][1]=HIGH;
    seg[num][2]=HIGH;
    seg[num][3]=LOW;
    seg[num][4]=LOW;
    seg[num][5]=HIGH;
    seg[num][6]=HIGH;
    break;
  case 5:
    seg[num][0]=HIGH;
    seg[num][1]=LOW;
    seg[num][2]=HIGH;
    seg[num][3]=HIGH;
    seg[num][4]=LOW;
    seg[num][5]=HIGH;
    seg[num][6]=HIGH;
    break;
  case 6:
    seg[num][0]=HIGH;
    seg[num][1]=LOW;
    seg[num][2]=HIGH;
    seg[num][3]=HIGH;
    seg[num][4]=HIGH;
    seg[num][5]=HIGH;
    seg[num][6]=HIGH;
    break;
  case 7:
    seg[num][0]=HIGH;
    seg[num][1]=HIGH;
    seg[num][2]=HIGH;
    seg[num][3]=LOW;
    seg[num][4]=LOW;
    seg[num][5]=LOW;
    seg[num][6]=LOW;
    break;
  case 8:
    seg[num][0]=HIGH;
    seg[num][1]=HIGH;
    seg[num][2]=HIGH;
    seg[num][3]=HIGH;
    seg[num][4]=HIGH;
    seg[num][5]=HIGH;
    seg[num][6]=HIGH;
    break;
  case 9:
    seg[num][0]=HIGH;
    seg[num][1]=HIGH;
    seg[num][2]=HIGH;
    seg[num][3]=HIGH;
    seg[num][4]=LOW;
    seg[num][5]=HIGH;
    seg[num][6]=HIGH;
    break;
  default:
    seg[num][0]=LOW;
    seg[num][1]=LOW;
    seg[num][2]=LOW;
    seg[num][3]=LOW;
    seg[num][4]=LOW;
    seg[num][5]=LOW;
    seg[num][6]=HIGH;
    seg[num][7]=LOW;
    break;
  }
}
