/*
TSJWang	8/19/2014
Receiver
Use an ATTiny85 @8MHz. 45 will not work with VirtualWire
Fuses:
	-U lfuse:w:0xe2:m
	-U hfuse:w:0xd4:m
	-U efuse:w:0xff:m
*/
#include <VirtualWire.h>	// Library needed for communication
#include <util/delay.h>		// VirtualWire doesn't like it when you use delay() or millis(), so we need this library.
const int activePin = 2;	// Connect LED and transistor to this pin
const int RXpin = 0;		// Pin connected to RF module

void setup()
{
	pinMode(activePin, OUTPUT);
	vw_set_ptt_inverted(true);	// normal setup stuff
	vw_setup(4800);				// 4800 bps
	vw_set_rx_pin(RXpin);
	vw_rx_start();
	digitalWrite(activePin, LOW);	// for safety sake
}

void loop()
{
	uint8_t buf[VW_MAX_MESSAGE_LEN];
	uint8_t buflen = VW_MAX_MESSAGE_LEN;
	
	if (vw_get_message(buf, &buflen))
	{
		if (buf[0] == 97)							//ASCII character 'a'
		{
			digitalWrite(activePin, HIGH);
			_delay_ms(125);							//this actually delays for 4 seconds. 
			digitalWrite(activePin, LOW);
		}
		else
		{
			digitalWrite(activePin, LOW);
		}
	}
	else
	{
		digitalWrite(activePin, LOW);
	}
}
