/*
TSJWang	8/19/2014
Transmitter
Use an ATTiny85 @8MHz. 45 will not work with VirtualWire
Fuses:
	-U lfuse:w:0xe2:m
	-U hfuse:w:0xd4:m
	-U efuse:w:0xff:m
*/
#include <VirtualWire.h>	// Library used for communication with RF links

const int notifPin = 0;		// LED connected to this pin
const int TXpin = 1;		// This pin connected to RF link

void setup()
{
	pinMode(notifPin, OUTPUT);
	vw_set_ptt_inverted(true);		// setup stuff
	vw_setup(4800);					// 4800 bps
	vw_set_tx_pin(TXpin);
	digitalWrite(notifPin, HIGH);	// Blink LED to show it's working
}

void loop()
{
	char *msg = "a";				// Send "a", ASCII 97.

	vw_send((uint8_t*)msg, 1);		// Sends the char
	vw_wait_tx();					// Wait until the char is sent
}
