#include <Adafruit_NeoPixel.h>
#define PIN 10 //data pin for neopixel
const int softpotPin = A0; //constant analog pin for softpot
int d = 0; //initialize serial port reading

Adafruit_NeoPixel strip = Adafruit_NeoPixel(12, PIN, NEO_GRB + NEO_KHZ800);//change 12 to number of pixels you have

void setup() {
  Serial.begin(9600); //initialize serial port to 9600 baud rate
  
  strip.begin();
  strip.setBrightness(5); //adjust brightness of pixels, 255 max
  strip.show(); // initialize all pixels to 'off'
}

void loop() {
  int softpotReading = analogRead(softpotPin); //store reading from softpot
  if (softpotReading > 26) {//if not just rainbow animation, i.e.softpot was touched
    Serial.println(softpotReading); //sends softpotReading to serial, RPi
  }
  
  int times = 25; //number of times that the colorWipe will repeat
  int fast = 30; //higher number = slower animation

  if(Serial.available() > 0) { // if something is available on serial from RPi
    d = Serial.parseInt(); //store reading in d
    if (d > 25) { //only send if would trigger animation -- stopped problem of sending 0
      //Serial.println(d); //print the reading to serial port (JUST AS A CHECK - prints as "Arduino data" on RPi)
      softpotReading = d; //store as softpotReading instead and do that animation
    }
  }
  
  if (softpotReading <=25)
      rainbow(10);
  else if (softpotReading >=26 && softpotReading <=40) {
   for(uint16_t p=0; p<times; p++) {
      colorWipe(strip.Color(0, 255,10), fast); //green
      colorWipe(strip.Color(0, 60, 5), fast);  
      if (Serial.available() > 0) {//if RPi sends something, i.e. previous != current)
        if (Serial.parseInt() != softpotReading)
          break;
        }
      else {
        int softpotReading = analogRead(softpotPin);
        if (softpotReading >40) //switch animation if another position is pressed
          break;
        }
   }
   Serial.println(10); //go back to rainbow after finished animating
  }
  else if (softpotReading >=41 && softpotReading <=100) {
   for(uint16_t p=0; p<times; p++) {
      colorWipe(strip.Color(0, 255, 255), fast); //blue
      colorWipe(strip.Color(0, 70, 70), fast);
      if (Serial.available() > 0) {
        if (Serial.parseInt() != softpotReading);
          break;
      }
      else {
        int softpotReading = analogRead(softpotPin); 
        if (softpotReading >=26 && softpotReading <=40) //switch if position below is pressed
          break;
        else if (softpotReading >100) //switch animation if position above is pressed
          break;
      }
   }
   Serial.println(10); //go back to rainbow after finished animating
  }
  else if (softpotReading >100) {
   for(uint16_t p=0; p<times; p++) {
      colorWipe(strip.Color(255, 10, 255), fast); //purple
      colorWipe(strip.Color(50, 0, 60), fast);
      if (Serial.available() > 0) {
        if (Serial.parseInt() != softpotReading);
          break;
      }
      else {
        int softpotReading = analogRead(softpotPin); 
        if (softpotReading >=26 && softpotReading <100) //switch if position below is pressed
          break;
        }
   }
   Serial.println(10); //go back to rainbow after finished animating
  }
}

// Fill the dots one after the other with a color
void colorWipe(uint32_t c, uint8_t wait) {
   for(uint16_t i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, c);
      strip.show();
      delay(wait);
    }
}

//Flash through rainbow colors
void rainbow(uint8_t wait) {
  uint16_t i, j;
  for(j=0; j<256; j++) {
    int softpotReading = analogRead(softpotPin); 
    for(i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel((i+j) & 255));
      if (softpotReading >=25) //if softpot is pressed anywhere
        break;
    }
    strip.show();
    delay(wait);
    if (softpotReading >=25) //if softpot is pressed anywhere
        break;
  }
}

//define Wheel for controlling neopixels in animation
uint32_t Wheel(byte WheelPos) {
  if(WheelPos < 85) {
   return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
  } else if(WheelPos < 170) {
   WheelPos -= 85;
   return strip.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  } else {
   WheelPos -= 170;
   return strip.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
}
