#include <Adafruit_NeoPixel.h>
#define PIN 10 //data pin for neopixel
int softpotPin = A0; //analog pin

Adafruit_NeoPixel strip = Adafruit_NeoPixel(12, PIN, NEO_GRB + NEO_KHZ800);

void setup() {
//  digitalWrite(softpotPin, HIGH); //enable pullup resistor
//  Serial.begin(9600);
  
  strip.begin();
  strip.setBrightness(5); //adjust brightness of pixels, 255 max
  strip.show(); // initialize all pixels to 'off'
}

void loop() {
  int softpotReading = analogRead(softpotPin); 
  int times = 5; //times that the colorWipe will repeat
  int fast = 30; //higher number = slower animation
  
//  Serial.println(softpotReading); //for printing sensor values in serial port
//  delay(250); //so readings of serial port update every 0.25 second

  if (softpotReading <=25)
      rainbow(10);
  else if (softpotReading >=26 && softpotReading <=40)
   for(uint16_t p=0; p<times; p++) {
      colorWipe(strip.Color(0, 255,10), fast);
      colorWipe(strip.Color(0, 60, 5), fast);
      if (softpotReading <26 | softpotReading >40)
        break;
   return;
   }
  else if (softpotReading >=41 && softpotReading <=100)
   for(uint16_t p=0; p<times; p++) {
      colorWipe(strip.Color(0, 255, 255), fast);
      colorWipe(strip.Color(0, 70, 70), fast);
      if (softpotReading <41 | softpotReading >100)
        break;
   return;
   }
  else
   for(uint16_t p=0; p<times; p++) {
      colorWipe(strip.Color(100, 10, 255), fast);
      colorWipe(strip.Color(50, 0, 60), fast);
      if (softpotReading >=100)
        return;
   }

}
 
// Fill the dots one after the other with a color
void colorWipe(uint32_t c, uint8_t wait) {
   for(uint16_t i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, c);
      strip.show();
      delay(wait);
    }
}

// Slightly different, this makes the rainbow equally distributed throughout
void rainbowCycle(uint8_t wait) {
  uint16_t i, j;
  for(j=0; j<256*5; j++) { // 5 cycles of all colors on wheel
    for(i=0; i< strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

// Slightly different, this makes the rainbow equally distributed throughout
void rainbow(uint8_t wait) {
  uint16_t i, j;
 
  for(j=0; j<256; j++) {
    int softpotReading = analogRead(softpotPin); 
    for(i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel((i+j) & 255));
      if (softpotReading >=25)
        break;
    }
    strip.show();
    delay(wait);
    if (softpotReading >=25)
        break;
  }
}

uint32_t Wheel(byte WheelPos) {
  if(WheelPos < 85) {
   return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
  } else if(WheelPos < 170) {
   WheelPos -= 85;
   return strip.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  } else {
   WheelPos -= 170;
   return strip.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
}
 
