#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "NUC1xx.h"
#include "DrvUART.h"
#include "DrvGPIO.h"
#include "DrvSYS.h"
#include "LCD_Driver.h"
uint8_t  read_buf[17];
uint8_t  i;
uint8_t  j;
char     TEXT[17];
char     TEXT1[16] = "  NUC140-Ardu  ";
char     TEXT2[16] = "   Serial Comm  ";
char     TEXT3[16] = "                ";
char     TEXT4[16] = "Data :          ";
char     SENSOR1[16] = "                ";
int 		 len;
int 		 cont;
int 		 pointer[15];
long 		 ucByte1 = 0;

/*---------Function Delay-----------------*/
void delay(void){
int j;
for(j=0;j<3000000;j++);
}
int Delay(int ms){
	while(ms--);
	return 0;}
/*---------System Restarter--------------*/
void callableMain()
{
	STR_UART_T sParam; 	
	DrvGPIO_InitFunction(E_FUNC_UART0);	// Set UART pins
  
	/* UART Setting */
  sParam.u32BaudRate 		= 9600;
  sParam.u8cDataBits 		= DRVUART_DATABITS_8;
  sParam.u8cStopBits 		= DRVUART_STOPBITS_1;
  sParam.u8cParity 		  = DRVUART_PARITY_NONE;
  sParam.u8cRxTriggerLevel= DRVUART_FIFO_1BYTES;

	/* Set UART Configuration */
 	if(DrvUART_Open(UART_PORT0,&sParam) != E_SUCCESS);
	
	DrvGPIO_SetBit(E_GPA,13);
	DrvGPIO_ClrBit(E_GPC,12);
	DrvGPIO_ClrBit(E_GPC,13);
	DrvGPIO_ClrBit(E_GPC,14);
	DrvGPIO_ClrBit(E_GPC,15);
	
	//looping program here
	DrvUART_Read (UART_PORT0, read_buf, 16);
	for(i=0;i<17;i++){
	    TEXT[i]=read_buf[i];
		}
		print_lcd(3, "                "); 
		strncpy(SENSOR1, TEXT+0, 3);
		ucByte1 = strtol(SENSOR1, NULL, 16);
		sprintf(TEXT4+6,"%02d ",ucByte1);
		print_lcd(3,TEXT4);          
  }
	
/*---------MAIN function------------------*/
/*----------------------------------------*/
int main(void){
		UNLOCKREG();
	SYSCLK->PWRCON.XTL12M_EN = 1;
	DrvSYS_Delay(1);
  DrvSYS_Open(48000000);
	LOCKREG();
	
	DrvGPIO_Open (E_GPB, 11, E_IO_OUTPUT);	//mengaktifkan Buzzer
	DrvGPIO_Open (E_GPA, 12, E_IO_OUTPUT);	//mengaktifkan RGB LED Biru
	DrvGPIO_Open (E_GPA, 13, E_IO_OUTPUT);	//mengaktifkan RGB LED Hijau
	DrvGPIO_Open (E_GPA, 14, E_IO_OUTPUT);	//mengaktifkan RGB LED Merah
	DrvGPIO_Open (E_GPC, 12, E_IO_OUTPUT);	//mengaktifkan LED1
	DrvGPIO_Open (E_GPC, 13, E_IO_OUTPUT);	//mengaktifkan LED2
	DrvGPIO_Open (E_GPC, 14, E_IO_OUTPUT);	//mengaktifkan LED3
	DrvGPIO_Open (E_GPC, 15, E_IO_OUTPUT);	//mengaktifkan LED4

	
	Initial_pannel();                       // initialize LCD panel
	clr_all_pannal();                       // clear LCD panel	
	DrvGPIO_ClrBit(E_GPD,14); 				      // mengaktifkan latar LCD 	
	print_lcd(0, "     Nuvoton    "); 
	print_lcd(1, "     NUC 140    "); 
	print_lcd(2, "                "); 
	print_lcd(3, " Adrie Sentosa  "); 
	Delay(5);									              //5 ms delay
	 while(1) {
		callableMain();
		DrvGPIO_ClrBit(E_GPA,13);
	}
	}

