#include "Servo1.h"

static int buttonPin = 6; // Our first hardware interrupt pin is digital pin 2

static int pinA = 2; // Our first hardware interrupt pin is digital pin 2
static int pinB = 3; // Our second hardware interrupt pin is digital pin 3
volatile byte aFlag = 0; // let's us know when we're expecting a rising edge on pinA to signal that the encoder has arrived at a detent
volatile byte bFlag = 0; // let's us know when we're expecting a rising edge on pinB to signal that the encoder has arrived at a detent (opposite direction to when aFlag is set)
volatile int encoderPos = 1000; //this variable stores our current value of encoder position. Change to int or uin16_t instead of byte if you want to record a larger range than 0-255
volatile byte oldEncPos = 0; //stores the last encoder position value so we can compare to the current reading and see if it has changed (so we know when to print to the serial monitor)
volatile byte reading = 0; //somewhere to store the direct values we read from our interrupt pins before checking to see if we have moved a whole detent

Servo myservo;  // create servo object to control a servo
int pos =1000;  // ESC is off
int startStop = 0;
int startPos = 1212; // ESC runs, change this value to the needed speed, read out via Terminal

 int xx = 0;

const int LED = 13;


void setup() {   

 pinMode(pinA, INPUT_PULLUP); // set pinA as an input, pulled HIGH to the logic voltage (5V or 3.3V for most cases)
  pinMode(pinB, INPUT_PULLUP); // set pinB as an input, pulled HIGH to the logic voltage (5V or 3.3V for most cases)
  attachInterrupt(0,PinA,RISING); // set an interrupt on PinA, looking for a rising edge signal and executing the "PinA" Interrupt Service Routine (below)
  attachInterrupt(1,PinB,RISING); // set an interrupt on PinB, looking for a rising edge signal and executing the "PinB" Interrupt Service Routine (below)              
 
  pinMode(buttonPin, INPUT_PULLUP);//Button Start then+
  
  pinMode(LED,OUTPUT);
 myservo.attach(11);  // attaches the servo on pin 11 to the servo object
 myservo.writeMicroseconds(1000); 
Serial.begin(19200);  





}

// the loop routine runs over and over again forever:
void loop() {


  //  pos += encoderPos;
  
xx++;

if (xx==20000){
  Serial.println(encoderPos);
  
 

 xx=0;
}


 myservo.writeMicroseconds(encoderPos);     


   
    if (digitalRead(buttonPin) == LOW) {          // ESC on
       
        

         
        
        if (startStop == 0){
          encoderPos=startPos;
          startStop = 1;
          digitalWrite(LED, HIGH);
          delay(400); 
        } 
        else {
          encoderPos=1000;
          startStop = 0;
          digitalWrite(LED, LOW); 
          delay(400); 
        }
    }

    
   

   
  
}

void PinA(){
  cli(); //stop interrupts happening before we read pin values
  reading = PIND & 0xC; // read all eight pin values then strip away all but pinA and pinB's values
  if(reading == B00001100 && aFlag) { //check that we have both pins at detent (HIGH) and that we are expecting detent on this pin's rising edge
    encoderPos --; //decrement the encoder's position count
    bFlag = 0; //reset flags for the next turn
    aFlag = 0; //reset flags for the next turn
  }
  else if (reading == B00000100) bFlag = 1; //signal that we're expecting pinB to signal the transition to detent from free rotation
  sei(); //restart interrupts
}

void PinB(){
  cli(); //stop interrupts happening before we read pin values
  reading = PIND & 0xC; //read all eight pin values then strip away all but pinA and pinB's values
  if (reading == B00001100 && bFlag) { //check that we have both pins at detent (HIGH) and that we are expecting detent on this pin's rising edge
    encoderPos ++; //increment the encoder's position count
    bFlag = 0; //reset flags for the next turn
    aFlag = 0; //reset flags for the next turn
  }
  else if (reading == B00001000) aFlag = 1; //signal that we're expecting pinA to signal the transition to detent from free rotation
  sei(); //restart interrupts
}


