/*
 * Decompiled with CFR 0.152.
 */
import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.serial.Serial;

public class RGBmtx
extends PApplet {
    PFont fontA;
    PFont fontLetter;
    Matrix matrix;
    Device device;
    int border = 10;
    int offY = 30;
    int offX = 30;
    int current_delay = 0;
    int current_speed = 5;
    int prev_speed = -1;
    int mode_record = 0;
    int mode_play = 1;
    int mode_plasma = 2;
    int mode_snow = 3;
    int mode_meteor = 4;
    int mode_music = 5;
    int mode_cnt = 6;
    int current_mode = this.mode_record;
    boolean wait_frame_queue_empty = false;
    boolean scanForDevice = true;
    boolean record = true;
    boolean color_mode = false;
    boolean rain = true;
    boolean keyCtrl = false;
    boolean keyMac = false;
    boolean keyAlt = false;
    int colorBtnStart;
    int colorBtnEnd;
    boolean update = true;
    Button[] buttons;
    int hide_button_index;

    public void setup() {
        this.frame.setIconImage(this.getToolkit().getImage("sketch.ico"));
        this.matrix = new Matrix(Config.xdim, Config.ydim);
        this.matrix.current_color.set_color(255, 0, 0);
        this.size(780, 720);
        this.smooth();
        this.noStroke();
        this.fontA = this.loadFont("Courier-Bold-32.vlw");
        this.fontLetter = this.loadFont("ArialMT-20.vlw");
        this.frameRate(15.0f);
    }

    public void setup_buttons() {
        int n;
        int n2;
        this.buttons = new Button[60];
        int n3 = 10;
        int n4 = 0;
        int n5 = 0;
        int n6 = -13421773;
        int n7 = -6710887;
        int n8 = 15;
        int n9 = 0;
        while (n9 < this.matrix.rows) {
            n2 = this.offX + this.matrix.width() + n3;
            n = this.offY + n9 * this.matrix.rad + this.matrix.border / 2;
            this.buttons[n4++] = new RectButton(n2, n, n8, this.matrix.rad - this.matrix.border, n6, n7);
            ++n9;
        }
        n9 = 0;
        while (n9 < this.matrix.cols) {
            n2 = this.offX + n9 * this.matrix.rad + this.matrix.border / 2;
            n = this.offY + this.matrix.width() + n3;
            this.buttons[n4++] = new RectButton(n2, n, this.matrix.rad - this.matrix.border, n8, n6, n7);
            ++n9;
        }
        this.buttons[n4++] = new SquareButton(this.offX + this.matrix.width() + n3, this.offY + this.matrix.width() + n3, n8, n6, n7);
        n9 = this.offX + this.matrix.width() + n3 + 30;
        this.buttons[n4++] = new ModeButton("Mode: ", "10", n9, n5 += 30);
        this.buttons[n4++] = new ActionToggleButton("Device: SLAVE", "Device: FREE", "a+10", n9, n5 += 30);
        if (!(this.device instanceof StandaloneDevice) || !this.device.enabled()) {
            this.buttons[n4 - 1].disable();
        }
        this.buttons[n4++] = new FrameChooser(this.offX, this.offY + this.matrix.height() + 65, 59, 10);
        this.hide_button_index = n4;
        this.buttons[n4++] = new TextElement("Load from:", n9, n5 += 30);
        this.buttons[n4++] = new ActionButton("File", "m+L", n9, n5 += 30, 65, 25);
        this.buttons[n4++] = new TextElement("Save to:", n9, n5 += 30);
        this.buttons[n4++] = new ActionButton("File", "m+S", n9, n5 += 30, 65, 25);
        this.buttons[n4++] = new ActionButton("Device", "a+S", n9 + 67, n5, 65, 25);
        if (!(this.device instanceof StandaloneDevice) || !this.device.enabled()) {
            this.buttons[n4 - 1].disable();
        }
        this.buttons[n4++] = new TextElement("Color:", n9, n5 += 40);
        this.colorBtnStart = n4;
        n2 = 17;
        PixelColor pixelColor = new PixelColor(0, 0, 0);
        int n10 = 0;
        this.buttons[n4++] = new MiniColorButton(n9 + n10++ * n2, n5 += 30, n2, 20, pixelColor);
        pixelColor = new PixelColor(255, 0, 0);
        this.buttons[n4++] = new MiniColorButton(n9 + n10++ * n2, n5, n2, 20, pixelColor);
        pixelColor = new PixelColor(0, 255, 0);
        this.buttons[n4++] = new MiniColorButton(n9 + n10++ * n2, n5, n2, 20, pixelColor);
        pixelColor = new PixelColor(0, 0, 255);
        this.buttons[n4++] = new MiniColorButton(n9 + n10++ * n2, n5, n2, 20, pixelColor);
        pixelColor = new PixelColor(255, 255, 0);
        this.buttons[n4++] = new MiniColorButton(n9 + n10++ * n2, n5, n2, 20, pixelColor);
        pixelColor = new PixelColor(0, 255, 255);
        this.buttons[n4++] = new MiniColorButton(n9 + n10++ * n2, n5, n2, 20, pixelColor);
        pixelColor = new PixelColor(255, 0, 255);
        this.buttons[n4++] = new MiniColorButton(n9 + n10++ * n2, n5, n2, 20, pixelColor);
        pixelColor = new PixelColor(255, 255, 255);
        this.buttons[n4++] = new MiniColorButton(n9 + n10++ * n2, n5, n2, 20, pixelColor);
        this.colorBtnEnd = n4;
        this.buttons[n4++] = new TextElement("Frame:", n9, n5 += 20);
        this.buttons[n4++] = new ActionButton("Add", " ", n9, n5 += 30);
        this.buttons[n4++] = new ActionButton("Delete", "D", n9, n5 += 30);
        this.buttons[n4++] = new ActionButton("^", "c+38", n9 + 47, n5 += 50, 40, 25);
        this.buttons[n4++] = new ActionButton("<", "c+37", n9, n5 += 20, 40, 25);
        this.buttons[n4++] = new ActionButton(">", "c+39", n9 + 94, n5, 40, 25);
        this.buttons[n4++] = new ActionButton("v", "c+40", n9 + 47, n5 += 15, 40, 25);
        this.buttons[n4++] = new ActionButton("Paste", "m+V", n9, n5 += 50);
        this.buttons[n4++] = new ActionButton("Copy", "m+C", n9, n5 += 30);
        this.buttons[n4++] = new ActionButton("Fill", "F", n9, n5 += 30);
        this.buttons[n4++] = new ActionButton("Clear", "X", n9, n5 += 30);
    }

    public void draw() {
        if (this.scanForDevice) {
            this.device = new ColorduinoDevice(this);
            this.device.setColorScheme();
            if (this.device.enabled()) {
                ((ColorduinoDevice)this.device).setModePlayFrame();
            }
            this.setup_buttons();
            this.scanForDevice = false;
        }
        if (this.update) {
            this.background(45);
            this.fill(50);
            this.rect(this.offX - this.matrix.border / 2, this.offY - this.matrix.border / 2, this.matrix.width() + this.matrix.border, this.matrix.height() + this.matrix.border);
            this.image((PImage)this.matrix.current_frame_image(), this.offX, this.offY);
            int n = 0;
            while (n < this.buttons.length) {
                if (this.buttons[n] == null) break;
                this.buttons[n].display();
                ++n;
            }
            this.fill(255);
            if (!this.record) {
                this.text("Speed: " + this.current_speed, this.offX + this.matrix.width() + 65, 110.0f);
            }
            if (!this.device.enabled()) {
                this.text("No output device found, running in standalone mode", 120.0f, 20.0f);
            }
            this.device.write_frame(this.matrix.current_frame());
            this.update = false;
        }
        if (!this.record && this.current_mode != this.mode_plasma) {
            this.next_frame();
        }
    }

    public void next_frame() {
        if (this.wait_frame_queue_empty) {
            if (((ColorduinoDevice)this.device).waitForResponse() != -1) {
                this.wait_frame_queue_empty = false;
            }
        } else {
            if (this.current_delay < 1) {
                this.current_delay = this.current_speed;
                if (this.current_mode == this.mode_snow) {
                    this.matrix.snow();
                } else if (this.current_mode == this.mode_meteor) {
                    this.matrix.meteor();
                } else {
                    this.matrix.next_frame();
                }
                this.mark_for_update();
            }
            --this.current_delay;
        }
    }

    public void mouseDragged() {
        if (!this.record) {
            return;
        }
        if (this.matrix.click(this.mouseX - this.offX, this.mouseY - this.offY, true)) {
            this.mark_for_update();
        }
    }

    public void mousePressed() {
        if (!this.record) {
            return;
        }
        if (this.matrix.click(this.mouseX - this.offX, this.mouseY - this.offY, false)) {
            this.mark_for_update();
        }
    }

    public void mouseMoved() {
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n] == null) break;
            if (this.buttons[n].over()) {
                this.mark_for_update();
            }
            ++n;
        }
    }

    public void mouseClicked() {
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n] == null) break;
            if (this.buttons[n].clicked()) {
                this.mark_for_update();
            }
            ++n;
        }
    }

    public void keyPressed() {
        if (this.keyCode == 17) {
            this.keyCtrl = true;
        }
        if (this.keyCode == 18) {
            this.keyAlt = true;
        }
        if (this.keyCode == 157) {
            this.keyMac = true;
        }
        if (this.keyCode == 67) {
            this.color_mode = true;
        }
        if (this.color_mode) {
            this.mark_for_update();
            return;
        }
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n] == null) break;
            if (this.buttons[n].key_pressed(this.keyCode, this.keyMac, this.keyCtrl, this.keyAlt)) {
                this.mark_for_update();
                return;
            }
            ++n;
        }
        if (this.keyAlt) {
            if (this.device instanceof StandaloneDevice) {
                if (this.keyCtrl) {
                    if (this.keyCode == 37) {
                        ((StandaloneDevice)((Object)this.device)).brightnessDown();
                    }
                    if (this.keyCode == 39) {
                        ((StandaloneDevice)((Object)this.device)).brightnessUp();
                    }
                } else {
                    if (this.keyCode == 37) {
                        ((StandaloneDevice)((Object)this.device)).speedUp();
                    }
                    if (this.keyCode == 39) {
                        ((StandaloneDevice)((Object)this.device)).speedDown();
                    }
                }
            }
        } else {
            if (this.keyCtrl) {
                PixelColor pixelColor = null;
                if (this.keyCode >= 48) {
                    pixelColor = this.matrix.current_frame().set_letter(PApplet.parseChar((int)this.keyCode), this.fontLetter, this.matrix.current_color);
                }
                if (pixelColor != null) {
                    this.matrix.current_color = pixelColor;
                    this.mark_for_update();
                }
                return;
            }
            if (!this.record && this.current_mode != this.mode_music) {
                if (this.keyCode == 40) {
                    this.speed_up();
                }
                if (this.keyCode == 38) {
                    this.speed_down();
                }
            }
        }
    }

    public void keyReleased() {
        if (this.keyCode == 17) {
            this.keyCtrl = false;
        }
        if (this.keyCode == 18) {
            this.keyAlt = false;
        }
        if (this.keyCode == 157) {
            this.keyMac = false;
        }
        if (this.keyCode == 67) {
            this.color_mode = false;
        }
    }

    public void mark_for_update() {
        this.update = true;
    }

    public void toggle_mode() {
        this.matrix.current_frame_nr = 0;
        this.record = !this.record;
        int n = this.hide_button_index;
        while (n < this.buttons.length) {
            if (this.buttons[n] == null) break;
            if (this.record) {
                this.buttons[n].toggle();
            } else {
                this.buttons[n].hide();
            }
            ++n;
        }
        if (this.record) {
            this.buttons[this.hide_button_index - 1].enable();
        } else {
            this.buttons[this.hide_button_index - 1].disable();
        }
    }

    public void set_mode(int n) {
        this.wait_frame_queue_empty = false;
        if (this.current_mode == this.mode_snow && n != this.mode_snow || this.current_mode == this.mode_meteor && n != this.mode_meteor) {
            this.matrix.delete_first_frame();
        }
        this.current_mode = n;
        this.record = n == this.mode_record;
        if (n == this.mode_snow || n == this.mode_meteor) {
            this.matrix.insert_first_frame();
        }
        this.matrix.current_frame_nr = 0;
        int n2 = this.hide_button_index;
        while (n2 < this.buttons.length) {
            if (this.buttons[n2] == null) break;
            if (n == 0) {
                this.buttons[n2].enable();
                this.buttons[n2].show();
            } else {
                this.buttons[n2].hide();
            }
            ++n2;
        }
        if (n == this.mode_record) {
            this.buttons[this.hide_button_index - 1].enable();
        } else {
            this.buttons[this.hide_button_index - 1].disable();
        }
        if (this.prev_speed != -1) {
            this.current_speed = this.prev_speed;
            this.prev_speed = -1;
        }
        if (this.device.enabled()) {
            if (n == this.mode_plasma) {
                ((ColorduinoDevice)this.device).setModePlasma();
            } else if (n == this.mode_music) {
                this.prev_speed = this.current_speed;
                this.current_speed = -1;
                ((ColorduinoDevice)this.device).setModeMusicSync();
            } else {
                ((ColorduinoDevice)this.device).setModePlayFrame();
            }
        }
        if (n == this.mode_snow || n == this.mode_meteor) {
            this.prev_speed = this.current_speed;
            this.current_speed = 1;
        }
    }

    public void speed_up() {
        if (this.current_speed <= 0) {
            return;
        }
        --this.current_speed;
    }

    public void speed_down() {
        ++this.current_speed;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#F0F0F0", "RGBmtx"});
    }

    class ActionButton
    extends TextButton {
        ActionButton(String string, String string2, int n, int n2) {
            this(string, string2, n, n2, 134, 25, -12303292, -6710887);
        }

        ActionButton(String string, String string2, int n, int n2, int n3, int n4) {
            this(string, string2, n, n2, n3, n4, -12303292, -6710887);
        }

        ActionButton(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6) {
            super(string, n, n2, n3, n4, n5, n6);
            this.shortcut = string2;
        }

        public boolean clicked() {
            if (!super.clicked()) {
                return false;
            }
            this.perform_action();
            return true;
        }

        public boolean key_pressed(int n, boolean bl, boolean bl2, boolean bl3) {
            if (!super.key_pressed(n, bl, bl2, bl3)) {
                return false;
            }
            String string = "";
            if (bl) {
                string = "m+" + string;
            }
            if (bl2) {
                string = "c+" + string;
            }
            if (bl3) {
                string = "a+" + string;
            }
            if (!this.shortcut.equals(String.valueOf(string) + PApplet.parseChar((int)n)) && !this.shortcut.equals(String.valueOf(string) + n)) {
                return false;
            }
            this.perform_action();
            return true;
        }

        protected void perform_action() {
            if (this.button_text == "^") {
                RGBmtx.this.matrix.current_frame().shift_up();
            }
            if (this.button_text == "v") {
                RGBmtx.this.matrix.current_frame().shift_down();
            }
            if (this.button_text == "<") {
                RGBmtx.this.matrix.current_frame().shift_left();
            }
            if (this.button_text == ">") {
                RGBmtx.this.matrix.current_frame().shift_right();
            }
            if (this.shortcut == "m+L") {
                RGBmtx.this.matrix = RGBmtx.this.matrix.load_from_file();
                RGBmtx.this.keyMac = false;
            }
            if (this.shortcut == "m+S") {
                RGBmtx.this.matrix.save_to_file();
                RGBmtx.this.keyMac = false;
            }
            if (this.shortcut == "a+L" && RGBmtx.this.device instanceof StandaloneDevice) {
                RGBmtx.this.matrix = ((StandaloneDevice)((Object)RGBmtx.this.device)).read_matrix();
            }
            if (this.shortcut == "a+S" && RGBmtx.this.device instanceof StandaloneDevice) {
                ((StandaloneDevice)((Object)RGBmtx.this.device)).write_matrix(RGBmtx.this.matrix);
            }
            if (this.button_text == "Add") {
                RGBmtx.this.matrix.add_frame();
            }
            if (this.button_text == "Delete") {
                RGBmtx.this.matrix.delete_frame();
            }
            if (this.button_text == "Copy") {
                RGBmtx.this.matrix.copy_frame();
            }
            if (this.button_text == "Paste") {
                RGBmtx.this.matrix.paste_frame();
            }
            if (this.button_text == "Fill") {
                RGBmtx.this.matrix.current_frame().fill(RGBmtx.this.matrix.current_color);
            }
            if (this.button_text == "Clear") {
                RGBmtx.this.matrix.current_frame().clear();
            }
            if (this.button_text == "Plasma" && RGBmtx.this.device instanceof StandaloneDevice) {
                ((ColorduinoDevice)RGBmtx.this.device).setModePlasma();
            }
            if (this.button_text == "Fill" && RGBmtx.this.device instanceof StandaloneDevice) {
                ((ColorduinoDevice)RGBmtx.this.device).setModeFill();
            }
        }
    }

    class ActionToggleButton
    extends ActionButton {
        String button_text2;
        boolean locked;

        ActionToggleButton(String string, String string2, String string3, int n, int n2) {
            this(string, string2, string3, n, n2, 134, 25, -12303292, -6710887);
        }

        ActionToggleButton(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, int n6) {
            super(string, string3, n, n2, n3, n4, n5, n6);
            this.locked = false;
            this.button_text2 = string2;
        }

        protected String current_text() {
            return this.locked ? this.button_text2 : this.button_text;
        }

        protected void perform_action() {
            if (this.shortcut == "10") {
                this.locked = !this.locked;
                RGBmtx.this.toggle_mode();
            }
            if (this.shortcut == "a+10" && RGBmtx.this.device instanceof StandaloneDevice) {
                this.locked = !this.locked;
                ((StandaloneDevice)((Object)RGBmtx.this.device)).toggle();
            }
        }
    }

    class Button
    extends GuiElement {
        public int highlightcolor;
        boolean over;
        String shortcut;

        Button(int n, int n2, int n3, int n4) {
            super(n, n2, n3);
            this.over = false;
            this.shortcut = null;
            this.highlightcolor = n4;
        }

        public boolean clicked() {
            return this.over && !this.disabled;
        }

        public boolean key_pressed(int n, boolean bl, boolean bl2, boolean bl3) {
            return this.shortcut != null && !this.disabled;
        }

        public boolean over() {
            return false;
        }

        protected int current_color() {
            return this.over && !this.disabled ? this.highlightcolor : this.basecolor;
        }

        protected boolean overRect(int n, int n2, int n3, int n4) {
            return RGBmtx.this.mouseX >= n && RGBmtx.this.mouseX <= n + n3 && RGBmtx.this.mouseY >= n2 && RGBmtx.this.mouseY <= n2 + n4;
        }

        protected boolean overCircle(int n, int n2, int n3) {
            float f = n - RGBmtx.this.mouseX;
            float f2 = n2 - RGBmtx.this.mouseY;
            return RGBmtx.sqrt((float)(RGBmtx.sq((float)f) + RGBmtx.sq((float)f2))) < (float)(n3 / 2);
        }
    }

    class CircleButton
    extends Button {
        int size;

        CircleButton(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n4, n5);
            this.size = n3;
        }

        public boolean over() {
            boolean bl = this.over;
            this.over = this.overCircle(this.x, this.y, this.size);
            return this.over ^ bl;
        }

        public boolean display() {
            if (!super.display()) {
                return false;
            }
            RGBmtx.this.ellipse(this.x, this.y, this.size, this.size);
            return true;
        }
    }

    class ColorButton
    extends RectButton {
        ColorButton(int n, int n2) {
            this(n, n2, 134, 25);
        }

        ColorButton(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4, RGBmtx.this.matrix.current_color.get_color(), RGBmtx.this.matrix.current_color.get_color());
        }

        protected int current_color() {
            return RGBmtx.this.matrix.current_color.get_color();
        }

        public boolean pressed() {
            return this.over;
        }
    }

    class ColorduinoDevice
    implements Device,
    StandaloneDevice {
        PApplet app;
        byte curError = 0;
        int baud = 57600;
        Serial port;
        String port_name;
        private byte SYNC_BYTE = (byte)-86;
        private byte OPC_PING = 1;
        private byte OPC_PLAY_FRAME = (byte)2;
        private byte OPC_QUEUE_FRAME = (byte)3;
        private byte OPC_SET_MODE = (byte)4;
        private byte OPC_FILL = (byte)5;
        byte CMODE_PLASMA = 1;
        byte CMODE_PLAY_FRAME = (byte)2;
        byte CMODE_MUSIC_SYNC = (byte)3;
        byte CMODE_FILL = (byte)4;
        private int[] gammaTab;
        public boolean running;
        int bright;
        int rotate;

        public boolean connected() {
            return this.port != null;
        }

        public int waitForResponse() {
            int n = 100;
            while (this.port.available() < 1) {
                RGBmtx.this.delay(1);
                if (n-- > 0) continue;
                return -1;
            }
            this.curError = (byte)this.port.read();
            return this.curError;
        }

        public int ping() {
            byte[] byArray = new byte[]{this.SYNC_BYTE, this.OPC_PING, 0, this.OPC_PING};
            this.port.clear();
            this.port.write(byArray);
            int n = this.waitForResponse();
            return n;
        }

        private boolean openPort(String string, boolean bl) {
            String[] stringArray = Serial.list();
            int n = 0;
            while (this.port == null && n < stringArray.length) {
                block5: {
                    try {
                        this.port_name = stringArray[n];
                        this.port = new Serial(this.app, this.port_name, this.baud);
                        this.port.buffer(1);
                        RGBmtx.this.delay(250);
                        if (this.ping() == -1) {
                            this.port.stop();
                            this.port = null;
                            break block5;
                        }
                        RGBmtx.print((String)"Found a Colorduino on: ");
                        RGBmtx.println((String)this.port_name);
                        return true;
                    }
                    catch (Exception exception) {}
                }
                ++n;
            }
            if (this.port == null) {
                RGBmtx.println((String)"No Colorduino found!");
            }
            return false;
        }

        public void initPort(String string, int n, boolean bl) {
            if (n > 0) {
                this.baud = n;
            }
            this.openPort(string, bl);
        }

        ColorduinoDevice(PApplet pApplet) {
            this(pApplet, null, 0);
        }

        ColorduinoDevice(PApplet pApplet, String string) {
            this(pApplet, string, 0);
        }

        ColorduinoDevice(PApplet pApplet, int n) {
            this(pApplet, null, n);
        }

        ColorduinoDevice(PApplet pApplet, String string, int n) {
            int[] nArray = new int[264];
            nArray[44] = 16;
            nArray[45] = 16;
            nArray[46] = 16;
            nArray[47] = 16;
            nArray[48] = 16;
            nArray[49] = 16;
            nArray[50] = 16;
            nArray[51] = 16;
            nArray[52] = 16;
            nArray[53] = 16;
            nArray[54] = 16;
            nArray[55] = 16;
            nArray[56] = 16;
            nArray[57] = 16;
            nArray[58] = 16;
            nArray[59] = 16;
            nArray[60] = 16;
            nArray[61] = 16;
            nArray[62] = 16;
            nArray[63] = 16;
            nArray[64] = 16;
            nArray[65] = 16;
            nArray[66] = 16;
            nArray[67] = 16;
            nArray[68] = 16;
            nArray[69] = 16;
            nArray[70] = 16;
            nArray[71] = 16;
            nArray[72] = 16;
            nArray[73] = 16;
            nArray[74] = 16;
            nArray[75] = 16;
            nArray[76] = 16;
            nArray[77] = 16;
            nArray[78] = 16;
            nArray[79] = 16;
            nArray[80] = 32;
            nArray[81] = 32;
            nArray[82] = 32;
            nArray[83] = 32;
            nArray[84] = 32;
            nArray[85] = 32;
            nArray[86] = 32;
            nArray[87] = 32;
            nArray[88] = 32;
            nArray[89] = 32;
            nArray[90] = 32;
            nArray[91] = 32;
            nArray[92] = 32;
            nArray[93] = 32;
            nArray[94] = 32;
            nArray[95] = 32;
            nArray[96] = 32;
            nArray[97] = 32;
            nArray[98] = 32;
            nArray[99] = 32;
            nArray[100] = 32;
            nArray[101] = 32;
            nArray[102] = 32;
            nArray[103] = 32;
            nArray[104] = 32;
            nArray[105] = 32;
            nArray[106] = 32;
            nArray[107] = 32;
            nArray[108] = 32;
            nArray[109] = 32;
            nArray[110] = 32;
            nArray[111] = 32;
            nArray[112] = 32;
            nArray[113] = 32;
            nArray[114] = 32;
            nArray[115] = 32;
            nArray[116] = 48;
            nArray[117] = 48;
            nArray[118] = 48;
            nArray[119] = 48;
            nArray[120] = 48;
            nArray[121] = 48;
            nArray[122] = 48;
            nArray[123] = 48;
            nArray[124] = 48;
            nArray[125] = 48;
            nArray[126] = 48;
            nArray[127] = 48;
            nArray[128] = 48;
            nArray[129] = 48;
            nArray[130] = 48;
            nArray[131] = 48;
            nArray[132] = 48;
            nArray[133] = 48;
            nArray[134] = 48;
            nArray[135] = 48;
            nArray[136] = 48;
            nArray[137] = 48;
            nArray[138] = 48;
            nArray[139] = 48;
            nArray[140] = 64;
            nArray[141] = 64;
            nArray[142] = 64;
            nArray[143] = 64;
            nArray[144] = 64;
            nArray[145] = 64;
            nArray[146] = 64;
            nArray[147] = 64;
            nArray[148] = 64;
            nArray[149] = 64;
            nArray[150] = 64;
            nArray[151] = 64;
            nArray[152] = 64;
            nArray[153] = 64;
            nArray[154] = 64;
            nArray[155] = 64;
            nArray[156] = 64;
            nArray[157] = 64;
            nArray[158] = 64;
            nArray[159] = 64;
            nArray[160] = 64;
            nArray[161] = 64;
            nArray[162] = 64;
            nArray[163] = 64;
            nArray[164] = 64;
            nArray[165] = 64;
            nArray[166] = 64;
            nArray[167] = 64;
            nArray[168] = 80;
            nArray[169] = 80;
            nArray[170] = 80;
            nArray[171] = 80;
            nArray[172] = 80;
            nArray[173] = 80;
            nArray[174] = 80;
            nArray[175] = 80;
            nArray[176] = 80;
            nArray[177] = 80;
            nArray[178] = 80;
            nArray[179] = 80;
            nArray[180] = 80;
            nArray[181] = 80;
            nArray[182] = 80;
            nArray[183] = 80;
            nArray[184] = 96;
            nArray[185] = 96;
            nArray[186] = 96;
            nArray[187] = 96;
            nArray[188] = 96;
            nArray[189] = 96;
            nArray[190] = 96;
            nArray[191] = 96;
            nArray[192] = 96;
            nArray[193] = 96;
            nArray[194] = 96;
            nArray[195] = 96;
            nArray[196] = 96;
            nArray[197] = 96;
            nArray[198] = 96;
            nArray[199] = 96;
            nArray[200] = 112;
            nArray[201] = 112;
            nArray[202] = 112;
            nArray[203] = 112;
            nArray[204] = 112;
            nArray[205] = 112;
            nArray[206] = 112;
            nArray[207] = 112;
            nArray[208] = 128;
            nArray[209] = 128;
            nArray[210] = 128;
            nArray[211] = 128;
            nArray[212] = 128;
            nArray[213] = 128;
            nArray[214] = 128;
            nArray[215] = 128;
            nArray[216] = 144;
            nArray[217] = 144;
            nArray[218] = 144;
            nArray[219] = 144;
            nArray[220] = 144;
            nArray[221] = 144;
            nArray[222] = 144;
            nArray[223] = 144;
            nArray[224] = 160;
            nArray[225] = 160;
            nArray[226] = 160;
            nArray[227] = 160;
            nArray[228] = 160;
            nArray[229] = 160;
            nArray[230] = 160;
            nArray[231] = 160;
            nArray[232] = 176;
            nArray[233] = 176;
            nArray[234] = 176;
            nArray[235] = 176;
            nArray[236] = 176;
            nArray[237] = 176;
            nArray[238] = 176;
            nArray[239] = 176;
            nArray[240] = 192;
            nArray[241] = 192;
            nArray[242] = 192;
            nArray[243] = 192;
            nArray[244] = 192;
            nArray[245] = 192;
            nArray[246] = 192;
            nArray[247] = 192;
            nArray[248] = 208;
            nArray[249] = 208;
            nArray[250] = 208;
            nArray[251] = 208;
            nArray[252] = 224;
            nArray[253] = 224;
            nArray[254] = 224;
            nArray[255] = 224;
            nArray[256] = 240;
            nArray[257] = 240;
            nArray[258] = 240;
            nArray[259] = 240;
            nArray[260] = 240;
            nArray[261] = 255;
            nArray[262] = 255;
            nArray[263] = 255;
            this.gammaTab = nArray;
            this.bright = 4;
            this.rotate = 1;
            this.app = pApplet;
            this.initPort(string, n, true);
            this.running = false;
        }

        public void setColorScheme() {
        }

        public boolean draw_as_circle() {
            return false;
        }

        public boolean enabled() {
            return this.connected();
        }

        private void send(int n) {
            if (!this.connected()) {
                return;
            }
            this.port.write((int)((byte)n));
        }

        public void write_frame(Frame frame) {
            this.write_frame(0, frame);
        }

        public int setModePlasma() {
            return this.set_mode(this.CMODE_PLASMA);
        }

        public int setModeMusicSync() {
            return this.set_mode(this.CMODE_MUSIC_SYNC);
        }

        public int setModePlayFrame() {
            return this.set_mode(this.CMODE_PLAY_FRAME);
        }

        public int setModeFill() {
            return this.set_mode(this.CMODE_FILL);
        }

        public int set_mode(byte by) {
            byte[] byArray;
            byArray = new byte[]{this.SYNC_BYTE, this.OPC_SET_MODE, 1, by, (byte)(byArray[1] + byArray[2] + byArray[3])};
            this.port.clear();
            this.port.write(byArray);
            int n = this.waitForResponse();
            return n;
        }

        public void write_frame(int n, Frame frame) {
            int n2;
            if (frame == null || this.running || !this.enabled()) {
                return;
            }
            byte[] byArray = new byte[100];
            int n3 = 0;
            byArray[n3++] = this.SYNC_BYTE;
            byArray[n3++] = RGBmtx.this.current_mode == RGBmtx.this.mode_music ? this.OPC_QUEUE_FRAME : this.OPC_PLAY_FRAME;
            byArray[n3++] = 96;
            byte by = (byte)(byArray[1] + byArray[2]);
            if (this.rotate == 1) {
                n2 = 0;
                while (n2 < frame.rows) {
                    int n4 = 0;
                    while (n4 < frame.cols) {
                        PixelColor pixelColor = frame.get_pixel(n2, n4);
                        int n5 = pixelColor.r >> 4 & 0xF;
                        int n6 = pixelColor.g >> 4 & 0xF;
                        int n7 = pixelColor.b >> 4 & 0xF;
                        int n8 = n5 << 4 | n6;
                        by = (byte)(by + n8);
                        byArray[n3++] = (byte)n8;
                        n8 = n7 << 4;
                        pixelColor = frame.get_pixel(n2, ++n4);
                        n5 = this.gammaTab[pixelColor.r] >> 4 & 0xF;
                        n6 = this.gammaTab[pixelColor.g] >> 4 & 0xF;
                        n7 = this.gammaTab[pixelColor.b] >> 4 & 0xF;
                        by = (byte)(by + (n8 |= n5));
                        byArray[n3++] = (byte)n8;
                        n8 = n6 << 4 | n7;
                        by = (byte)(by + n8);
                        byArray[n3++] = (byte)n8;
                        ++n4;
                    }
                    ++n2;
                }
            } else {
                n2 = frame.rows - 1;
                while (n2 >= 0) {
                    int n9 = 0;
                    while (n9 < frame.cols) {
                        PixelColor pixelColor = frame.get_pixel(n9, n2);
                        int n10 = pixelColor.r >> 4 & 0xF;
                        int n11 = pixelColor.g >> 4 & 0xF;
                        int n12 = pixelColor.b >> 4 & 0xF;
                        int n13 = n10 << 4 | n11;
                        by = (byte)(by + n13);
                        byArray[n3++] = (byte)n13;
                        n13 = n12 << 4;
                        pixelColor = frame.get_pixel(++n9, n2);
                        n10 = this.gammaTab[pixelColor.r] >> 4 & 0xF;
                        n11 = this.gammaTab[pixelColor.g] >> 4 & 0xF;
                        n12 = this.gammaTab[pixelColor.b] >> 4 & 0xF;
                        by = (byte)(by + (n13 |= n10));
                        byArray[n3++] = (byte)n13;
                        n13 = n11 << 4 | n12;
                        by = (byte)(by + n13);
                        byArray[n3++] = (byte)n13;
                        ++n9;
                    }
                    --n2;
                }
            }
            byArray[n3] = by;
            this.port.clear();
            this.port.write(byArray);
            n2 = this.waitForResponse();
            if (RGBmtx.this.current_mode == RGBmtx.this.mode_music && n2 == -1) {
                RGBmtx.this.wait_frame_queue_empty = true;
            }
        }

        public void write_matrix(Matrix matrix) {
            RGBmtx.print((String)"Start Writing Matrix - ");
            int n = 0;
            while (n < matrix.num_frames()) {
                this.write_frame(n, matrix.frame(n));
                ++n;
            }
            RGBmtx.println((String)"Done");
        }

        public Matrix read_matrix() {
            Matrix matrix = new Matrix(8, 8);
            return matrix;
        }

        public void toggle() {
            if (this.running) {
                this.running = false;
                return;
            }
            this.running = true;
        }

        public void speedUp() {
        }

        public void speedDown() {
        }

        public void brightnessUp() {
        }

        public void brightnessDown() {
        }
    }

    public static class Config {
        public static int xdim = 8;
        public static int ydim = 8;
        public static boolean rgbmode = true;
    }

    public static interface Device {
        public void setColorScheme();

        public boolean draw_as_circle();

        public boolean enabled();

        public void write_frame(Frame var1);
    }

    class Frame {
        PGraphics pg = null;
        int letter_scale = 3;
        PixelColor[] pixs = null;
        PGraphics frame = null;
        PGraphics thumb = null;
        public int rows = 0;
        public int cols = 0;
        int last_y = 0;
        int last_x = 0;

        Frame(int n, int n2) {
            this.cols = n;
            this.rows = n2;
            this.pixs = new PixelColor[n2 * n];
            this.clear();
            this.pg = RGBmtx.this.createGraphics(8 * this.letter_scale, 10 * this.letter_scale, "processing.core.PGraphics2D");
        }

        public PGraphics draw_full(int n, int n2) {
            if (this.frame == null) {
                this.frame = this.draw_canvas(n, n2);
            }
            return this.frame;
        }

        public PGraphics draw_thumb(int n, int n2) {
            if (this.thumb == null) {
                this.thumb = this.draw_canvas(n, n2);
            }
            return this.thumb;
        }

        public PGraphics draw_canvas(int n, int n2) {
            PGraphics pGraphics = RGBmtx.this.createGraphics(this.cols * n, this.rows * n, "processing.core.PGraphics2D");
            pGraphics.beginDraw();
            pGraphics.background(55);
            pGraphics.smooth();
            pGraphics.noStroke();
            pGraphics.rectMode(3);
            int n3 = 0;
            while (n3 < this.rows) {
                int n4 = 0;
                while (n4 < this.cols) {
                    pGraphics.fill(this.get_pixel(n4, n3).get_color());
                    if (RGBmtx.this.device.draw_as_circle()) {
                        pGraphics.ellipse((float)n * ((float)n4 + 0.5f), (float)n * ((float)n3 + 0.5f), (float)(n - RGBmtx.this.border), (float)(n - RGBmtx.this.border));
                    } else {
                        pGraphics.rect((float)n * ((float)n4 + 0.5f), (float)n * ((float)n3 + 0.5f), (float)(n - RGBmtx.this.border), (float)(n - RGBmtx.this.border));
                    }
                    ++n4;
                }
                ++n3;
            }
            pGraphics.endDraw();
            return pGraphics;
        }

        public void clear() {
            this.set_pixels(new PixelColor());
        }

        public void fill(PixelColor pixelColor) {
            this.set_pixels(pixelColor);
        }

        public void set_pixels(PixelColor pixelColor) {
            int n = 0;
            while (n < this.rows) {
                int n2 = 0;
                while (n2 < this.cols) {
                    this.set_pixel(n2, n, pixelColor);
                    ++n2;
                }
                ++n;
            }
        }

        public void set_pixels(PixelColor[] pixelColorArray) {
            int n = 0;
            while (n < this.rows) {
                int n2 = 0;
                while (n2 < this.cols) {
                    this.set_pixel(n2, n, pixelColorArray[this.pos(n2, n)]);
                    ++n2;
                }
                ++n;
            }
        }

        public PixelColor get_pixel(int n, int n2) {
            if (n < 0 || n2 < 0 || n > RGBmtx.this.width || n2 > RGBmtx.this.height) {
                return null;
            }
            return this.pixs[this.pos(n, n2)];
        }

        public PixelColor set_row(int n, PixelColor pixelColor) {
            int n2 = 0;
            while (n2 < this.cols) {
                pixelColor = this.set_colored_pixel(n2, n, pixelColor);
                ++n2;
            }
            return pixelColor;
        }

        public PixelColor set_col(int n, PixelColor pixelColor) {
            int n2 = 0;
            while (n2 < this.rows) {
                pixelColor = this.set_colored_pixel(n, n2, pixelColor);
                ++n2;
            }
            return pixelColor;
        }

        public PixelColor set_colored_pixel(int n, int n2, PixelColor pixelColor) {
            if (n >= this.cols) {
                return this.set_row(n2, pixelColor);
            }
            if (n2 >= this.rows) {
                return this.set_col(n, pixelColor);
            }
            if (this.get_pixel(n, n2).equal(pixelColor)) {
                this.frame = null;
                this.thumb = null;
                return this.get_pixel(n, n2);
            }
            return this.set_pixel(n, n2, pixelColor);
        }

        public PixelColor set_pixel(int n, int n2, PixelColor pixelColor) {
            if (pixelColor == null) {
                pixelColor = new PixelColor();
            }
            if (this.get_pixel(n, n2) != null) {
                this.get_pixel(n, n2).set_color(pixelColor);
            } else {
                this.pixs[this.pos((int)n, (int)n2)] = pixelColor.clone();
            }
            this.frame = null;
            this.thumb = null;
            return this.get_pixel(n, n2).clone();
        }

        public PixelColor update(int n, int n2, PixelColor pixelColor, boolean bl) {
            if (!bl && n == this.last_x && n2 == this.last_y) {
                return null;
            }
            this.last_x = n;
            this.last_y = n2;
            if (RGBmtx.this.color_mode) {
                return this.set_pixel(n, n2, pixelColor);
            }
            return this.set_colored_pixel(n, n2, pixelColor);
        }

        public Frame clone() {
            Frame frame = new Frame(this.cols, this.rows);
            frame.set_pixels(this.pixs);
            return frame;
        }

        public void shift_left() {
            int n = 0;
            while (n < this.rows) {
                int n2 = 0;
                while (n2 < this.cols) {
                    this.set_pixel(n2, n, n2 < this.cols - 1 ? this.get_pixel(n2 + 1, n) : null);
                    ++n2;
                }
                ++n;
            }
        }

        public void shift_right() {
            int n = 0;
            while (n < this.rows) {
                int n2 = this.cols - 1;
                while (n2 >= 0) {
                    this.set_pixel(n2, n, n2 > 0 ? this.get_pixel(n2 - 1, n) : null);
                    --n2;
                }
                ++n;
            }
        }

        public void shift_up() {
            int n = 0;
            while (n < this.rows) {
                int n2 = 0;
                while (n2 < this.cols) {
                    this.set_pixel(n2, n, n < this.rows - 1 ? this.get_pixel(n2, n + 1) : null);
                    ++n2;
                }
                ++n;
            }
        }

        public void shift_down() {
            int n = this.rows - 1;
            while (n >= 0) {
                int n2 = 0;
                while (n2 < this.cols) {
                    this.set_pixel(n2, n, n > 0 ? this.get_pixel(n2, n - 1) : null);
                    ++n2;
                }
                --n;
            }
        }

        public void meteor() {
            this.shift_down();
            int n = 0;
            while (n < this.cols) {
                if (RGBmtx.this.random(20.0f) <= 1.0f && (this.get_pixel((int)n, (int)0).r == 0 || this.get_pixel((int)n, (int)0).g == 0 || this.get_pixel((int)n, (int)0).b == 0)) {
                    this.get_pixel((int)n, (int)0).r = 255;
                    this.get_pixel((int)n, (int)0).g = 255;
                    this.get_pixel((int)n, (int)0).b = 255;
                }
                ++n;
            }
            int n2 = this.rows - 1;
            while (n2 > 0) {
                n = 0;
                while (n < this.cols) {
                    if (this.get_pixel((int)n, (int)n2).r > 4) {
                        this.get_pixel((int)n, (int)(n2 - 1)).r = this.get_pixel((int)n, (int)n2).r - this.get_pixel((int)n, (int)n2).r / 2;
                        this.get_pixel((int)n, (int)(n2 - 1)).g = this.get_pixel((int)n, (int)n2).g - this.get_pixel((int)n, (int)n2).g / 2;
                        this.get_pixel((int)n, (int)(n2 - 1)).b = this.get_pixel((int)n, (int)n2).b - this.get_pixel((int)n, (int)n2).b / 2;
                    }
                    ++n;
                }
                --n2;
            }
        }

        public void snow() {
            this.shift_down();
            int n = 0;
            while (n < this.cols) {
                if (RGBmtx.this.random(20.0f) <= 1.0f) {
                    this.set_pixel(n, 0, new PixelColor(255, 255, 255));
                }
                ++n;
            }
        }

        private int pos(int n, int n2) {
            return n2 * this.cols + n;
        }

        private PixelColor set_letter(char c, PFont pFont, PixelColor pixelColor) {
            return this.set_letter(c, pFont, pixelColor, 50);
        }

        private PixelColor set_letter(char c, PFont pFont, PixelColor pixelColor, int n) {
            PixelColor pixelColor2 = null;
            int n2 = 0;
            this.pg.beginDraw();
            this.pg.fill(-65536);
            this.pg.background(0);
            this.pg.textFont(pFont, (float)(10 * this.letter_scale));
            this.pg.text(c, 0.0f, (float)(8 * this.letter_scale));
            this.pg.endDraw();
            this.pg.loadPixels();
            int n3 = 0;
            while (n3 < 10) {
                int n4 = 0;
                int n5 = 0;
                while (n5 < 8) {
                    if (this.get_pixs(n3, n5) > n) {
                        pixelColor2 = this.set_colored_pixel(n5, n3 - n2, pixelColor);
                        ++n4;
                    }
                    ++n5;
                }
                if (n4 == 0 && n2 < 2) {
                    ++n2;
                }
                if (n3 - n2 == 7) {
                    return pixelColor2;
                }
                ++n3;
            }
            return pixelColor2;
        }

        private int get_pixs(int n, int n2) {
            int n3 = 0;
            n *= this.letter_scale;
            n2 *= this.letter_scale;
            int n4 = 0;
            while (n4 < this.letter_scale) {
                int n5 = 0;
                while (n5 < this.letter_scale) {
                    n3 = (int)((float)n3 + RGBmtx.this.red(this.pg.pixels[(n + n4) * 8 * this.letter_scale + n2 + n5]));
                    ++n5;
                }
                ++n4;
            }
            return n3 / (this.letter_scale * this.letter_scale);
        }
    }

    class FrameChooser
    extends RectButton {
        int frame_width;
        int show_frames;

        FrameChooser(int n, int n2, int n3, int n4) {
            super(n, n2, n3 * n4, n3, -15658735, -256);
            this.frame_width = n3;
            this.show_frames = n4;
            this.enable();
        }

        public boolean display() {
            if (this.hidden) {
                return false;
            }
            int n = 0;
            while (n < this.show_frames) {
                int n2 = this.get_frame_nr(n);
                this.display_frame(this.x + this.frame_width * n, this.y, n2);
                ++n;
            }
            return true;
        }

        private void display_frame(int n, int n2, int n3) {
            RGBmtx.this.noFill();
            RGBmtx.this.stroke(n3 == RGBmtx.this.matrix.current_frame_nr ? this.highlightcolor : this.basecolor);
            RGBmtx.this.rect(n, this.y, this.frame_width - 10, this.frame_width - 10);
            if (n3 < 0 || n3 >= RGBmtx.this.matrix.num_frames()) {
                return;
            }
            RGBmtx.this.image((PImage)RGBmtx.this.matrix.frame(n3).draw_thumb(6, 4), n + 1, n2 + 1);
            RGBmtx.this.fill(255);
            RGBmtx.this.noStroke();
            RGBmtx.this.textFont(RGBmtx.this.fontA, 15.0f);
            RGBmtx.this.text(n3 + 1, n + 20, n2 + 62);
        }

        public boolean clicked() {
            if (!super.clicked()) {
                return false;
            }
            int n = this.get_frame_nr((RGBmtx.this.mouseX - this.x) / this.frame_width);
            if (n >= RGBmtx.this.matrix.num_frames()) {
                return false;
            }
            RGBmtx.this.matrix.current_frame_nr = n;
            return true;
        }

        public boolean key_pressed(int n, boolean bl, boolean bl2, boolean bl3) {
            if (this.disabled) {
                return false;
            }
            if (bl || bl2 || bl3) {
                return false;
            }
            if (n == 37) {
                RGBmtx.this.matrix.previous_frame();
            }
            if (n == 39) {
                RGBmtx.this.matrix.next_frame();
            }
            return n == 37 || n == 39;
        }

        private int get_frame_nr(int n) {
            return RGBmtx.this.matrix.current_frame_nr > this.show_frames - 1 ? RGBmtx.this.matrix.current_frame_nr - (this.show_frames - 1) + n : n;
        }
    }

    class GuiElement {
        int x;
        int y;
        int basecolor;
        boolean hidden = false;
        boolean disabled = false;
        private boolean old_disabled = false;

        GuiElement(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.basecolor = n3;
        }

        public void disable() {
            this.old_disabled = this.disabled;
            this.disabled = true;
        }

        public void enable() {
            this.old_disabled = this.disabled;
            this.disabled = false;
        }

        public void toggle() {
            this.disabled = this.old_disabled;
            this.hidden = false;
        }

        public void hide() {
            this.hidden = true;
            this.disable();
        }

        public void show() {
            this.hidden = false;
            this.enable();
        }

        public boolean display() {
            if (this.hidden) {
                return false;
            }
            RGBmtx.this.stroke(30);
            RGBmtx.this.fill(this.current_color());
            return true;
        }

        protected int current_color() {
            return this.basecolor;
        }
    }

    class Matrix {
        ArrayList frames = new ArrayList();
        public int rad = 70;
        int border = 10;
        public int rows = 0;
        public int cols = 0;
        public PixelColor current_color;
        Frame copy_frame;
        int SCALE = 1;
        int current_frame_nr;

        Matrix(int n, int n2) {
            this.cols = n;
            this.rows = n2;
            this.current_color = new PixelColor();
            this.add_frame();
        }

        public int width() {
            return this.cols * this.rad;
        }

        public int height() {
            return this.rows * this.rad;
        }

        public PGraphics current_frame_image() {
            return this.current_frame_image(this.rad, this.border);
        }

        public PGraphics current_frame_image(int n, int n2) {
            return this.current_frame().draw_full(n, n2);
        }

        public boolean click(int n, int n2, boolean bl) {
            if (n < 0 || n2 < 0) {
                return false;
            }
            if (n > this.width() + 25 || n2 > this.height() + 25) {
                return false;
            }
            PixelColor pixelColor = this.current_frame().update(n / this.rad, n2 / this.rad, this.current_color, !bl);
            if (pixelColor == null) {
                return false;
            }
            this.current_color = pixelColor.clone();
            return true;
        }

        public int num_frames() {
            return this.frames.size();
        }

        public Frame next_frame() {
            this.current_frame_nr = (this.current_frame_nr + 1) % this.num_frames();
            return this.current_frame();
        }

        public Frame previous_frame() {
            this.current_frame_nr = this.current_frame_nr == 0 ? this.num_frames() - 1 : this.current_frame_nr - 1;
            return this.current_frame();
        }

        public Frame first_frame() {
            this.current_frame_nr = 0;
            return this.current_frame();
        }

        public Frame meteor() {
            this.current_frame().meteor();
            return this.current_frame();
        }

        public Frame snow() {
            this.current_frame().snow();
            return this.current_frame();
        }

        public Frame current_frame() {
            return this.frame(this.current_frame_nr);
        }

        public Frame frame(int n) {
            try {
                return (Frame)this.frames.get(n);
            }
            catch (Exception exception) {
                return (Frame)this.frames.get(0);
            }
        }

        public void set_pixel(int n, int n2, int n3, PixelColor pixelColor) {
            this.frame(n).set_colored_pixel(n2, n3, pixelColor);
        }

        public Frame copy_frame() {
            this.copy_frame = this.current_frame().clone();
            return this.current_frame();
        }

        public Frame paste_frame() {
            if (this.copy_frame != null) {
                this.frames.set(this.current_frame_nr, this.copy_frame.clone());
            }
            return this.current_frame();
        }

        public Frame add_frame() {
            if (!this.frames.isEmpty()) {
                ++this.current_frame_nr;
            }
            this.frames.add(this.current_frame_nr, new Frame(this.cols, this.rows));
            return this.current_frame();
        }

        public Frame insert_first_frame() {
            this.current_frame_nr = 0;
            this.frames.add(this.current_frame_nr, new Frame(this.cols, this.rows));
            return this.current_frame();
        }

        public Frame delete_first_frame() {
            if (this.num_frames() > 0) {
                this.current_frame_nr = 0;
                this.frames.remove(this.current_frame_nr);
            }
            return this.current_frame();
        }

        public Frame delete_frame() {
            RGBmtx.this.matrix.copy_frame();
            if (this.num_frames() > 1) {
                this.frames.remove(this.current_frame_nr);
                this.current_frame_nr %= this.num_frames();
            }
            return this.current_frame();
        }

        public void save_bmp(String string) {
            int n = (int)Math.sqrt(this.num_frames());
            while (this.num_frames() % n != 0) {
                --n;
            }
            int n2 = this.num_frames() / n;
            PImage pImage = RGBmtx.this.createImage(n2 * this.cols, n * this.rows, 1);
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    Frame frame = this.frame(n3 * n2 + n4);
                    int n5 = 0;
                    while (n5 < frame.rows) {
                        int n6 = 0;
                        while (n6 < frame.cols) {
                            pImage.set(n6 + frame.cols * n4, n5 + frame.rows * n3, frame.get_pixel(n6, n5).get_color());
                            ++n6;
                        }
                        ++n5;
                    }
                    ++n4;
                }
                ++n3;
            }
            pImage.save(string);
        }

        public void save_mtx(String string) {
            PrintWriter printWriter = RGBmtx.this.createWriter(string);
            printWriter.println(String.valueOf(this.num_frames()) + "," + this.rows + "," + this.cols + "," + RGBmtx.this.current_speed);
            int n = 0;
            while (n < this.num_frames()) {
                Frame frame = this.frame(n);
                int n2 = 0;
                while (n2 < frame.rows) {
                    int n3 = 0;
                    while (n3 < frame.cols) {
                        PixelColor pixelColor = frame.get_pixel(n3, n2);
                        printWriter.print(String.valueOf(pixelColor.r) + "," + pixelColor.g + "," + pixelColor.b + ",");
                        ++n3;
                    }
                    ++n2;
                }
                printWriter.println();
                ++n;
            }
            printWriter.flush();
            printWriter.close();
        }

        public void save_to_file() {
            String string = RGBmtx.this.selectOutput();
            if (string == null) {
                RGBmtx.println((String)"No output file was selected...");
                return;
            }
            if (RGBmtx.match((String)string, (String)".mtx") != null) {
                this.save_mtx(string);
            } else {
                if (RGBmtx.match((String)string, (String)".bmp") == null) {
                    string = String.valueOf(string) + ".bmp";
                }
                this.save_bmp(string);
            }
            RGBmtx.println((String)("SAVED to " + string));
        }

        public Matrix load_from_file() {
            String string = RGBmtx.this.selectInput("Choose a Matrix File to load");
            if (string == null) {
                RGBmtx.println((String)"No file was selected...");
                return this;
            }
            if (RGBmtx.match((String)string, (String)".mtx") != null) {
                return this.load_mtx(string);
            }
            return this.load_bmp(string);
        }

        public Matrix load_mtx(String string) {
            Matrix matrix = new Matrix(this.cols, this.rows);
            Frame frame = matrix.current_frame();
            BufferedReader bufferedReader = RGBmtx.this.createReader(string);
            String string2 = "";
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return matrix;
            }
            String[] stringArray = string2.split(",");
            Integer.parseInt(stringArray[0]);
            Integer.parseInt(stringArray[1]);
            Integer.parseInt(stringArray[2]);
            RGBmtx.this.current_speed = Integer.parseInt(stringArray[3]);
            string2 = "";
            while (string2 != null) {
                try {
                    string2 = bufferedReader.readLine();
                    if (string2 == null || string2.length() <= 0) continue;
                    stringArray = string2.split(",");
                    int n = 0;
                    PixelColor pixelColor = new PixelColor();
                    int n2 = 0;
                    while (n2 < frame.rows) {
                        int n3 = 0;
                        while (n3 < frame.cols) {
                            pixelColor.r = Integer.parseInt(stringArray[n++]);
                            pixelColor.g = Integer.parseInt(stringArray[n++]);
                            pixelColor.b = Integer.parseInt(stringArray[n++]);
                            frame.set_pixel(n3, n2, pixelColor);
                            ++n3;
                        }
                        ++n2;
                    }
                    frame = matrix.add_frame();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return matrix;
                }
            }
            matrix.delete_frame();
            return matrix;
        }

        public Matrix load_bmp(String string) {
            Matrix matrix = new Matrix(this.cols, this.rows);
            PImage pImage = RGBmtx.this.loadImage(string);
            pImage.loadPixels();
            int n = pImage.width / this.cols / this.SCALE;
            int n2 = pImage.height / this.rows / this.SCALE;
            Frame frame = matrix.current_frame();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = 0;
                    while (n5 < frame.rows) {
                        int n6 = 0;
                        while (n6 < frame.cols) {
                            int n7 = n3 * n * frame.cols * frame.rows + n4 * frame.cols + n5 * (frame.cols * n) + n6;
                            int n8 = pImage.pixels[n7 * this.SCALE];
                            frame.get_pixel(n6, n5).set_color(n8);
                            ++n6;
                        }
                        ++n5;
                    }
                    frame = matrix.add_frame();
                    ++n4;
                }
                ++n3;
            }
            matrix.delete_frame();
            return matrix;
        }
    }

    class MiniColorButton
    extends RectButton {
        PixelColor px;

        MiniColorButton(int n, int n2, int n3, int n4, PixelColor pixelColor) {
            super(n, n2, n3, n4, pixelColor.get_color(), pixelColor.get_color());
            this.px = pixelColor;
        }

        public boolean clicked() {
            if (!super.clicked()) {
                return false;
            }
            if (RGBmtx.this.keyCtrl) {
                this.choose_color();
                RGBmtx.this.keyCtrl = false;
            } else {
                RGBmtx.this.matrix.current_color.set_color(this.px);
            }
            return true;
        }

        public void choose_color() {
            Color color = new Color(RGBmtx.this.matrix.current_color.r, RGBmtx.this.matrix.current_color.g, RGBmtx.this.matrix.current_color.b);
            Color color2 = ColorPicker.showDialog(null, (Color)color);
            if (color2 != null) {
                int n = RGBmtx.this.color(color2.getRed(), color2.getGreen(), color2.getBlue());
                this.px.set_color(n);
                this.basecolor = n;
                this.highlightcolor = n;
                RGBmtx.this.matrix.current_color.set_color(n);
            }
        }

        public boolean display() {
            if (!super.display()) {
                return false;
            }
            if (RGBmtx.this.matrix.current_color.equal(this.px)) {
                RGBmtx.this.stroke(-256);
                RGBmtx.this.strokeWeight(2.0f);
                RGBmtx.this.rect(this.x - 1, this.y - 1, this.width - 1, this.height + 2);
                RGBmtx.this.strokeWeight(0.0f);
            }
            return true;
        }
    }

    class ModeButton
    extends ActionButton {
        String[] button_texts;
        int mode_idx;

        ModeButton(String string, String string2, int n, int n2) {
            this(string, string2, n, n2, 134, 25, -12303292, -6710887);
        }

        ModeButton(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6) {
            super(string, string2, n, n2, n3, n4, n5, n6);
            this.mode_idx = 0;
            this.button_texts = new String[RGBmtx.this.mode_cnt];
            this.button_texts[0] = "Record";
            this.button_texts[1] = "Play";
            this.button_texts[2] = "Plasma";
            this.button_texts[3] = "Snow";
            this.button_texts[4] = "Meteor";
            this.button_texts[5] = "Music";
        }

        protected String current_text() {
            return String.valueOf(this.button_text) + this.button_texts[this.mode_idx];
        }

        protected void perform_action() {
            if (++this.mode_idx >= RGBmtx.this.mode_cnt) {
                this.mode_idx = 0;
            }
            RGBmtx.this.set_mode(this.mode_idx);
        }
    }

    class PixelColor {
        public int r;
        public int g;
        public int b;

        PixelColor() {
            this(0, 0, 0);
        }

        PixelColor(int n, int n2, int n3) {
            this.set_color(n, n2, n3);
        }

        public PixelColor next_color() {
            this.set_color_index(this.to_int() + 1);
            return this;
        }

        public PixelColor previous_color() {
            this.set_color_index(this.to_int() - 1);
            return this;
        }

        public int numColors() {
            if (Config.rgbmode) {
                return 0x1000000;
            }
            return PixelColorScheme.R.length * PixelColorScheme.G.length * PixelColorScheme.B.length;
        }

        public boolean equal(PixelColor pixelColor) {
            if (pixelColor == null) {
                return true;
            }
            return this.r == pixelColor.r && this.g == pixelColor.g && this.b == pixelColor.b;
        }

        public void set_color(PixelColor pixelColor) {
            if (pixelColor == null) {
                return;
            }
            this.r = pixelColor.r;
            this.g = pixelColor.g;
            this.b = pixelColor.b;
        }

        public void set_color(int n, int n2, int n3) {
            this.r = n;
            this.g = n2;
            this.b = n3;
        }

        public void set_color_index(int n) {
            if (!Config.rgbmode) {
                if ((n %= this.numColors()) < 0) {
                    n += this.numColors();
                }
                this.r = n / (PixelColorScheme.G.length * PixelColorScheme.B.length);
                this.g = n / PixelColorScheme.B.length - this.r * PixelColorScheme.G.length;
                this.b = n - (this.r * PixelColorScheme.G.length + this.g) * PixelColorScheme.B.length;
            }
        }

        public void set_color(int n) {
            if (Config.rgbmode) {
                this.r = PApplet.parseInt((float)RGBmtx.this.red(n));
                this.g = PApplet.parseInt((float)RGBmtx.this.green(n));
                this.b = PApplet.parseInt((float)RGBmtx.this.blue(n));
            } else {
                int n2 = PixelColorScheme.R.length - 1;
                this.r = PApplet.parseInt((float)(RGBmtx.this.red(n) / (float)PixelColorScheme.R[n2] * (float)n2));
                n2 = PixelColorScheme.G.length - 1;
                this.g = PApplet.parseInt((float)(RGBmtx.this.green(n) / (float)PixelColorScheme.G[n2] * (float)n2));
                n2 = PixelColorScheme.B.length - 1;
                this.b = PApplet.parseInt((float)(RGBmtx.this.blue(n) / (float)PixelColorScheme.B[n2] * (float)n2));
            }
        }

        public PixelColor clone() {
            return new PixelColor(this.r, this.g, this.b);
        }

        public int get_color() {
            if (Config.rgbmode) {
                return RGBmtx.this.color(this.r, this.g, this.b);
            }
            return RGBmtx.this.color(PixelColorScheme.R[this.r], PixelColorScheme.G[this.g], PixelColorScheme.B[this.b]);
        }

        public int to_int() {
            return (this.r * PixelColorScheme.G.length + this.g) * PixelColorScheme.B.length + this.b;
        }
    }

    static class PixelColorScheme {
        public static int[] R = new int[0];
        public static int[] G = new int[0];
        public static int[] B = new int[0];

        PixelColorScheme() {
        }
    }

    class RectButton
    extends Button {
        int width;
        int height;

        RectButton(int n, int n2, int n3, int n4, int n5) {
            this(n, n2, n3, n4, n5, n5);
        }

        RectButton(int n, int n2, int n3, int n4, int n5, int n6) {
            super(n, n2, n5, n6);
            this.width = n3;
            this.height = n4;
        }

        public boolean over() {
            boolean bl = this.over;
            this.over = this.overRect(this.x, this.y, this.width, this.height);
            return this.over ^ bl;
        }

        public boolean display() {
            if (!super.display()) {
                return false;
            }
            RGBmtx.this.rect(this.x, this.y, this.width, this.height);
            return true;
        }
    }

    class SquareButton
    extends RectButton {
        SquareButton(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n3, n4, n5);
        }
    }

    public static interface StandaloneDevice {
        public Matrix read_matrix();

        public void write_matrix(Matrix var1);

        public void toggle();

        public void speedUp();

        public void speedDown();

        public void brightnessUp();

        public void brightnessDown();
    }

    class TextButton
    extends RectButton {
        String button_text;
        public int text_color;
        float x_offset;
        float y_offset;

        TextButton(String string, int n, int n2, int n3, int n4, int n5, int n6) {
            super(n, n2, n3, n4, n5, n6);
            this.button_text = string;
        }

        public boolean display() {
            if (!super.display()) {
                return false;
            }
            RGBmtx.this.textFont(RGBmtx.this.fontA, 15.0f);
            RGBmtx.this.fill(this.current_text_color());
            this.update_offset();
            RGBmtx.this.text(this.current_text(), this.x_offset, this.y_offset);
            return true;
        }

        protected int current_text_color() {
            return this.disabled ? -10066330 : -1;
        }

        protected String current_text() {
            return this.button_text;
        }

        protected void update_offset() {
            this.x_offset = (float)this.x + ((float)this.width - RGBmtx.this.textWidth(this.current_text())) / 2.0f;
            this.y_offset = this.y + 17;
        }
    }

    class TextElement
    extends TextButton {
        TextElement(String string, int n, int n2) {
            super(string, n, n2, 0, 0, -16777216, -16777216);
            this.disable();
        }

        protected int current_text_color() {
            return -1;
        }

        protected void update_offset() {
            this.x_offset = this.x;
            this.y_offset = this.y + 25;
        }
    }
}

